<?php
declare(strict_types=1);


/**
 * POST /api/sor
 * Body JSON:
 * {
 *   "paciens_id": 5678,
 *   "rendelo": "Rendelo2",
 *   "user_email": "tmp-2@wfs.hu"   // optional
 * }
 */

/* =========================
   CONFIG (AZ ELEJEN)
   ========================= */

const DEBUG = false;

const LINK_PREFIX="https://dev.ceedback.com/hu/kerdoiv/82565-91548/";

// FIX beolvasas ID:
// FK ismerv_csoportok: 36
const BEOLVASAS_ID = 2130;

// --- ismervek ID mapping (TE ADOD MEG) ---
// Ismerv_csoportok: 36
const ISMERV_ID_RENDELO    = 212;
const ISMERV_ID_PACIENS_ID = 211;

// --- Basic Auth ---
const GI_API_USER = 'client';
const GI_API_PASS = '12345678';

// --- DB connection ---
const DB_DSN  = 'mysql:host=127.0.0.1;dbname=dev5.ceedback.com;charset=utf8mb4';
const DB_USER = 'restapi';
const DB_PASS = 'L5btKGCgyGzNgIoq';

/* ========================= */

header('Content-Type: application/json; charset=utf-8');

function respond(int $code, array $payload, array $headers = []): void {
    http_response_code($code);
    foreach ($headers as $k => $v) header($k . ': ' . $v);
    echo json_encode($payload, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
    exit;
}

function get_basic_auth_credentials(): array {
    $user = $_SERVER['PHP_AUTH_USER'] ?? null;
    $pass = $_SERVER['PHP_AUTH_PW'] ?? null;
    if ($user !== null && $pass !== null) return [$user, $pass];

    $auth = $_SERVER['HTTP_AUTHORIZATION'] ?? $_SERVER['REDIRECT_HTTP_AUTHORIZATION'] ?? null;

    if ($auth === null && function_exists('getallheaders')) {
        $h = getallheaders();
        if (is_array($h)) {
            foreach ($h as $k => $v) {
                if (strtolower((string)$k) === 'authorization') { $auth = $v; break; }
            }
        }
    }

    if (is_string($auth) && stripos($auth, 'Basic ') === 0) {
        $b64 = trim(substr($auth, 6));
        $decoded = base64_decode($b64, true);
        if ($decoded !== false && str_contains($decoded, ':')) {
            [$u, $p] = explode(':', $decoded, 2);
            return [$u, $p];
        }
    }

    return [null, null];
}

function require_basic_auth(): void {
    [$u, $p] = get_basic_auth_credentials();
    $ok = is_string($u) && is_string($p)
        && hash_equals(GI_API_USER, $u)
        && hash_equals(GI_API_PASS, $p);

    if (!$ok) {
        respond(
            401,
            ['ok' => false, 'error' => 'Unauthorized'],
            ['WWW-Authenticate' => 'Basic realm="API", charset="UTF-8"']
        );
    }
}

require_basic_auth();

// Route: POST /restapi/affidea.php
$method = $_SERVER['REQUEST_METHOD'] ?? 'GET';
$path   = parse_url($_SERVER['REQUEST_URI'] ?? '/', PHP_URL_PATH) ?: '/';

if ($method !== 'POST' || $path !== '/restapi/affidea.php') {
    respond(404, ['ok' => false, 'error' => 'Not found']);
}

// Fixed ID from config
$beolvasasId = BEOLVASAS_ID;

// JSON body
$raw  = file_get_contents('php://input');
$data = json_decode($raw ?: '', true);
if (!is_array($data)) respond(400, ['ok' => false, 'error' => 'Invalid JSON body']);

$paciensId = $data['paciens_id'] ?? null;
$rendelo   = $data['rendelo'] ?? null;
$userEmail = (string)($data['user_email'] ?? '');

if (!is_string($paciensId) || trim($paciensId) === '') {
    respond(400, ['ok' => false, 'error' => 'paciens_id is required']);
}
$paciensId = trim($paciensId);

if (!is_string($rendelo) || trim($rendelo) === '') {
    respond(400, ['ok' => false, 'error' => 'rendelo is required']);
}
$rendelo = trim($rendelo);

// quick sanity: mapping numbers should be positive
if (ISMERV_ID_PACIENS_ID <= 0 || ISMERV_ID_RENDELO <= 0) {
    respond(500, ['ok' => false, 'error' => 'Invalid ismervek mapping constants']);
}



try {
    $pdo = new PDO(DB_DSN, DB_USER, DB_PASS, [
        PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    ]);

    // opcionális, de hasznos: a fix BEOLVASAS_ID letezik-e?
    $stmt = $pdo->prepare('SELECT id FROM beolvasas WHERE id = :id');
    $stmt->execute([':id' => $beolvasasId]);
    if (!$stmt->fetch()) {
        respond(500, [
            'ok' => false,
            'error' => 'Configured BEOLVASAS_ID not found in beolvasas table',
            'beolvasas_id' => $beolvasasId
        ]);
    }

    $pdo->beginTransaction();

    // 1) MINDIG uj sor a beolvasas_sorok-ba
    $stmt = $pdo->prepare("
        INSERT INTO beolvasas_sorok (user_id, user_email, fk_beolvasas)
        VALUES (:uid, :em, :b)
    ");
    $stmt->execute([
        ':uid' => $paciensId,
        ':em'  => $userEmail,
        ':b'   => $beolvasasId
    ]);
    $beolvasasSorId = (int)$pdo->lastInsertId();

    // 2) ket ismerv ertek a beolvasas_sorok_ismervek-be
    // Ha nalad az ertek oszlop neve nem 'ismerv', itt ird at!
    $ins = $pdo->prepare("
        INSERT INTO beolvasas_sorok_ismervek (fk_beolvasas_sorok, fk_ismervek, ismerv)
        VALUES (:sor, :ismid, :val)
    ");

    // paciens_id
    $ins->execute([
        ':sor'   => $beolvasasSorId,
        ':ismid' => ISMERV_ID_PACIENS_ID,
        ':val'   => (string)$paciensId
    ]);

    // rendelo
    $ins->execute([
        ':sor'   => $beolvasasSorId,
        ':ismid' => ISMERV_ID_RENDELO,
        ':val'   => $rendelo
    ]);

    $pdo->commit();


function num_encrypt($num) {
    // 7.4: nincs union type, legyen mindig string
    $num = (float)$num;

    $prec = ini_get('precision');
    ini_set('precision', '14');

    $n = log($num + sqrt(pow($num, 2) + 1));

    $n = (string)$n;
    $n = str_replace(array('.', ','), '|', $n);
    $n2 = explode('|', $n);

    $l = strlen($n2[0]);
    $n = $l . str_replace('|', '', $n);
    $n = strrev($n);

    ini_set('precision', (string)$prec);
    return $n;
}



    respond(201, [
        'ok' => true,
        'beolvasas_id' => $beolvasasId,
        'link' => LINK_PREFIX . num_encrypt((float)$beolvasasSorId),
        'beolvasas_sor_id' => $beolvasasSorId,
        'mapping' => [
            'paciens_id' => ISMERV_ID_PACIENS_ID,
            'rendelo' => ISMERV_ID_RENDELO
        ],
        'saved' => [
            'paciens_id' => $paciensId,
            'rendelo' => $rendelo,
            'user_email' => $userEmail
        ]
    ]);

} catch (Throwable $e) {
    if (isset($pdo) && $pdo->inTransaction()) $pdo->rollBack();
    if (DEBUG) respond(500, ['ok' => false, 'error' => 'Server error', 'detail' => $e->getMessage()]);
    respond(500, ['ok' => false, 'error' => 'Server error']);
}
