<?php

$jelentes = json_decode($_POST['jelentes'], true);

// parameter ellenorzese
$kapcsoloTabla = [
    'fej' => 'boolint',
    'eszkoz_azonosito' => 'ex-eszkozok-eszkoz_azonosito',
    'beolvasas_sor' => 'encrypted_sn_beolvasas_sor_cbe',
    'idopont' => 'int',
    'egyedi_user_id' => 'valasz_ertek'
];

$tetelKapcsoloTabla = [
    'jelentes_fej_id' => 'ex-jelentesek_fej-id',
    'kerdes_id' => 'ex-kerdoivek_kerdesek-id',
    'valasz_sorszam' => 'int',
    'valasz_ertek' => 'valasz_ertek'
];
/*
foreach ($kapcsoloTabla as $oszlop => $validator) {
    if (substr($validator, -4) === '_cbe') {
        if (!isset($jelentes[$oszlop]) || $jelentes[$oszlop] === '') {
            continue;
        } else {
            $validator = substr($validator, 0, -4);
        }
    }
    if (!isset($jelentes[$oszlop]) || !\GI\Functions::validate($jelentes[$oszlop], $validator)) {
       exit(json_encode(['HI', 'rossz_parameter_ertek', $oszlop]));
    }
}
*/
$kerdoiv_id = $g['db_db']->get_kerdoiv_id_from_azonosito(
    $jelentes['eszkoz_azonosito']
);
if (isset($kerdoiv_id[0])) {
    $kerdoiv_id = $kerdoiv_id[0]['fk_kerdoivek'];
}

if ($jelentes['fej'] === '0') {
    foreach ($tetelKapcsoloTabla as $oszlop => $validator) {
        if (!isset($jelentes[$oszlop]) || !\GI\Functions::validate($jelentes[$oszlop], $validator)) {
           exit(json_encode(['HI', 'rossz_parameter_ertek', $oszlop]));
        }
        // ellenorzes hogy a kerdes tenyleg ahhoz a kerdoivhez tartozik-e
        if ($oszlop == 'kerdes_id') {
            if (
                $g['db_db']->is_kerdes_of_kerdoiv($jelentes['kerdes_id'], $kerdoiv_id)[0]['cnt'] === '0' &&
                $g['db_db']->is_rsz_kerdes_of_kerdoiv($jelentes['kerdes_id'], $kerdoiv_id)[0]['cnt'] === '0'
            ) {
                exit(json_encode(['HI', 'rossz_parameter_ertek', $oszlop]));
            }
        }
    }
}

$eszkoz_id = $g['db_db']->get_eszkoz_id_from_azonosito($jelentes['eszkoz_azonosito'])[0]['id'];

// hogy van-e jelentes fej mar
if ($g['db_db']->isset_jelentes_fej($eszkoz_id, $kerdoiv_id)[0]['cnt'] === '0' && $jelentes['fej'] !== '1') {
    exit(json_encode(['HI', 'nincs_fej']));
}

// ertesites rules lekerdezese
$ertesitesek = [];
$kerdoivErtesitesek = $g['db_db']->get_kerdoiv_ertesites_rules();
foreach ($kerdoivErtesitesek as $kerdoivErtesites) {
    if (!array_key_exists($kerdoivErtesites['fk_kerdoivek_kerdesek'], $ertesitesek)) {
        $ertesitesek[$kerdoivErtesites['fk_kerdoivek_kerdesek']] = [];
    }

    $ertesitesek[$kerdoivErtesites['fk_kerdoivek_kerdesek']] []= $kerdoivErtesites['valasz_sorszam'];
}
unset($kerdoivErtesitesek);

// jelentes-new
$eszkoz_id = $g['db_db']->get_eszkoz_id_from_azonosito($jelentes['eszkoz_azonosito'])[0]['id'];
if ($jelentes['fej'] === '1') {
    $telephely_id = $g['db_db']->get_telephely_id_of_eszkoz($eszkoz_id)[0]['fk_telephelyek'];
    $partner_id = $g['db_db']->get_partner_id_of_telephely($telephely_id)[0]['fk_partnerek'];
    if (isset($jelentes['beolvasas_sor'])) {
        if (!empty($jelentes['beolvasas_sor'])) {
            $fk_beolvasas_sorok = \GI\Functions::num_decrypt($jelentes['beolvasas_sor']);
        } else {
            $fk_beolvasas_sorok = null;
        }
    } else {
        $fk_beolvasas_sorok = null;
    }
    $g['db_db']->jelentes_fej_new(
        $eszkoz_id,
        $kerdoiv_id,
        $telephely_id,
        $partner_id,
        null,
        null,
        null,
        $fk_beolvasas_sorok,
        date('Y-m-d H:i:s', $jelentes['idopont']),
        null,
        isset($jelentes['egyedi_user_id']) ? $jelentes['egyedi_user_id'] : null,
        !empty($sor['uuid']) ? $sor['uuid'] : null
    );
    $jelentes_fej_id = $g['db_db']->get_max_jelentes_fej_id(
        $eszkoz_id,
        $kerdoiv_id
    )[0]['id'];
} else {
    $jelentes_fej_ids = $g['db_db']->get_jelentes_fej_idk(
        $eszkoz_id,
        $kerdoiv_id
    );
    if (!in_array($jelentes['jelentes_fej_id'], array_column($jelentes_fej_ids, 'id'))) {
        exit(json_encode(['HI', 'rossz_parameter_ertek', 'jelentes_fej_id']));
    }

    $jelentes_fej_id = $jelentes['jelentes_fej_id'];

    if (strlen($jelentes['valasz_ertek']) == 0) {
        $jelentes['valasz_ertek'] = null;
    }

    $g['db_db']->jelentes_tetel_new(
        $jelentes_fej_id,
        $jelentes['kerdes_id'],
        $g['db_db']->get_kerdes_azonosito_by_id($jelentes['kerdes_id'])[0]['azonosito'],
        $jelentes['valasz_sorszam'],
        $jelentes['valasz_ertek'],
        date('Y-m-d H:i:s', $jelentes['idopont']),
        null,
        !empty($sor['uuid']) ? $sor['uuid'] : null
    );

    // ertesites kuldes bejegyzese
    if (array_key_exists($jelentes['kerdes_id'], $ertesitesek) && in_array($jelentes['valasz_sorszam'], $ertesitesek[$jelentes['kerdes_id']])) {
        $g['db_db']->kerdoiv_ertesitesek_kuldes(
            $jelentes['kerdes_id'],
            $jelentes['valasz_sorszam'],
            $eszkoz_id
        );   
    }
}

exit(json_encode(['OK', $jelentes_fej_id]));