<?php

    namespace A;

    use EE_API_URL;
    use EE_API_KEY;
    use EE_FROM;
    use EE_FROM_NAME;

    use ElasticEmailClient\ElasticClient;
    use ElasticEmailClient\ApiConfiguration;

    require_once '/var/www/ceedback/ceedback/gengine3.5/gi_ajax.php';
    require_once GI_PATH_SITE_AJAX . 'email_sablonok_elonezet.php';

    file_put_contents(__DIR__.'/../../logs/emailPOST.log', var_export($_POST, true) . PHP_EOL, FILE_APPEND);
    file_put_contents(__DIR__.'/../../logs/emailGET.log', var_export($_GET, true) . PHP_EOL, FILE_APPEND);

    $fromEmail = $_POST['from_email'];
    $fromName = $_POST['from_name'];
    $toEmail = $_POST['to_list'];

    if ($toEmail == 'survey@ceedback.eu') return;

    $partnerek = $g['db_db']->get_partner_by_email($toEmail);
    file_put_contents(__DIR__.'/../../logs/emailPOST.log', var_export($partnerek, true) . PHP_EOL, FILE_APPEND);
    if (!isset($partnerek[0])) return;
    
    $partner = $partnerek[0];
    $sablonok = $g['db_db']->get_sablon_by_partner($partner["id"]);
    file_put_contents(__DIR__.'/../../logs/emailPOST.log', var_export($sablonok, true) . PHP_EOL, FILE_APPEND);
    if (!isset($sablonok[0])) return;
    $sablon = $sablonok[0];
    
    $headers = $_POST['header_list'];
    $messageId = null;
    if (preg_match('/Message-ID:\s*<(.*?)>/i', $headers, $matches)) {
        $messageId = $matches[1];
    }


    $headerSending = [];
    if (isset($messageId)) {

        
        $headerSending['In-Reply-To'] = '<' . urlencode($messageId) .'>';
        $headerSending['References'] =  '<'. urlencode($messageId) .'>'; 

/*
    $messageIdClean = preg_replace('/\s+/', '', $messageId);
    $encoded = '=?UTF-8?B?'.base64_encode($messageIdClean).'?=';

    $headerSending['In-Reply-To'] = $encoded;
    $headerSending['References'] = $encoded;
*/
    }
    
    $configuration = new ApiConfiguration([
        'apiUrl' => EE_API_URL,
        'apiKey' => EE_API_KEY
    ]);
    $configuration->setTimeout(5.0);
    
    $client = new ElasticClient($configuration);
    
    $emailBody = \A\email_sablonok_elonezet::getEmailBody($sablon['id'], '');
    $emailBodyAlt = str_replace('[url]', '', $sablon['alt_text']);
    


    $client->Email->Send("Re: ".$_POST['subject'],
        $partner['email_kuldo_email_cime'],
        $partner['email_kuldo_neve'],
        null,
        null,
        null,
        null,
        null,
        null,
        [
            $fromEmail,
        ],
        [],
        [],
        [],
        [],
        [],
        null,
        null,
        '-ceedback-' . $g['srv'] . '-automatikus-valasz',
        $emailBody,
        $emailBodyAlt,
        'utf-8',
        null,
        null,
        0,
        null,
        [],
        $headerSending,
        null,
        [],
        null,
        null,
        false,
        [],
        "true",
        "true",
        null,
        null,
        null,
        null,
        null,
        null
    );
