<?php

    class Procedures
    {
        public static $get_kitoltes_tetel_szam = "
            select count(*) cnt
            from jelentesek_tetel
        ";

        public static $get_lang_list = "
            select
                *
            from lang_list
            where active = 1
        ";

        public static $get_admin_lang_list = "
            select *
            from lang_list
        ";

        public static $get_texts = "
            select *
            from texts
            where lang = ?
        ";

        public static $get_text = "
            select *
            from texts
            where lang = ?
            and label = ?
        ";

        public static $insert_text = "
            insert ignore into texts (`lang`,`label`)
            values (?,?)
        ";

        public static $delete_label = "
            delete from texts
            where label = ?
        ";

        public static $add_language = "
            insert into lang_list (`lang_code`,`lang_name`)
            values (?,?)
        ";

        public static $activate_language = "
            update lang_list
            set active = ?
            where lang_code = ?
        ";

        public static $delete_language = "
            delete from lang_list
            where lang_code = ?
        ";

        public static $delete_language_texts = "
            delete from texts
            where lang = ?
        ";

        public static $mod_language = "
            update lang_list
            set lang_name = ?
            where lang_code = ?
        ";

        public static $set_texts = "
            update texts
            set text = if(? = '0', ?, null), text_html = if(? = '1', ?, null)
            where label = ? and lang = ?
        ";

        public static $get_multiple_texts = "
            select label,text,text_html
            from texts
            where label in ([[labeltomb]])
        ";

        public static $isset_lang_code = "
            select count(*) as cnt
            from lang_list
            where lang_code = ?
        ";

        public static $isset_text_label = "
            select count(*) as cnt
            from texts
            where label = ?
        ";

        // rendszerparameterek

        public static $isset_rendszerparameter_id = "
            select count(*) as cnt
            from rendszerparameterek
            where id = ?
        ";

        public static $isset_rendszerparameter_ertek_id = "
            select count(*) as cnt
            from rendszerparameterek_ertekek
            where id = ?
        ";

        public static $isset_rendszerparameter_ertek = "
            select count(*) as cnt
            from rendszerparameterek_ertekek e
            left join rendszerparameterek r
            on r.id = e.rendszerparameter
            where r.name = ? and e.value = ?
        ";

        public static $is_utolso_rendszerparameter_ertek = "
            select count(*) as cnt
            from rendszerparameterek_ertekek
            where rendszerparameter = (select rendszerparameter from rendszerparameterek_ertekek where id = ?)
        ";

        public static $get_last_created_rendszerparameter_ertek_id = "
            select max(id) as id
            from rendszerparameterek_ertekek
            where rendszerparameter = ?
        ";

        public static $del_rendszerparameter_ertek = "
            delete from rendszerparameterek_ertekek
            where id = ?
        ";

        public static $get_one_rendszerparameter = "
            select re.value as ertek
            from rendszerparameterek as r
            left join rendszerparameterek_ertekek as re
            on r.id = re.rendszerparameter
            where r.name = ?
            order by re.id asc
            limit 1
        ";

        public static $mod_rendszerparameter_ertek = "
            update rendszerparameterek_ertekek
            set value = ?
            where id = ?
        ";

        public static $add_rendszerparameter_ertek = "
            insert into rendszerparameterek_ertekek
            (`rendszerparameter`, `value`)
            VALUES
            (?, ?)
        ";

        public static $sel_rendszerparameterek = "
            select
                r.id as rendszerparameter_id,
                re.id as rendszerparameter_ertek_id,
                r.name,
                r.tobb_ertek as lehet_tobb,
                re.value,
                (select text from texts where label = concat('rendszerparameter_', r.name) and lang = ?) as szoveg
            from rendszerparameterek as r
            left join rendszerparameterek_ertekek as re
            on r.id = re.rendszerparameter
        ";

        // dev rendszerparameterek

        public static $dev_rendszerparameterek_sel = "
            select *
            from rendszerparameterek
        ";

        public static $dev_rendszerparameterek_ertekek_sel = "
            select *
            from rendszerparameterek_ertekek
            where rendszerparameter = ?
        ";

        public static $dev_isset_rendszerparameter_nev = "
            select count(*) as cnt
            from rendszerparameterek
            where name = ?
        ";

        public static $dev_add_rendszerparameter = "
            insert into
            rendszerparameterek
            (`name`, `datatype`, `tobb_ertek`)
            values (?,?,?)
        ";

        public static $dev_get_rendszerparameter_id = "
            select id
            from rendszerparameterek
            where name = ?
        ";

        public static $dev_add_rendszerparameter_ertek = "
            insert into
            rendszerparameterek_ertekek
            (`rendszerparameter`, `value`)
            values (?,?)
        ";

        public static $get_rendszerparameter_ertekei = "
            select
                value as ertek
            from rendszerparameterek_ertekek
            where rendszerparameter = (select id from rendszerparameterek where name = ?)
        ";

        // bejelentkezes

        public static $check_login_adatok = "
            select id, nev, kitiltva, probalkozasok_szama
            from users
            where email = ? and password = ?
        ";

        public static $get_user_from_email = "
            select *
            from users
            where email = ?
        ";

        public static $probalkozasok_szama_sel = "
            select probalkozasok_szama
            from users
            where email = ?
        ";

        public static $probalkozasok_szama_novel = "
            update users
            set probalkozasok_szama = probalkozasok_szama + 1
            where email = ?
        ";

        public static $probalkozasok_szama_alap = "
            update users
            set probalkozasok_szama = 0
            where email = ?
        ";

        public static $user_login_alap = "
            update users
            set probalkozasok_szama = 0, kitiltva = ?
            where id = ?
        ";

        public static $user_kitiltasa = "
            update users
            set probalkozasok_szama = 0, kitiltva = 1
            where email = ?
        ";

        public static $isset_email = "
            select count(*) as cnt
            from users
            where email = ?
        ";

        // rendszerparameterek

        public static $rendszerparameter_fej_sel = "
            select
                *
            from rendszerparameterek
            where id = ?
        ";

        public static $rendszerparameter_fej_sel_from_ertek = "
            select
                *
            from rendszerparameterek
            where id = (select rendszerparameter from rendszerparameterek_ertekek where id = ?)
        ";

        public static $get_rendszerparameter_labels = "
            select
                name
            from rendszerparameterek
        ";

        public static $get_rendszerparameter_ertekek = "
            select
                e.value
            from rendszerparameterek_ertekek e
            left join rendszerparameterek r
            on r.id = e.rendszerparameter
            where r.name = ?
        ";

        // dev szovegek

        public static $dev_szovegek_sel = "
            select *
            from texts
        ";

        public static $dev_isset_szoveg = "
            select count(*) as cnt
            from texts
            where lang = ? and label = ?
        ";

        public static $dev_insert_szoveg = "
            insert into texts
            (`lang`, `label`, `text`, `text_html`)
            value(?,?,?,?)
        ";

        // dev ajax tester

        public static $dev_ajax_export = "
            insert into dev_ajax_export
            (`ajax_nev`, `json_ertek`)
            values (?, ?)
        ";

        public static $isset_dev_ajax_export = "
            select
                count(*) as cnt
            from dev_ajax_export
            where ajax_nev = ?
        ";

        public static $get_dev_ajax_export = "
            select
                *
            from dev_ajax_export
            where ajax_nev = ?
        ";

        // elfelejtett jelszo

        public static $set_forgotten_password = "
            update users
            set forgotten = ?
            where email = ?
        ";

        public static $isset_forgotten = "
            select count(*) as cnt
            from users
            where forgotten = ?
        ";

        public static $get_user_by_forgotten_code = "
            select id, nev
            from users
            where forgotten = ?
        ";

        public static $forgotten_used = "
            update users
            set forgotten = null
            where forgotten = ?
        ";

        public static $jelszo_megadasa = "
            update users
            set password = ?
            where id = ?
        ";

        // jelszo megvaltoztatasa

        public static $check_login_adatok_id = "
            select count(*) as cnt
            from users
            where id = ? and password = ?
        ";

        // email megvaltoztatasa

        public static $email_megadasa = "
            update users
            set email = ?
            where id = ?
        ";

        // orszagok

        public static $orszagok_listaja_sel = "
            select
                ctr_id as id,
                ctr_name as nev_magyar,
                ctr_name_en as nev_angol
            from orszagok
        ";

        // generix isset check

        public static $isset_check = "
            select count(*) as cnt
            from [[table]]
            where [[col]] = ?
        ";

        // partnerek

        public static $valaszthato_partnerek_sel = "
            select
                p.id,
                p.nev
            from partnerek p
            left join users_kapcs_partnerek ukp
            on ukp.fk_partnerek = p.id
            where ukp.fk_users = ? and p.aktiv = 1
        ";

        public static $partnerek_sel = "
            select
                p.id,
                p.nev,
                p.adoszam,
                p.email,
                p.aktiv,
                p.telefon,
                p.fk_szekhely_orszag,
                o.ctr_name as szekhely_orszag,
                p.szekhely_iranyitoszam,
                p.szekhely_telepules,
                p.szekhely_address as szekhely_cim,
                p.email_kuldo_neve,
                p.email_kuldo_email_cime,
                p.creation_date as letrehozas_datuma,
                p.fk_users_creator as fk_letrehozo,
                u.nev as letrehozo_neve
            from partnerek p
            left join orszagok o
            on o.ctr_id = p.fk_szekhely_orszag
            left join users u
            on u.id = p.fk_users_creator
            where p.aktiv = 1
            order by p.nev asc
        ";

        public static $partnerek_sel_with_inaktiv = "
            select
                p.id,
                p.nev,
                p.adoszam,
                p.email,
                p.aktiv,
                p.telefon,
                p.fk_szekhely_orszag,
                o.ctr_name as szekhely_orszag,
                p.szekhely_iranyitoszam,
                p.szekhely_telepules,
                p.szekhely_address as szekhely_cim,
                p.email_kuldo_neve,
                p.email_kuldo_email_cime,
                p.creation_date as letrehozas_datuma,
                p.fk_users_creator as fk_letrehozo,
                u.nev as letrehozo_neve
            from partnerek p
            left join orszagok o
            on o.ctr_id = p.fk_szekhely_orszag
            left join users u
            on u.id = p.fk_users_creator
            order by p.nev asc
        ";

        public static $partnerek_new = "
            insert into partnerek
            (`nev`, `email`, `telefon`, `adoszam`, `fk_szekhely_orszag`, `szekhely_iranyitoszam`, `szekhely_telepules`, `szekhely_address`, `email_kuldo_neve`, `email_kuldo_email_cime`, `fk_users_creator`)
            values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
        ";

        public static $partnerek_akt = "
            update partnerek
            set aktiv = ?
            where id = ?
        ";

        public static $partnerek_mod = "
            update partnerek
            set [[col]] = ?
            where id = ?
        ";

        public static $felhasznalo_partner_jogok_del = "
            delete from users_kapcs_partnerek_kapcs_elemi_jogok
            where fk_partnerek = ? and fk_users = ?
        ";

        // jogok

        public static $sel_global_rights_of_user = "
            select
                ej.id as id,
                ej.kod as kod
            from elemi_jogok ej
            left join users_kapcs_elemi_jogok ukej
            on ukej.fk_elemi_jogok = ej.id
            where ukej.fk_users = ?
        ";

        public static $sel_partner_rights_of_user = "
            select
                ej.id as id,
                ej.kod as kod
            from elemi_jogok ej
            left join users_kapcs_partnerek_kapcs_elemi_jogok ukpkej
            on ukpkej.fk_elemi_jogok = ej.id
            where ukpkej.fk_users = ?
        ";

        public static $user_has_global_right = "
            select count(*) as cnt
            from users_kapcs_elemi_jogok ukej
            left join elemi_jogok ej
            on ej.id = ukej.fk_elemi_jogok
            where ukej.fk_users = ? and ej.kod = ?
        ";

        public static $sel_user_jogcsoport_jogok = "
            select
                j.id as jogcsoport_id,
                j.nev as jogcsoport_nev,
                ej.id as elemi_jog_id,
                ej.kod as elemi_jog_kod,
                ej.adhato as elemi_jog_adhato,
                ej.partnerhez_adhato as elemi_jog_partnerhez_adhato,
                ejsz.nev as elemi_jog_nev,
                ejsz.leiras as elemi_jog_leiras
            from jogcsoportok_kapcs_elemi_jogok jkej
            left join jogcsoportok j
            on jkej.fk_jogcsoportok = j.id
            left join elemi_jogok ej
            on ej.id = jkej.fk_elemi_jogok
            left join elemi_jogok_szovegek ejsz
            on ej.id = ejsz.fk_elemi_jogok
            where j.fk_users = ? and ejsz.lang = ?
        ";

        public static $get_partner_of_partner_jog = "
            select
                fk_partnerek
            from users_kapcs_partnerek_kapcs_elemi_jogok
            where fk_elemi_jogok = ? and fk_users = ?
        ";

        public static $jogcsoportok_sel = "
            select
                id,
                nev,
                creation_date as letrehozas_datuma
            from jogcsoportok j
            where fk_users = ?
        ";

        public static $is_sajat_jogcsoport = "
            select count(*) as cnt
            from jogcsoportok
            where id = ? and fk_users = ?
        ";

        public static $jogcsoportok_jogok_sel = "
            select
                ej.id,
                ej.kod,
                ejsz.nev,
                ejsz.leiras
            from elemi_jogok ej
            left join jogcsoportok_kapcs_elemi_jogok jkej
            on jkej.fk_elemi_jogok = ej.id
            left join elemi_jogok_szovegek ejsz
            on ejsz.fk_elemi_jogok = ej.id
            where jkej.fk_jogcsoportok = ? and ej.adhato = 1 and ejsz.lang = ?
        ";

        public static $add_jog_to_jogcsoport = "
            insert ignore into jogcsoportok_kapcs_elemi_jogok
            (`fk_jogcsoportok`, `fk_elemi_jogok`)
            values (?, (select id from elemi_jogok where kod = ?))
        ";

        public static $del_jog_from_jogcsoport = "
            delete from jogcsoportok_kapcs_elemi_jogok
            where fk_jogcsoportok = ? and fk_elemi_jogok = (select id from elemi_jogok where kod = ?)
        ";

        public static $get_partners_with_rights_of_user = "
            select distinct
                p.id,
                p.nev,
                p.adoszam,
                p.email,
                p.aktiv,
                p.telefon,
                p.fk_szekhely_orszag,
                o.ctr_name as szekhely_orszag,
                p.szekhely_iranyitoszam,
                p.szekhely_telepules,
                p.szekhely_address as szekhely_cim,
                p.email_kuldo_neve,
                p.email_kuldo_email_cime,
                p.creation_date as letrehozas_datuma,
                p.fk_users_creator as fk_letrehozo,
                u.nev as letrehozo_neve
            from users_kapcs_partnerek_kapcs_elemi_jogok uk
            left join partnerek p
            on p.id = uk.fk_partnerek
            left join orszagok o
            on o.ctr_id = p.fk_szekhely_orszag
            left join users u
            on u.id = p.fk_users_creator
            left join users_kapcs_partnerek ukp
            on ukp.fk_partnerek = p.id
            where (uk.fk_users = ? and uk.fk_elemi_jogok = (select id from elemi_jogok where kod = ?)) and p.aktiv = 1
            order by p.nev asc
        ";

        public static $user_has_partner_right = "
            select
                count(*) as cnt
            from users_kapcs_partnerek_kapcs_elemi_jogok uk
            where uk.fk_users = ? and uk.fk_elemi_jogok = (select id from elemi_jogok where kod = ?)
        ";

        public static $user_has_right_at_partner = "
            select
                count(*) as cnt
            from users_kapcs_partnerek_kapcs_elemi_jogok uk
            where uk.fk_users = ? and uk.fk_elemi_jogok = (select id from elemi_jogok where kod = ?) and fk_partnerek = ?
        ";

        public static $jogcsoportok_new = "
            insert into jogcsoportok
            (`nev`, `fk_users`)
            values (?, ?)
        ";

        public static $jogcsoportok_mod = "
            update jogcsoportok
            set nev = ?
            where id = ?
        ";

        public static $jogcsoportok_del = "
            delete from jogcsoportok
            where id = ?
        ";

        public static $jogcsoportok_jogok_del = "
            delete from jogcsoportok_kapcs_elemi_jogok
            where fk_jogcsoportok = ?
        ";

        public static $get_adhato_global_jogok = "
            select
                *
            from elemi_jogok
            where adhato = 1
        ";

        public static $get_adhato_partner_jogok = "
            select
                *
            from elemi_jogok
            where partnerhez_adhato = 1
        ";

        public static $get_felhasznalo_jogcsoportok = "
            select
                *
            from jogcsoportok
            where fk_users = ?
        ";

        public static $get_jogok_of_jogcsoport = "
            select
                ej.*
            from elemi_jogok ej
            left join jogcsoportok_kapcs_elemi_jogok jkej
            on jkej.fk_elemi_jogok = ej.id
            where jkej.fk_jogcsoportok = ?
        ";

        public static $get_jogcsoportba_rendezett_joglista_of_user = "
            select distinct
                ej.*
            from elemi_jogok ej
            left join jogcsoportok_kapcs_elemi_jogok jkej
            on jkej.fk_elemi_jogok = ej.id
            left join jogcsoportok j
            on j.id = jkej.fk_jogcsoportok
            where j.fk_users = ?
        ";

        public static $get_jogok_of_user = "
            select
                *
            from elemi_jogok
            where id in (
                select
                    ej.id
                from elemi_jogok ej
                left join users_kapcs_elemi_jogok jkej
                on jkej.fk_elemi_jogok = ej.id
                where jkej.fk_users = ?

                union distinct

                select
                    ej.id
                from elemi_jogok ej
                left join users_kapcs_partnerek_kapcs_elemi_jogok ukpkej
                on ukpkej.fk_elemi_jogok = ej.id
                where ukpkej.fk_users = ?

                group by id
            )
        ";

        public static $get_be_nem_sorolt_jogok = "
            select
                ej.id as elemi_jog_id,
                ej.kod as elemi_jog_kod,
                ej.adhato as elemi_jog_adhato,
                ej.partnerhez_adhato as elemi_jog_partnerhez_adhato,
                ejsz.nev as elemi_jog_nev,
                ejsz.leiras as elemi_jog_leiras
            from elemi_jogok ej
            left join elemi_jogok_szovegek ejsz
            on ej.id = ejsz.fk_elemi_jogok
            where ej.id in (
                select
                    ej.id
                from elemi_jogok ej
                left join users_kapcs_elemi_jogok jkej
                on jkej.fk_elemi_jogok = ej.id
                where jkej.fk_users = ?

                union distinct

                select
                    ej.id
                from elemi_jogok ej
                left join users_kapcs_partnerek_kapcs_elemi_jogok ukpkej
                on ukpkej.fk_elemi_jogok = ej.id
                where ukpkej.fk_users = ?

                group by id
            ) and ejsz.lang = ? and (? = 1 or ej.id not in [[jogok]])
        ";

        public static $del_jog_from_felhasznalo_jogcsoportjai = "
            delete from jogcsoportok_kapcs_elemi_jogok
            where fk_jogcsoportok in (select id from jogcsoportok where fk_users = ?) and fk_elemi_jogok = ?
        ";

        // felhasznalok

        public static $admin_felhasznalok_sel = "
            select
                u.id,
                u.nev,
                u.email,
                u.telefon,
                u.megjegyzes,
                u.kitiltva,
                u.probalkozasok_szama,
                u.forgotten as elfelejtett_jelszo_token,
                u.creation_date as letrehozas_datuma,
                u2.id as letrehozo_sn,
                u2.nev as letrehozo,
                GROUP_CONCAT(p.nev SEPARATOR ', ') as partnerek
            from users u
            left join users u2
            on u2.id = u.fk_users_creator
            left join users_kapcs_partnerek up
            on up.fk_users = u.id
            left join partnerek p
            on p.id = up.fk_partnerek
            where p.aktiv = 1 or (select count(*) from users_kapcs_partnerek where fk_users = u.id) = 0
            group by u.id
            order by u.nev asc
        ";

        public static $same_partner_felhasznalok_sel = "
            select distinct
                u.id,
                u.nev,
                u.email,
                u.telefon,
                u.kitiltva,
                u.probalkozasok_szama,
                u.forgotten as elfelejtett_jelszo_token,
                u.creation_date as letrehozas_datuma,
                u2.id as letrehozo_sn,
                u2.nev as letrehozo
            from users u
            left join users u2
            on u2.id = u.fk_users_creator
            left join users_kapcs_partnerek uk
            on uk.fk_users = u.id
            where uk.fk_partnerek in (
                select fk_partnerek
                from users_kapcs_partnerek
                where fk_users = ?
            )
        ";

        public static $felhasznalok_sel_of_partnerek = "
            select distinct
                u.id,
                u.nev,
                u.email,
                u.telefon,
                u.megjegyzes,
                u.kitiltva,
                u.probalkozasok_szama,
                u.forgotten as elfelejtett_jelszo_token,
                u.creation_date as letrehozas_datuma,
                u2.id as letrehozo_sn,
                u2.nev as letrehozo,
                GROUP_CONCAT(p.nev SEPARATOR ', ') as partnerek
            from users u
            inner join users u2
            on u2.id = u.fk_users_creator
            left join users_kapcs_partnerek uk
            on uk.fk_users = u.id
            left join partnerek p
            on p.id = uk.fk_partnerek
            where uk.fk_partnerek in [[partnerek]]
            group by u.id
            order by u.nev asc
        ";

        public static $partnerek_of_user_sel = "
            select distinct
                p.id,
                p.nev,
                p.adoszam,
                p.email,
                p.aktiv,
                p.telefon,
                p.fk_szekhely_orszag,
                o.ctr_name as szekhely_orszag,
                p.szekhely_iranyitoszam,
                p.szekhely_telepules,
                p.szekhely_address as szekhely_cim,
                p.email_kuldo_neve,
                p.email_kuldo_email_cime,
                p.creation_date as letrehozas_datuma,
                p.fk_users_creator as fk_letrehozo,
                u.nev as letrehozo_neve
            from partnerek p
            left join orszagok o
            on o.ctr_id = p.fk_szekhely_orszag
            left join users u
            on u.id = p.fk_users_creator
            left join users_kapcs_partnerek ukp
            on ukp.fk_partnerek = p.id
            where ukp.fk_users = ?
            and p.aktiv = 1
            order by p.nev asc
        ";

        public static $jogok_of_user_sel = "
            select
                ej.id,
                ej.kod,
                ejsz.nev,
                ejsz.leiras
            from elemi_jogok ej
            left join elemi_jogok_szovegek ejsz
            on ejsz.fk_elemi_jogok = ej.id
            left join users_kapcs_elemi_jogok ukej
            on ukej.fk_elemi_jogok = ej.id
            where ukej.fk_users = ? and ejsz.lang = ?
        ";

        public static $partner_jogok_of_user_sel = "
            select
                ej.id,
                ej.kod,
                ejsz.nev,
                ejsz.leiras
            from elemi_jogok ej
            left join elemi_jogok_szovegek ejsz
            on ejsz.fk_elemi_jogok = ej.id
            left join users_kapcs_partnerek_kapcs_elemi_jogok up
            on up.fk_elemi_jogok = ej.id
            where up.fk_partnerek = ? and up.fk_users = ? and ejsz.lang = ?
        ";

        public static $get_partnerek_of_user = "
            select
                p.id
            from partnerek p
            left join users_kapcs_partnerek ukp
            on ukp.fk_partnerek = p.id
            where ukp.fk_users = ? and p.aktiv = 1
        ";

        public static $felhasznalok_new = "
            insert into users
            (`nev`, `email`, `telefon`, `megjegyzes`, `password`, `fk_users_creator`)
            values (?, ?, ?, ?, ?, ?)
        ";

        public static $felhasznalok_mod = "
            update users
            set [[col]] = ?
            where id = ?
        ";

        public static $felhasznalo_add_partner = "
            insert ignore into users_kapcs_partnerek
            (`fk_partnerek`, `fk_users`, `fk_users_creator`)
            values (?, ?, ?)
        ";

        public static $felhasznalo_del_partner = "
            delete from users_kapcs_partnerek
            where fk_partnerek = ? and fk_users = ?
        ";

        public static $felhasznalo_add_telephely = "
            insert ignore into users_kapcs_telephelyek
            (`fk_telephelyek`, `fk_users`, `fk_users_creator`)
            values (?, ?, ?)
        ";

        public static $felhasznalo_del_telephely = "
            delete from users_kapcs_telephelyek
            where fk_telephelyek = ? and fk_users = ?
        ";

        public static $get_telephelyek_of_felhasznalo = "
            select
                t.id,
                t.nev,
                t.email,
                t.telefon,
                t.fk_partnerek as fk_partner,
                p.nev as partner_nev,
                t.fk_orszag,
                o.ctr_name as orszag,
                t.iranyitoszam,
                t.telepules,
                t.cim,
                t.creation_date as letrehozas_datuma,
                u.id as letrehozo_sn,
                u.nev as letrehozo,
                t.aktiv
            from telephelyek t
            left join users u
            on u.id = t.fk_users_creator
            left join orszagok o
            on o.ctr_id = t.fk_orszag
            left join partnerek p
            on p.id = t.fk_partnerek
            left join users_kapcs_telephelyek ukt
            on ukt.fk_telephelyek = t.id
            where ukt.fk_users = ?
        ";

        public static $add_jog_to_felhasznalo = "
            insert ignore into users_kapcs_elemi_jogok
            (`fk_users`, `fk_elemi_jogok`, `fk_users_creator`)
            values (?, (select id from elemi_jogok where kod = ?), ?)
        ";

        public static $del_jog_from_felhasznalo = "
            delete from users_kapcs_elemi_jogok
            where fk_users = ? and fk_elemi_jogok = (select id from elemi_jogok where kod = ?)
        ";

        public static $add_jog_to_felhasznalo_partner = "
            insert ignore into users_kapcs_partnerek_kapcs_elemi_jogok
            (`fk_users`, `fk_partnerek`, `fk_elemi_jogok`, `fk_users_creator`)
            values (?, ?, (select id from elemi_jogok where kod = ?), ?)
        ";

        public static $del_jog_from_felhasznalo_partner = "
            delete from users_kapcs_partnerek_kapcs_elemi_jogok
            where fk_users = ? and fk_partnerek = ? and fk_elemi_jogok = (select id from elemi_jogok where kod = ?)
        ";

        // telephelyek

        public static $admin_telephelyek_sel = "
            select
                t.id,
                t.nev,
                t.email,
                t.telefon,
                t.kapcs_neve,
                t.fk_partnerek as fk_partner,
                p.nev as partner_nev,
                t.fk_orszag,
                o.ctr_name as orszag,
                t.iranyitoszam,
                t.telepules,
                t.cim,
                t.megjegyzes,
                t.creation_date as letrehozas_datuma,
                u.id as letrehozo_sn,
                u.nev as letrehozo,
                t.aktiv
            from telephelyek t
            left join users u
            on u.id = t.fk_users_creator
            left join orszagok o
            on o.ctr_id = t.fk_orszag
            left join partnerek p
            on p.id = t.fk_partnerek
            where p.aktiv = 1
            order by t.nev asc
        ";

        public static $get_telephelyek_of_partner = "
            select
                t.id,
                t.nev,
                t.email,
                t.telefon,
                t.kapcs_neve,
                t.fk_partnerek as fk_partner,
                p.nev as partner_nev,
                t.fk_orszag,
                o.ctr_name as orszag,
                t.iranyitoszam,
                t.telepules,
                t.cim,
                t.megjegyzes,
                t.creation_date as letrehozas_datuma,
                u.id as letrehozo_sn,
                u.nev as letrehozo,
                t.aktiv
            from telephelyek t
            left join users u
            on u.id = t.fk_users_creator
            left join orszagok o
            on o.ctr_id = t.fk_orszag
            left join partnerek p
            on p.id = t.fk_partnerek
            where t.fk_partnerek in [[partnerek]]
            order by t.nev asc
        ";

        public static $get_partner_of_telephely = "
            select
                fk_partnerek
            from telephelyek
            where id = ?
        ";

        public static $get_telephelyek_id_of_partner = "
            select
                id
            from telephelyek
            where fk_partnerek = ?
        ";

        public static $telephelyek_new = "
            insert into telephelyek
            (`nev`, `email`, `telefon`, `kapcs_neve`, `fk_orszag`, `iranyitoszam`, `telepules`, `cim`, `megjegyzes`, `fk_partnerek`, `fk_users_creator`)
            values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
        ";

        public static $telephelyek_akt = "
            update telephelyek
            set aktiv = ?
            where id = ?
        ";

        public static $telephelyek_mod = "
            update telephelyek
            set [[col]] = ?
            where id = ?
        ";

        // regiok

        public static $admin_regiok_sel = "
            select
                r.id,
                r.nev,
                r.fk_partnerek as fk_partner,
                p.nev as partner_nev,
                r.creation_date as letrehozas_datuma,
                u.id as letrehozo_sn,
                u.nev as letrehozo
            from regiok r
            left join users u
            on u.id = r.fk_users_creator
            left join partnerek p
            on p.id = r.fk_partnerek
            where p.aktiv = 1
            order by r.nev asc
        ";

        public static $get_regiok_of_partner = "
            select
                r.id,
                r.nev,
                r.fk_partnerek as fk_partner,
                p.nev as partner_nev,
                r.creation_date as letrehozas_datuma,
                u.id as letrehozo_sn,
                u.nev as letrehozo
            from regiok r
            left join users u
            on u.id = r.fk_users_creator
            left join partnerek p
            on p.id = r.fk_partnerek
            where r.fk_partnerek in [[partnerek]]
            order by r.nev asc
        ";

        public static $get_telephelyek_of_regio = "
            select
                t.id,
                t.nev,
                t.email,
                t.telefon,
                t.fk_partnerek as fk_partner,
                p.nev as partner_nev,
                t.fk_orszag,
                o.ctr_name as orszag,
                t.iranyitoszam,
                t.telepules,
                t.cim,
                t.creation_date as letrehozas_datuma,
                u.id as letrehozo_sn,
                u.nev as letrehozo,
                t.aktiv
            from telephelyek t
            left join users u
            on u.id = t.fk_users_creator
            left join orszagok o
            on o.ctr_id = t.fk_orszag
            left join partnerek p
            on p.id = t.fk_partnerek
            left join regiok_kapcs_telephelyek rkt
            on rkt.fk_telephelyek = t.id
            where rkt.fk_regiok = ?
        ";

        public static $regiok_new = "
            insert into regiok
            (`nev`, `fk_partnerek`, `fk_users_creator`)
            values (?, ?, ?)
        ";

        public static $regiok_mod = "
            update regiok
            set nev = ?
            where id = ?
        ";

        public static $regiok_del = "
            delete from regiok
            where id = ?
        ";

        public static $regiok_telephelyei_del = "
            delete from regiok_kapcs_telephelyek
            where fk_regiok = ?
        ";

        public static $regiok_sel_of_partnerek = "
            select id
            from regiok
            where fk_partnerek in [[partnerek]]
        ";

        public static $get_partner_sn_of_regio = "
            select fk_partnerek as id
            from regiok
            where id = ?
        ";

        public static $add_telephely_to_regio = "
            insert ignore into regiok_kapcs_telephelyek
            (`fk_regiok`, `fk_telephelyek`, `fk_users_creator`)
            values (?, ?, ?)
        ";

        public static $del_telephely_from_regio = "
            delete from regiok_kapcs_telephelyek
            where fk_regiok = ? and fk_telephelyek = ?
        ";

        public static $get_partner_of_telephely_2 = "
            select
                p.*
            from partnerek p
            left join telephelyek t
            on t.fk_partnerek = p.id
            where t.id = ?
        ";

        // eszkozok

        public static $admin_eszkozok_sel = "
            select
                e.*,
                t.nev as telephely_nev,
                p.nev as partner_nev,
                p.id as partner_id,
                u.nev as creator_nev,
                k.nev as kerdoiv_nev,
                e2.id as hozzakapcsolt_online_eszkoz_id,
                e2.nev as hozzakapcsolt_online_eszkoz_nev,
                e2.eszkoz_azonosito as hozzakapcsolt_online_eszkoz_eszkoz_azonosito
            from eszkozok e
            left join telephelyek t
            on t.id = e.fk_telephelyek
            left join partnerek p
            on p.id = t.fk_partnerek
            left join users u
            on u.id = e.fk_users_creator
            left join kerdoivek k
            on k.id = e.fk_kerdoivek
            left join eszkozok e2
            on e2.id = e.hozzakapcsolt_online_eszkoz
            where p.aktiv = 1
            order by e.nev asc
        ";

        public static $get_eszkozok_of_telephelyek = "
            select
                e.*,
                p.nev as partner_nev,
                p.id as partner_id,
                t.nev as telephely_nev,
                u.nev as creator_nev,
                k.nev as kerdoiv_nev,
                e2.id as hozzakapcsolt_online_eszkoz_id,
                e2.nev as hozzakapcsolt_online_eszkoz_nev,
                e2.eszkoz_azonosito as hozzakapcsolt_online_eszkoz_eszkoz_azonosito
            from eszkozok e
            left join telephelyek t
            on t.id = e.fk_telephelyek
            left join users u
            on u.id = e.fk_users_creator
            left join kerdoivek k
            on k.id = e.fk_kerdoivek
            left join partnerek p
            on p.id = t.fk_partnerek
            left join eszkozok e2
            on e2.id = e.hozzakapcsolt_online_eszkoz
            where e.fk_telephelyek in [[telephelyek]]
            order by e.nev asc
        ";

        public static $get_hozzakapcsolt_online_eszkoz = "
            select
                e2.id as id,
                e2.nev as nev,
                e2.eszkoz_azonosito as azonosito
            from eszkozok e
            left join eszkozok e2
            on e2.id = e.hozzakapcsolt_online_eszkoz
            where e.id = ?
        ";

        public static $eszkozok_new = "
            insert into eszkozok
            (
                `nev`,
                `eszkoz_azonosito`,
                `fk_telephelyek`,
                `online`,
                `fk_users_creator`
            )
            values (?, ?, ?, ?, ?)
        ";

        public static $eszkozok_akt = "
            update eszkozok
            set aktiv = ?
            where id = ?
        ";

        public static $eszkozok_mod = "
            update eszkozok
            set [[col]] = ?
            where id = ?
        ";

        // nev megvaltoztatasa

        public static $nev_megadasa = "
            update users
            set nev = ?
            where id = ?
        ";

        public static $add_globalis_jog_to_user_temp = "
            insert ignore into users_kapcs_elemi_jogok
            (`fk_users`, `fk_elemi_jogok`, `fk_users_creator`)
            values (?, ?, ?)
        ";

        // webservices

        public static $isset_empty_eszkoz_azonosito = "
            select count(*) as cnt
            from eszkozok
            where eszkoz_azonosito = ? and sorozatszam is null
        ";

        public static $isset_not_empty_eszkoz_azonosito = "
            select count(*) as cnt
            from eszkozok
            where eszkoz_azonosito = ? and sorozatszam is not null
        ";

        public static $register_eszkoz = "
            update eszkozok
            set sorozatszam = ?, mac_cim = ?, felbontas = ?, dpi = ?, api_verzio = ?, telepites_azonosito = ?, modell = ?, regisztracio_idopontja = now()
            where eszkoz_azonosito = ?
        ";

        public static $get_telephely_sn_from_eszkoz_azonosito = "
            select fk_telephelyek as id
            from eszkozok
            where eszkoz_azonosito = ?
        ";

        public static $get_eszkoz_sn_from_eszkoz_azonosito = "
            select id
            from eszkozok
            where eszkoz_azonosito = ?
        ";

        // kerdoivek

        public static $kerdoivek_json_kerdoiv_sel = "
            select
                id,
                nev,
                szines_nps,
                mp_felugro_elott,
                mp_felugro_kozben,
                mp_utolso_oldalon,
                creation_date,
                kell_kezdooldal,
                kell_oldalszam,
                progress_bar,
                eszkoz_nev_megjelenitese,
                felkover,
                allo_nezet,
                1_oldalas
            from kerdoivek
            where id = ?
        ";

        public static $kerdoivek_json_hatterkep_sel = "
            select
                kep_kezdo_oldal_tablet,
                kep_kezdo_oldal_tablet_qr,
                kep_kezdo_oldal_online,
                kep_kerdes_oldal,
                kep_utolso_oldal,
                kep_logo_bal,
                kep_logo_jobb,
                fejlec_logo_jobb,
                fejlec_logo_bal
            from kerdoivek_hatterkepek
            where fk_kerdoivek = ?
        ";

        public static $kerdoivek_json_szinek_sel = "
            select
                objektum_nev,
                szinkod
            from kerdoivek_szinek
            where fk_kerdoivek = ?
        ";

        public static $kerdoivek_json_nyelvek_sel = "
            select
                lang,
                sorrend
            from kerdoivek_nyelvek
            where fk_kerdoivek = ?
        ";

        public static $kerdoivek_json_szovegek_sel = "
            select
                szoveg_nev,
                szoveg_ertek
            from kerdoivek_szovegek
            where fk_kerdoivek = ? and lang = ?
        ";

        public static $kerdoivek_json_kell_rendszerszintu_kerdesek_sel = "
            select
                kk.id,
                kk.azonosito,
                kk.sorrend,
                kk.fk_kerdoivek_valasz_tipusok as valasz_tipus_id,
                kvt.kod as valasz_tipus_kod
            from kerdoivek_kerdesek kk
            inner join kerdoivek_kerdesek_kell_rendszerszintu kkkr
            on kkkr.fk_kerdoivek_rendszerszintu = kk.id
            inner join kerdoivek_valasz_tipusok kvt
            on kvt.id = kk.fk_kerdoivek_valasz_tipusok
            where kkkr.fk_kerdoivek = ?
            order by kk.sorrend asc
        ";

        public static $kerdoivek_json_kell_rendszerszintu_kerdesek_sel_jelentesek = "
            select distinct
                kk.id,
                kk.azonosito,
                kk.sorrend,
                kk.fk_kerdoivek_valasz_tipusok as valasz_tipus_id,
                kvt.kod as valasz_tipus_kod
            from kerdoivek_kerdesek kk
            inner join kerdoivek_kerdesek_kell_rendszerszintu kkkr
            on kkkr.fk_kerdoivek_rendszerszintu = kk.id
            inner join kerdoivek_valasz_tipusok kvt
            on kvt.id = kk.fk_kerdoivek_valasz_tipusok
            where kkkr.fk_kerdoivek in [[kerdoiv_idk]]
            order by kk.sorrend asc
        ";

        public static $kerdoivek_json_rsz_eredeti_kerdesek_szovegek = "
            select
                kerdes_szovege
            from kerdoivek_kerdesek_szovegek
            where fk_kerdoivek_kerdesek = ? and fk_kerdoivek is null and lang = ?
        ";

        public static $kerdoivek_json_rsz_felulirt_kerdesek_szovegek = "
            select
                kerdes_szovege
            from kerdoivek_kerdesek_szovegek
            where fk_kerdoivek_kerdesek = ? and fk_kerdoivek = ? and lang = ?
        ";

        public static $kerdoivek_json_valasz_tipus_kieg_sel = "
            select
                adat_kod,
                adat_content
            from kerdoivek_valasz_tipusok_kieg
            where fk_kerdoivek_valasz_tipusok = ?
        ";

        public static $kerdoivek_json_kerdes_valasz_tiltasok_sel = "
            select
                vt.valasz_sorszama
            from kerdoivek_kerdesek_valasz_tiltasok vt
            where vt.fk_kerdoivek_kerdesek = ? and vt.fk_eszkozok = ?
        ";

        public static $kerdoivek_json_kerdesek_sel = "
            select
                kk.id,
                kk.azonosito,
                kk.sorrend,
                kk.fk_kerdoivek_kerdesek_csoport as kerdes_csoport_id,
                kk.fk_kerdoivek_valasz_tipusok as valasz_tipus_id,
                kvt.kod as valasz_tipus_kod
            from kerdoivek_kerdesek kk
            inner join kerdoivek_valasz_tipusok kvt
            on kvt.id = kk.fk_kerdoivek_valasz_tipusok
            where fk_kerdoivek = ?
                and fk_kerdoivek_kerdesek_csoport is null
            order by kk.sorrend asc
        ";

        public static $get_alkerdesek = "
            select
                kk.id,
                kk.azonosito,
                kk.sorrend,
                kk.fk_kerdoivek_kerdesek_csoport as kerdes_csoport_id,
                kk.fk_kerdoivek_valasz_tipusok as valasz_tipus_id,
                kvt.kod as valasz_tipus_kod
            from kerdoivek_kerdesek kk
            inner join kerdoivek_valasz_tipusok kvt
            on kvt.id = kk.fk_kerdoivek_valasz_tipusok
            where fk_kerdoivek_kerdesek_csoport = ?
            order by kk.sorrend asc
        ";

        public static $kerdoivek_json_kerdesek_sel_jelentesek = "
            select distinct
                kk.id,
                kk.azonosito,
                kk.sorrend,
                kk.fk_kerdoivek_valasz_tipusok as valasz_tipus_id,
                kvt.kod as valasz_tipus_kod
            from kerdoivek_kerdesek kk
            inner join kerdoivek_valasz_tipusok kvt
            on kvt.id = kk.fk_kerdoivek_valasz_tipusok
            where fk_kerdoivek in [[kerdoiv_idk]]
            order by kk.sorrend asc
        ";

        public static $kerdoivek_json_kerdes_kieg_sel = "
            select
                adat_kod,
                adat_content
            from kerdoivek_kerdesek_kieg
            where fk_kerdoivek_kerdesek = ?
        ";

        public static $admin_kerdoivek_sel = "
            select
                k.id,
                k.nev,
                k.fk_partnerek as fk_partner,
                k.szines_nps,
                k.mp_felugro_elott,
                k.mp_felugro_kozben,
                k.mp_utolso_oldalon,
                p.nev as partner_nev,
                k.creation_date as letrehozas_datuma,
                u.id as letrehozo_sn,
                u.nev as letrehozo,
                k.aktiv
            from kerdoivek k
            left join users u
            on u.id = k.fk_users_creator
            left join partnerek p
            on p.id = k.fk_partnerek
            where p.aktiv = 1
            order by k.nev asc
        ";

        public static $get_kerdoivek_of_partner = "
            select
                k.id,
                k.nev,
                k.fk_partnerek as fk_partner,
                k.szines_nps,
                k.mp_felugro_elott,
                k.mp_felugro_kozben,
                k.mp_utolso_oldalon,
                p.nev as partner_nev,
                k.creation_date as letrehozas_datuma,
                u.id as letrehozo_sn,
                u.nev as letrehozo,
                k.aktiv
            from kerdoivek k
            left join users u
            on u.id = k.fk_users_creator
            left join partnerek p
            on p.id = k.fk_partnerek
            where k.fk_partnerek in [[partnerek]]
            order by k.nev asc
        ";

        public static $jelentes_fej_new = "
            insert into jelentesek_fej
            (`fk_eszkozok`, `fk_kerdoivek`, `fk_telephelyek`, `fk_partnerek`, `mac`, `telepitesi_azon`, `ip`, `fk_beolvasas_sorok`, `created_at`, `kezdes_idopont`, `egyedi_user_id`, `uuid`)
            values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
        ";

        public static $get_max_jelentes_fej_id = "
            select max(id) as id
            from jelentesek_fej
            where fk_eszkozok = ? and fk_kerdoivek = ?
        ";

        public static $get_jelentes_fej_by_kezdes = "
            select id
            from jelentesek_fej
            where fk_eszkozok = ? and fk_kerdoivek = ? and kezdes_idopont = ?
        ";

        public static $get_jelentes_fej_idk = "
            select id
            from jelentesek_fej
            where fk_eszkozok = ? and fk_kerdoivek = ?
        ";

        public static $get_jelentes_fej_by = "
            select id
            from jelentesek_fej
            where fk_eszkozok = ? and created_at = ?
        ";

        public static $get_jelentes_tetel_by = "
            select id
            from jelentesek_tetel
            where fk_eszkozok = ? and created_at = ? and fk_kerdoivek_kerdesek = ?
        ";

        public static $jelentes_tetel_new = "
            insert into jelentesek_tetel
            (`fk_jelentesek_fej`, `fk_kerdoivek_kerdesek`, `kerdes_azonosito`, `valasz_sorszam`, `valasz_ertek`, `created_at`, `fk_eszkozok`, `uuid`)
            values (?, ?, ?, ?, ?, ?, ?, ?)
        ";

        public static $get_kerdes_azonosito_by_id = "
            select azonosito
            from kerdoivek_kerdesek
            where id = ?
        ";

        public static $get_kerdes_by_azonosito = "
            select *
            from kerdoivek_kerdesek kk


            left join kerdoivek_kerdesek_szovegek kkk
            on kkk.fk_kerdoivek_kerdesek = kk.azonosito

            left join kerdoivek_valasz_tipusok kvt
            on kvt.id = kk.fk_kerdoivek_valasz_tipusok

            where kk.azonosito = ?

        ";

        public static $get_kerdoiv_id = "
            select fk_kerdoivek
            from eszkozok
            where id = ?
        ";

        public static $get_kerdoiv_id_from_azonosito = "
            select fk_kerdoivek
            from eszkozok
            where eszkoz_azonosito = ?
        ";

        public static $is_kerdes_of_kerdoiv = "
            select count(*) as cnt
            from kerdoivek_kerdesek
            where id = ? and fk_kerdoivek = ?
        ";

        public static $is_rsz_kerdes_of_kerdoiv = "
            select count(*) as cnt
            from kerdoivek_kerdesek_kell_rendszerszintu
            where fk_kerdoivek_rendszerszintu = ? and fk_kerdoivek = ?
        ";

        public static $isset_jelentes_fej = "
            select count(*) as cnt
            from jelentesek_fej
            where fk_eszkozok = ? and fk_kerdoivek = ?
        ";

        public static $get_partner_of_kerdoiv = "
            select fk_partnerek as partner_sn
            from kerdoivek
            where id = ?
        ";

        public static $get_partner_of_eszkoz = "
            select t.fk_partnerek as partner_sn
            from eszkozok e
            left join telephelyek t
            on t.id = e.fk_telephelyek
            where e.id = ?
        ";

        public static $eszkozok_kerdoiv_hozzarendeles = "
            update eszkozok
            set fk_kerdoivek = ?
            where id = ?
        ";

        public static $jelentesek_sel = "
            select
                *
            from jelentesek
            where valasz_ideje <= ?
                and (? is null or valasz_ideje >= ?)
                and (? is null or valasz_ideje <= ?)
                and (? is null or kerdoiv_id in [[kerdoiv_idk]])
                and (? is null or partner_id in [[partner_idk]])
                and (? is null or telephely_id in [[telephely_idk]])
                and (? is null or eszkoz_id in [[eszkoz_idk]])
                and (? is null or kerdes_id = ?)
            limit ?, ?
        ";

        public static $get_kerdesek_of_kerdoivek = "
            select
                kk.*,
                kksz.kerdes_szovege,
                kvt.id valasz_tipus_id,
                kvt.kod valasz_tipus_kod
            from kerdoivek_kerdesek kk
            left join kerdoivek_valasz_tipusok kvt
            on kvt.id = kk.fk_kerdoivek_valasz_tipusok
            left join kerdoivek_kerdesek_szovegek kksz
            on kk.id = kksz.fk_kerdoivek_kerdesek
            where kksz.lang = ?
                and kksz.fk_kerdoivek is null
                and (
                    kk.fk_kerdoivek in [[kerdoivek]]
                    or kk.fk_kerdoivek is null
                )
        ";

        public static $jelentes_fej_ervenytelenites = "
            update jelentesek_fej
            set ervenytelen = ?
            where id = ?
        ";

        public static $jelentes_fej_ervenytelenites_in = "
            update jelentesek_fej
            set ervenytelen = ?
            where id IN [[sorok]]
        ";

        public static $get_id_of_created_partner = "
            select max(id) as id
            from partnerek
            where fk_users_creator = ?
        ";

        public static $get_id_of_created_felh = "
            select max(id) as id
            from users
            where fk_users_creator = ?
        ";

        public static $get_eszkoz_id_from_azonosito = "
            select id
            from eszkozok
            where eszkoz_azonosito = ?
        ";

        public static $get_eszkoz = "
            select *
            from eszkozok
            where id = ?
        ";

        public static $get_eszkozok = "
            select *
            from eszkozok
            where id IN [[eszkoz_idk]]
        ";

        public static $get_eszkoz_azonosito_from_from_id = "
            select eszkoz_azonosito
            from eszkozok
            where id = ?
        ";

        public static $get_telephely_id_of_eszkoz = "
            select
                fk_telephelyek
            from eszkozok
            where id = ?
        ";

        public static $get_partner_id_of_telephely = "
            select
                fk_partnerek
            from telephelyek
            where id = ?
        ";

        public static $get_partner_by_email = "
            select * from partnerek
            where email_kuldo_email_cime LIKE ?
        ";

        public static $get_sablon_by_partner = "
            select * from email_sablonok
            where automatikus_valasz = 1 AND fk_partnerek = ?
        ";

        // jelentesek nyers adatok
        public static $jelentesek_sel_nyers_adatok = "
            select
                [[select]]
            from jelentesek_fej jf
            left join beolvasas_sorok bs
            on bs.id = jf.fk_beolvasas_sorok
            where jf.created_at <= ?
                and jf.created_at >= ?
                and (? is null or jf.fk_kerdoivek in [[kerdoiv_idk]])
                and (? is null or jf.fk_partnerek in [[partner_idk]])
                and (? is null or jf.fk_telephelyek in [[telephely_idk]])
                and (? is null or jf.fk_eszkozok in [[eszkoz_idk]])
            order by jf.created_at desc, jf.id desc
            [[limit]]
        ";

        public static $jelentesek_sel_nyers_adatok_2 = "
            select
                *
            from jelentesek_egybe je
            where je.created_at <= ?
                and je.created_at >= ?
                and (? is null or je.fk_kerdoivek in [[kerdoiv_idk]])
                and (? is null or je.fk_partnerek in [[partner_idk]])
                and (? is null or je.fk_telephelyek in [[telephely_idk]])
                and (? is null or je.fk_eszkozok in [[eszkoz_idk]])
        ";

        public static $jelentesek_sel_helyszin_szerint_eszkoz = "
            select
                jf.fk_eszkozok,
                jt.kerdes_azonosito,
                jt.valasz_sorszam,
                count(*) as elofordulas
            from jelentesek_tetel jt
            left join jelentesek_fej jf
            on jf.id = jt.fk_jelentesek_fej
            where jf.ervenytelen = 0
                and jf.created_at <= ?
                and jf.created_at >= ?
                and (? is null or jf.fk_kerdoivek in [[kerdoiv_idk]])
                and (? is null or jf.fk_partnerek in [[partner_idk]])
                and (? is null or jf.fk_telephelyek in [[telephely_idk]])
                and (? is null or jf.fk_eszkozok in [[eszkoz_idk]])
                and jt.kerdes_azonosito in [[kerdes_idk]]
            group by jf.fk_eszkozok, jt.kerdes_azonosito, jt.valasz_sorszam
        ";

        public static $jelentesek_sel_helyszin_szerint_telephely = "
            select
                jf.fk_telephelyek,
                jt.kerdes_azonosito,
                jt.valasz_sorszam,
                count(*) as elofordulas
            from jelentesek_tetel jt
            left join jelentesek_fej jf
            on jf.id = jt.fk_jelentesek_fej
            where jf.ervenytelen = 0
                and jf.created_at <= ?
                and jf.created_at >= ?
                and (? is null or jf.fk_kerdoivek in [[kerdoiv_idk]])
                and (? is null or jf.fk_partnerek in [[partner_idk]])
                and (? is null or jf.fk_telephelyek in [[telephely_idk]])
                and (? is null or jf.fk_eszkozok in [[eszkoz_idk]])
                and jt.kerdes_azonosito in [[kerdes_idk]]
            group by jf.fk_telephelyek, jt.kerdes_azonosito, jt.valasz_sorszam
        ";

        public static $jelentesek_sel_helyszin_szerint_regio = "
            select
                rkt.fk_regiok as regio_id,
                jt.kerdes_azonosito,
                jt.valasz_sorszam,
                count(*) as elofordulas
            from jelentesek_tetel jt
            left join jelentesek_fej jf
            on jf.id = jt.fk_jelentesek_fej
            right join regiok_kapcs_telephelyek rkt
            on rkt.fk_telephelyek = jf.fk_telephelyek
            where jf.ervenytelen = 0
                and jf.created_at <= ?
                and jf.created_at >= ?
                and (? is null or jf.fk_kerdoivek in [[kerdoiv_idk]])
                and (? is null or jf.fk_partnerek in [[partner_idk]])
                and (? is null or jf.fk_telephelyek in [[telephely_idk]])
                and (? is null or jf.fk_eszkozok in [[eszkoz_idk]])
                and jt.kerdes_azonosito in [[kerdes_idk]]
            group by rkt.fk_regiok, jt.kerdes_azonosito, jt.valasz_sorszam
        ";

        public static $jelentes_valasz_sel = "
            select
                *
            from jelentesek_tetel
            where fk_jelentesek_fej = ?
        ";

        public static $jelentes_valasz_sel_for_idk = "
            select
                *
            from jelentesek_tetel
            where fk_jelentesek_fej in [[jelentes_fej_idk]]
        ";

        public static $add_eszkoz_vezerles = "
            insert into eszkoz_vezerlesek
            (`eszkoz_azonosito`, `action`, `content`)
            values (?, ?, ?)
        ";

        public static $add_eszkoz_vezerles_with_automata = "
            insert into eszkoz_vezerlesek
            (`eszkoz_azonosito`, `action`, `content`, `letrehozva`)
            values (?, ?, ?, ?)
        ";

        public static $get_eszkoz_vezerlesek = "
            select *
            from eszkoz_vezerlesek
            where eszkoz_azonosito = ?
            and letrehozva <= current_timestamp()
        ";

        public static $remove_eszkoz_vezerlesek = "
            delete from eszkoz_vezerlesek
            where id in [[idk]]
        ";

        public static $get_rendszerszintu_kerdes_kerdoivek = "
            select fk_kerdoivek
            from kerdoivek_kerdesek_kell_rendszerszintu
            where fk_kerdoivek_rendszerszintu = ?
        ";

        public static $jelentesek_sel_ido_szerint_nap_orai = "
            select
                hour(jf.created_at) nap_oraja,
                jt.valasz_sorszam,
                count(*) as elofordulas
            from jelentesek_tetel jt
            left join jelentesek_fej jf
            on jf.id = jt.fk_jelentesek_fej
            where jt.kerdes_azonosito = ?
                and jf.ervenytelen = 0
                and jf.created_at <= ?
                and jf.created_at >= ?
                and (? is null or jf.fk_kerdoivek in [[kerdoiv_idk]])
                and (? is null or jf.fk_partnerek in [[partner_idk]])
                and (? is null or jf.fk_telephelyek in [[telephely_idk]])
                and (? is null or jf.fk_eszkozok in [[eszkoz_idk]])
            group by hour(jf.created_at), jt.valasz_sorszam
        ";

        public static $jelentesek_sel_ido_szerint_het_napjai = "
            select
                (weekday(jf.created_at)+1) het_napja,
                jt.valasz_sorszam,
                count(*) as elofordulas
            from jelentesek_tetel jt
            left join jelentesek_fej jf
            on jf.id = jt.fk_jelentesek_fej
            where jt.kerdes_azonosito = ?
                and jf.ervenytelen = 0
                and jf.created_at <= ?
                and jf.created_at >= ?
                and (? is null or jf.fk_kerdoivek in [[kerdoiv_idk]])
                and (? is null or jf.fk_partnerek in [[partner_idk]])
                and (? is null or jf.fk_telephelyek in [[telephely_idk]])
                and (? is null or jf.fk_eszkozok in [[eszkoz_idk]])
            group by (weekday(jf.created_at)+1), jt.valasz_sorszam
        ";

        public static $jelentesek_sel_trend_szerint_het = "
            select
                year(jf.created_at) ev,
                week(jf.created_at, 5) het,
                jt.kerdes_azonosito,
                jt.valasz_sorszam,
                count(*) as elofordulas
            from jelentesek_tetel jt
            left join jelentesek_fej jf
            on jf.id = jt.fk_jelentesek_fej
            where jf.ervenytelen = 0
                and jf.created_at <= ?
                and jf.created_at >= ?
                and (? is null or jf.fk_kerdoivek in [[kerdoiv_idk]])
                and (? is null or jf.fk_partnerek in [[partner_idk]])
                and (? is null or jf.fk_telephelyek in [[telephely_idk]])
                and (? is null or jf.fk_eszkozok in [[eszkoz_idk]])
                and jt.kerdes_azonosito in [[kerdes_idk]]
            group by year(jf.created_at), week(jf.created_at, 5), jt.kerdes_azonosito, jt.valasz_sorszam
        ";

        public static $jelentesek_sel_trend_szerint_nap = "
            select
                day(jf.created_at) nap,
                jt.kerdes_azonosito,
                jt.valasz_sorszam,
                count(*) as elofordulas
            from jelentesek_tetel jt
            left join jelentesek_fej jf
            on jf.id = jt.fk_jelentesek_fej
            where jf.ervenytelen = 0
                and jf.created_at <= ?
                and jf.created_at >= ?
                and (? is null or jf.fk_kerdoivek in [[kerdoiv_idk]])
                and (? is null or jf.fk_partnerek in [[partner_idk]])
                and (? is null or jf.fk_telephelyek in [[telephely_idk]])
                and (? is null or jf.fk_eszkozok in [[eszkoz_idk]])
                and jt.kerdes_azonosito in [[kerdes_idk]]
            group by day(jf.created_at), jt.kerdes_azonosito, jt.valasz_sorszam
        ";

        public static $jelentesek_sel_trend_szerint_honap = "
            select
                year(jf.created_at) ev,
                month(jf.created_at) honap,
                jt.kerdes_azonosito,
                jt.valasz_sorszam,
                count(*) as elofordulas
            from jelentesek_tetel jt
            left join jelentesek_fej jf
            on jf.id = jt.fk_jelentesek_fej
            where jf.ervenytelen = 0
                and jf.created_at <= ?
                and jf.created_at >= ?
                and (? is null or jf.fk_kerdoivek in [[kerdoiv_idk]])
                and (? is null or jf.fk_partnerek in [[partner_idk]])
                and (? is null or jf.fk_telephelyek in [[telephely_idk]])
                and (? is null or jf.fk_eszkozok in [[eszkoz_idk]])
                and jt.kerdes_azonosito in [[kerdes_idk]]
            group by year(jf.created_at), month(jf.created_at), jt.kerdes_azonosito, jt.valasz_sorszam
        ";

        public static $jelentesek_sel_trend_szerint_negyedev = "
            select
                year(jf.created_at) ev,
                quarter(jf.created_at) negyedev,
                jt.kerdes_azonosito,
                jt.valasz_sorszam,
                count(*) as elofordulas
            from jelentesek_tetel jt
            left join jelentesek_fej jf
            on jf.id = jt.fk_jelentesek_fej
            where jf.ervenytelen = 0
                and jf.created_at <= ?
                and jf.created_at >= ?
                and (? is null or jf.fk_kerdoivek in [[kerdoiv_idk]])
                and (? is null or jf.fk_partnerek in [[partner_idk]])
                and (? is null or jf.fk_telephelyek in [[telephely_idk]])
                and (? is null or jf.fk_eszkozok in [[eszkoz_idk]])
                and jt.kerdes_azonosito in [[kerdes_idk]]
            group by year(jf.created_at), quarter(jf.created_at), jt.kerdes_azonosito, jt.valasz_sorszam
        ";

        public static $jelentesek_sel_szurokerdes_szerint = "
            select
                jt2.valasz_sorszam as szurokerdes_valasz_sorszam,
                jt.valasz_sorszam,
                count(*) as elofordulas
            from jelentesek_tetel jt
            left join jelentesek_fej jf
            on jf.id = jt.fk_jelentesek_fej
            left join jelentesek_tetel jt2
            on jf.id = jt2.fk_jelentesek_fej
            where jt.kerdes_azonosito = ?
                and jt2.kerdes_azonosito = ?
                and jf.ervenytelen = 0
                and jf.created_at <= ?
                and jf.created_at >= ?
                and (? is null or jf.fk_kerdoivek in [[kerdoiv_idk]])
                and (? is null or jf.fk_partnerek in [[partner_idk]])
                and (? is null or jf.fk_telephelyek in [[telephely_idk]])
                and (? is null or jf.fk_eszkozok in [[eszkoz_idk]])
            group by jt2.valasz_sorszam, jt.valasz_sorszam
        ";

        public static $is_eszkoz_online = "
            select online
            from eszkozok
            where eszkoz_azonosito = ?
        ";

        public static $elemi_jog_szovegek_sel = "
            select
                j.kod,
                jsz.nev
            from elemi_jogok_szovegek jsz
            left join elemi_jogok j
            on j.id = jsz.fk_elemi_jogok
        ";

        public static $set_utolso_aktivitas = "
            update eszkozok
            set utolso_aktivitas_idopontja = current_timestamp()
            where eszkoz_azonosito = ?
        ";

        public static $jelentesek_kitoltesek_szama = "
            select count(*) as kitoltesek_szama
            from jelentesek_fej
            where fk_partnerek = ?
                and fk_telephelyek in [[telephelyek]]
                and created_at >= ?
                and created_at <= ?
                and ervenytelen = 0
        ";

        public static $jelentesek_kitoltesek_szama_telephelyenkent = "
            select
                fk_telephelyek,
                count(*) as kitoltesek_szama
            from jelentesek_fej
            where fk_partnerek = ?
                and fk_telephelyek in [[telephelyek]]
                and created_at >= ?
                and created_at <= ?
                and ervenytelen = 0
            group by fk_telephelyek
        ";

        public static $jelentesek_kitoltesek_szama_havonta = "
            select
                year(created_at) as ev,
                month(created_at) as honap,
                count(*) as kitoltesek_szama
            from jelentesek_fej
            where fk_partnerek = ?
                and fk_telephelyek in [[telephelyek]]
                and created_at >= ?
                and created_at <= ?
                and ervenytelen = 0
            group by year(created_at), month(created_at)
        ";

        public static $jelentesek_ertekes_sel = "
        select
        jf.fk_telephelyek,
        rkt.fk_regiok,
        kk.id as kerdes_id,
        year(jf.created_at) ev,
        month(jf.created_at) honap,
        kk.fk_kerdoivek_valasz_tipusok,
        kvt.kod as valasz_tipus_kod,
        jt.valasz_sorszam
    from jelentesek_fej jf
    left join regiok_kapcs_telephelyek rkt
    on rkt.fk_telephelyek = jf.fk_telephelyek
    left join jelentesek_tetel jt
    on jt.fk_jelentesek_fej = jf.id
    left join kerdoivek_kerdesek kk
    on kk.id = jt.fk_kerdoivek_kerdesek
    left join kerdoivek_valasz_tipusok kvt
    on kvt.id = kk.fk_kerdoivek_valasz_tipusok
    where jf.fk_partnerek = ?
        and jf.fk_telephelyek in [[telephelyek]]
        and jf.ervenytelen = 0
        and kk.fk_kerdoivek_valasz_tipusok in (1, 5, 7, 8, 12, 13, 14, 15, 18, 19, 20, 23)
        and jf.created_at >= ?
        and jf.created_at <= ?
        ";

        public static $jelentesek_ertekes_sel_nap = "
        select
        jf.fk_telephelyek,
        rkt.fk_regiok,
        kk.id as kerdes_id,
        day(jf.created_at) nap,
        kk.fk_kerdoivek_valasz_tipusok,
        kvt.kod as valasz_tipus_kod,
        jt.valasz_sorszam
    from jelentesek_fej jf
    left join regiok_kapcs_telephelyek rkt
    on rkt.fk_telephelyek = jf.fk_telephelyek
    left join jelentesek_tetel jt
    on jt.fk_jelentesek_fej = jf.id
    left join kerdoivek_kerdesek kk
    on kk.id = jt.fk_kerdoivek_kerdesek
    left join kerdoivek_valasz_tipusok kvt
    on kvt.id = kk.fk_kerdoivek_valasz_tipusok
    where jf.fk_partnerek = ?
        and jf.fk_telephelyek in [[telephelyek]]
        and jf.ervenytelen = 0
        and kk.fk_kerdoivek_valasz_tipusok in (1, 5, 7, 8, 12, 13, 14, 15, 18, 19, 20)
        and jf.created_at >= ?
        and jf.created_at <= ?
        ";

        public static $get_jelentes_history = "
            select distinct
                fk_eszkozok,
                fk_kerdoivek,
                fk_telephelyek
            from jelentesek_fej
        ";

        public static $get_azonosito_valaszok = "
            select
                kk.azonosito azonosito,
                kk.id id,
                kkk.adat_kod,
                kkk.adat_content
            from kerdoivek_kerdesek kk
            left join kerdoivek_kerdesek_kieg kkk
            on kkk.fk_kerdoivek_kerdesek = kk.id
            where kk.fk_kerdoivek_valasz_tipusok = 4
            and kkk.adat_kod like 'valasz%'
            order by kk.azonosito asc, kk.id asc, kkk.adat_kod asc
        ";

        public static $get_rendszerszintu_kerdes_szovegek = "
            select
                sz.kerdes_szovege,
                sz.fk_kerdoivek_kerdesek,
                sz.fk_kerdoivek
            from kerdoivek_kerdesek_szovegek sz
            left join kerdoivek_kerdesek k
            on k.id = sz.fk_kerdoivek_kerdesek
            where k.fk_kerdoivek is null
        ";

        public static $add_eszkoz_vezerles_automata = "
            insert into eszkoz_vezerlesek_automata
            (`eszkoz_azonosito`, `het_napja`, `oraperc`, `action`, `content`)
            values (?, ?, ?, ?, ?)
        ";

        public static $get_eszkoz_vezerles_automata = "
            select
                a.*,
                e.id as eszkoz_id
            from eszkoz_vezerlesek_automata a
            left join eszkozok e
            on e.eszkoz_azonosito = a.eszkoz_azonosito
            where a.eszkoz_azonosito = ?
        ";

        public static $del_eszkoz_vezerles_automata = "
            delete from eszkoz_vezerlesek_automata
            where eszkoz_azonosito = ? and id = ?
        ";

        public static $mod_eszkoz_vezerles_automata = "
            update eszkoz_vezerlesek_automata
            set [[col]] = ?
            where id = ?
        ";

        public static $automata_sel = "
            select
                *
            from eszkoz_vezerlesek_automata
        ";

        public static $add_eszkoz_vezerles_automata_history = "
            insert into eszkoz_vezerlesek_automata_history
            (`datum`, `fk_eszkoz_vezerlesek_automata`)
            values(?, ?)
        ";

        public static $isset_eszkoz_vezerles_automata_history = "
            select count(*) as cnt
            from eszkoz_vezerlesek_automata_history
            where datum = ?
            and fk_eszkoz_vezerlesek_automata = ?
        ";

        public static $get_nyelv = "
            select count(*) as cnt
            from lang_list
            where lang_code = ?
        ";

        public static $new_nyelv = "
            insert into lang_list
            (`lang_code`, `lang_name`, `formatum`)
            values (?, ?, ?)
        ";

        public static $mod_nyelv = "
            update lang_list
            set lang_name = ?, formatum = ?
            where lang_code = ?
        ";

        public static $get_formatum_of_lang = "
            select formatum
            from lang_list
            where lang_code = ?
        ";

        public static $akt_nyelv = "
            update lang_list
            set active = ?
            where lang_code = ?
        ";

        public static $del_nyelv = "
            delete from lang_list
            where lang_code = ?
        ";

        public static $nyelvek_admin_sel = "
            select
                lang_code as nyelv_kod,
                formatum as formatum,
                lang_name as nyelv_nev,
                active as aktiv
            from lang_list
        ";

        public static $kapcsolat_new = "
            insert into kapcsolat
            (`nev`, `email`, `telefon`, `uzenet`, `cegnev`, `mit_ker`, `mikor_jott`)
            values (?, ?, ?, ?, ?, ?, ?)
        ";

        public static $kapcsolat_sel = "
            select *
            from kapcsolat
        ";

        public static $kapcsolat_olvas  = "
            update kapcsolat
            set olvasott = ?
            where id = ?
        ";

        public static $elemi_jogok_sel  = "
            select *
            from elemi_jogok
        ";

        public static $elemi_jogok_szovegek_sel = "
            select *
            from elemi_jogok_szovegek
            where lang = ?
        ";

        public static $set_elemi_jog_forditas = "
            insert ignore into elemi_jogok_szovegek
            (`fk_elemi_jogok`, `lang`, `nev`, `leiras`)
            values (?, ?, ?, ?)
        ";

        public static $isset_elemi_jog_forditas = "
            select count(*) as cnt
            from elemi_jogok_szovegek
            where fk_elemi_jogok = ? and lang = ?
        ";

        public static $mod_elemi_jog_forditas = "
            update elemi_jogok_szovegek
            set nev = ?, leiras = ?
            where fk_elemi_jogok = ?
            and lang = ?
        ";

        public static $figyelesek_sel = "
            select
                f.id,
                f.fk_kerdoivek,
                f.masodperc,
                j.created_at utolso_jelentes_megnezve
            from gyanus_figyelesek f
            left join jelentesek_fej j
            on j.id = f.last_jelentes_id
            where f.fk_kerdoivek in ([[kerdoiv_idk]])
        ";

        public static $figyelesek_sel_all = "
            select
                *
            from gyanus_figyelesek
        ";

        public static $figyelesek_new = "
            insert ignore into gyanus_figyelesek
            (`fk_kerdoivek`, `masodperc`, `fk_creator`)
            values (?, ?, ?)
        ";

        public static $figyelesek_mod = "
            update gyanus_figyelesek
            set masodperc = ?, last_jelentes_id = null
            where fk_kerdoivek = ?
        ";

        public static $figyelesek_del = "
            delete from gyanus_figyelesek
            where id = ?
        ";

        public static $jelentesek_fej_figyeles_sel = "
            select * from jelentesek_fej
            where fk_kerdoivek = ?
            and (? is null or id > ?)
            order by id asc
            limit 1000
        ";

        public static $gyanus_jelentesek_inactivate = "
            update jelentesek_fej
            set ervenytelen = 1
            where id in ([[idk]])
        ";

        public static $set_last_jelentes_id_to_gyanus = "
            update gyanus_figyelesek
            set last_jelentes_id = ?
            where id = ?
        ";

        public static $eszkozok_eszkoz_hozzarendeles = "
            update eszkozok
            set hozzakapcsolt_online_eszkoz = ?
            where id = ?
        ";

        public static $get_eszkoz_online_from_id = "
            select online
            from eszkozok
            where id = ?
        ";

        public static $get_kerdoiv_nyelvek = "
            select *
            from kerdoivek_nyelvek
            where fk_kerdoivek in [[kerdoivek]]
        ";

        public static $import_eszkoz_new = "
            insert into eszkozok
            (
                `nev`,
                `eszkoz_azonosito`,
                `fk_telephelyek`,
                `online`,
                `fk_users_creator`,
                `aktiv`
            )
            values (?, ?, (
                select id
                from telephelyek
                where nev = ?
            ), ?, ?, ?)
        ";

        public static $import_telephely_new = "
            insert into telephelyek
            (
                `nev`,
                `fk_partnerek`,
                `fk_orszag`,
                `iranyitoszam`,
                `telepules`,
                `cim`,
                `kapcs_neve`,
                `email`,
                `telefon`,
                `megjegyzes`,
                `fk_users_creator`
            )
            values (?, (
                select id
                from partnerek
                where nev = ?
            ), (
                select ctr_id
                from orszagok
                where ctr_name = ?
            ), ?, ?, ?, ?, ?, ?, ?, ?)
        ";

        public static $get_kerdoiv_ertesites_rules = "
            select *
            from kerdoiv_ertesitesek
        ";


        public static $eszkoz_inaktiv = "
            select e.nev as 'nev', e.utolso_aktivitas_idopontja as 'utolso_aktivitas_idopontja', p.nev as 'partner_nev' from eszkozok e
            left join telephelyek t
            on fk_telephelyek = t.id
            left join partnerek p
            on p.id = t.fk_partnerek
            where e.inaktiv_riasztas = 1 AND e.aktiv = 1 AND e.online = 0 AND e.utolso_aktivitas_idopontja < DATE_SUB(NOW(), INTERVAL 30 MINUTE) and p.aktiv = 1
            order by partner_nev ASC, nev asc, utolso_aktivitas_idopontja asc;
        ";

        public static $kerdoiv_ertesitesek_kuldes = "
            insert into kerdoiv_ertesitesek_kuldes
            (`fk_kerdoivek_kerdesek`, `valaszolt_sorszam`, `fk_eszkozok`)
            values (?,?,?)
        ";

        public static $new_ertesitesek_run_sel = "
            select
                kek.*,
                e.nev as eszkoz_nev,
                k.nev as kerdoiv_nev,
                sz.kerdes_szovege,
                kk.fk_kerdoivek_valasz_tipusok,
                e.ertesitendo_email
            from kerdoiv_ertesitesek_kuldes kek
            left join eszkozok e
            on e.id = kek.fk_eszkozok
            left join kerdoivek_kerdesek kk
            on kek.fk_kerdoivek_kerdesek = kk.id
            left join kerdoivek k
            on k.id = e.fk_kerdoivek
            left join kerdoivek_kerdesek_szovegek sz
            on sz.fk_kerdoivek_kerdesek = kek.fk_kerdoivek_kerdesek
            where kek.ertesito_kuldve = 0
            and sz.lang = ?
            and sz.fk_kerdoivek is null
        ";

        public static $kerdoiv_ertesites_kikuldve = "
            update kerdoiv_ertesitesek_kuldes
            set ertesito_kuldve = 1
            where id = ?
        ";

        public static $kerdoiv_ertesites_nincs = "
            delete from kerdoiv_ertesitesek_kuldes
            where id = ?
        ";

        public static $ismerv_csoportok_sel = "
            select
                cs.id,
                cs.fk_partnerek as partner_id,
                cs.nev,
                (
                    select
                        count(*) as cnt
                    from beolvasas b
                    where b.fk_ismerv_csoportok = cs.id
                ) as kikuldve_darab
            from ismerv_csoportok cs
            where cs.fk_partnerek = ?
        ";

        public static $ismerv_csoportok_new = "
            insert into ismerv_csoportok
            (`fk_partnerek`, `nev`)
            values (?,?)
        ";

        public static $ismerv_csoportok_mod = "
            update ismerv_csoportok
            set nev = ?
            where id = ?
        ";

        public static $ismerv_csoportok_del = "
            delete from ismerv_csoportok
            where id = ?
        ";

        public static $ismervek_of_ismerv_csoport_del = "
            delete from ismervek
            where fk_ismerv_csoportok = ?
        ";

        public static $ismervek_new = "
            insert into ismervek
            (`fk_ismerv_csoportok`, `nev`)
            values (?,?)
        ";


        public static $ismervek_new_ismerv_mutat="
        insert into ismervek
        (`fk_ismerv_csoportok`, `nev`,`ismerv_mutat`)
        values (?,?,?)";


        //kiegeszites ismerv_mutat
        public static $ismervek_sel = "
            select
                id,
                fk_ismerv_csoportok as ismerv_csoport_id,
                nev,
                ismerv_mutat
            from ismervek
            where fk_ismerv_csoportok = ?
        ";

        public static $ismervek_del = "
            delete from ismervek
            where id = ?
        ";

        public static $ismervek_mod = "
            update ismervek
            set nev = ?
            where id = ?
        ";

        public static $beolvasas_new = "
            insert into beolvasas
            (`nev`, `fk_ismerv_csoportok`, `fk_partnerek`)
            values (?, ?, ?)
        ";

        public static $get_max_beolvasas_id = "
            select
                max(id) as max_id
            from beolvasas
        ";

        public static $beolvasas_sor_new = "
            insert into beolvasas_sorok
            (`user_id`, `user_email`, `fk_beolvasas`)
            values (?, ?, ?)
        ";

        public static $get_max_beolvasas_sor_id = "
            select
                max(id) as max_id
            from beolvasas_sorok
        ";

        public static $beolvasas_sor_ismerv_new = "
            insert into beolvasas_sorok_ismervek
            (`fk_beolvasas_sorok`, `fk_ismervek`, `ismerv`)
            values (?, ?, ?)
        ";

        public static $beolvasas_sel = "
            select
                b.id,
                b.nev,
                b.fk_ismerv_csoportok ismerv_csoport_id,
                cs.nev ismerv_csoport_nev,
                b.fk_eszkozok eszkoz_id,
                b.fk_email_sablonok sablon_id,
                e.nev sablon_nev,
                b.kikuldve,
                b.fk_partnerek partner_id,
                (select count(*) from beolvasas_sorok where fk_beolvasas = b.id) as sorok_szama,
                b.beolvasva
            from beolvasas b
            left join ismerv_csoportok cs
            on cs.id = b.fk_ismerv_csoportok
            left join email_sablonok e
            on e.id = b.fk_email_sablonok
            where b.fk_partnerek = ?
        ";

        public static $beolvasas_ismervek_sel = "
            select distinct
                si.ismerv as beolvasott_ismerv,
                si.fk_ismervek as ismerv_id
            from beolvasas_sorok_ismervek si
            left join ismervek i
            on i.id = si.fk_ismervek
            left join beolvasas_sorok bs
            on bs.id = si.fk_beolvasas_sorok
            where bs.fk_beolvasas in [[beolvasas_idk]]
        ";

        public static $beolvasas_ismervek_sel_by_fk = "
            SELECT DISTINCT(ismerv), fk_ismervek FROM `beolvasas_sorok_ismervek` WHERE fk_ismervek in [[fk_ismervek_id]]
        ";

        public static $beolvasas_tetel_ismervek_sel = "
            select
                si.id as beolvasas_sorok_ismervek_id,
                bs.id as beolvasas_sorok_id,
                bs.fk_beolvasas beolvasas_id,
                i.id as ismerv_id,
                i.nev as ismerv_nev,
                si.ismerv as beolvasott_ismerv
            from beolvasas_sorok_ismervek si
            left join ismervek i
            on i.id = si.fk_ismervek
            left join beolvasas_sorok bs
            on bs.id = si.fk_beolvasas_sorok
            where bs.fk_beolvasas in [[beolvasas_idk]]
        ";

        public static $beolvasas_sorok_sel = "
            select
                id,
                user_id,
                user_email
            from beolvasas_sorok
            where fk_beolvasas = ?
        ";

        public static $beolvasas_sorok_ismervek_sel = "
            select
                si.id,
                i.id as ismerv_id,
                i.nev as ismerv_nev,
                si.ismerv
            from beolvasas_sorok_ismervek si
            left join ismervek i
            on i.id = si.fk_ismervek
            where si.fk_beolvasas_sorok = ?
        ";


        //ismervek_mutat kieg
        public static $beolvasas_sorok_ismervek_sel_csoport_nev="
        SELECT
         si.id,
          i.id AS ismerv_id,
           i.nev AS ismerv_nev,
           i.ismerv_mutat AS ismerv_mutat,
            si.ismerv,
            csoportok.nev AS ismerv_csoport_nev
            FROM beolvasas_sorok_ismervek si LEFT JOIN ismervek i ON i.id = si.fk_ismervek
            LEFT JOIN ismerv_csoportok csoportok ON csoportok.id = i.fk_ismerv_csoportok WHERE si.fk_beolvasas_sorok = ?
        ";

        public static $beolvasas_eszkoz_set = "
            update beolvasas
            set fk_eszkozok = ?
            where id = ?
        ";

        public static $beolvasas_sablon_set = "
            update beolvasas
            set fk_email_sablonok = ?
            where id = ?
        ";

        public static $get_beolvasas_eszkoz = "
            select e.eszkoz_azonosito, e.online
            from eszkozok e
            left join beolvasas b
            on b.fk_eszkozok = e.id
            where b.id = ?
        ";

        public static $kikuldve_beallitasa = "
            update beolvasas
            set kikuldve = current_timestamp()
            where id = ?
        ";

        public static $get_beolvasas = "
            select *
            from beolvasas
            where id = ?
        ";

        public static $isset_beolvasas_sor = "
            select count(*) as cnt
            from beolvasas_sorok
            where id = ?
        ";

        public static $beolvasas_sor_jelentesek_sel = "
            select
                bsi.fk_beolvasas_sorok as beolvasas_sor_id,
                i.id as ismerv_id,
                i.nev as ismerv_nev,
                bsi.ismerv as ismerv_ertek
            from beolvasas_sorok_ismervek bsi
            left join ismervek i
            on i.id = bsi.fk_ismervek
            where bsi.fk_beolvasas_sorok in [[beolvasas_sor_idk]]
        ";

        public static $ismerv_csoport_started_by_ismerv_csoport = "
            select
                count(*) as cnt
            from beolvasas b
            where b.fk_ismerv_csoportok = ?
        ";

        public static $ismerv_csoport_started_by_ismerv = "
            select
                count(*) as cnt
            from beolvasas b
            where b.fk_ismerv_csoportok = (
                select i.fk_ismerv_csoportok
                from ismervek i
                where i.id = ?
            )
        ";

        public static $jelentesek_sel_osszevont_nps = "
            select
                year(jf.created_at) ev,
                month(jf.created_at) honap,
                jf.fk_partnerek partner_id,
                jf.fk_kerdoivek kerdoiv_id,
                jf.fk_telephelyek telephely_id,
                jf.fk_eszkozok eszkoz_id,
                jt.fk_kerdoivek_kerdesek kerdes_id,
                jt.valasz_sorszam
            from jelentesek_tetel jt
            left join jelentesek_fej jf
            on jf.id = jt.fk_jelentesek_fej
            where jt.kerdes_azonosito = ?
                and jf.ervenytelen = 0
                and jf.created_at <= ?
                and jf.created_at >= ?
                and (? is null or jf.fk_kerdoivek in [[kerdoiv_idk]])
                and (? is null or jf.fk_partnerek in [[partner_idk]])
                and (? is null or jf.fk_telephelyek in [[telephely_idk]])
                and (? is null or jf.fk_eszkozok in [[eszkoz_idk]])
        ";

        public static $get_kerdes_idk_of_kerdoiv = "
            select
                id
            from kerdoivek_kerdesek kk
            where fk_kerdoivek = ?
        ";

        public static $jelentesek_sel_osszevont_telephely = "
            select
                year(jf.created_at) ev,
                month(jf.created_at) honap,
                jt.fk_kerdoivek_kerdesek kerdes_id,
                jt.valasz_sorszam
            from jelentesek_tetel jt
            left join kerdoivek_kerdesek kk
            on kk.id = jt.fk_kerdoivek_kerdesek
            left join jelentesek_fej jf
            on jf.id = jt.fk_jelentesek_fej
            where jf.fk_telephelyek = ?
                and jf.ervenytelen = 0
                and jf.created_at <= ?
                and jf.created_at >= ?
                and (? is null or jt.fk_kerdoivek_kerdesek in [[kerdes_idk]])
                and kk.fk_kerdoivek_valasz_tipusok in (1, 2, 5, 7, 8, 12, 13, 14, 15, 18, 19, 20, 22)
        ";

        public static $jelentesek_sel_ismerv_trend_het = "
            select
                year(jf.created_at) ev,
                week(jf.created_at, 3) het,
                bsi.ismerv as ismerv_ertek,
                jt.valasz_sorszam,
                count(*) as elofordulas
            from jelentesek_tetel jt
            left join jelentesek_fej jf
            on jf.id = jt.fk_jelentesek_fej
            left join beolvasas_sorok bs
            on bs.id = jf.fk_beolvasas_sorok
            left join beolvasas_sorok_ismervek bsi
            on bsi.fk_beolvasas_sorok = bs.id
            where jt.kerdes_azonosito = ?
                and bs.fk_beolvasas in [[beolvasas_idk]]
                and bsi.fk_ismervek = ?
                and jf.ervenytelen = 0
                and jf.created_at <= ?
                and jf.created_at >= ?
                and (? is null or bsi.ismerv in [[ismerv_ertekek]])
            group by year(jf.created_at), week(jf.created_at, 3), bsi.ismerv, jt.valasz_sorszam
        ";

        public static $jelentesek_sel_ismerv_trend_honap = "
            select
                year(jf.created_at) ev,
                month(jf.created_at) honap,
                bsi.ismerv as ismerv_ertek,
                jt.valasz_sorszam,
                count(*) as elofordulas
            from jelentesek_tetel jt
            left join jelentesek_fej jf
            on jf.id = jt.fk_jelentesek_fej
            left join beolvasas_sorok bs
            on bs.id = jf.fk_beolvasas_sorok
            left join beolvasas_sorok_ismervek bsi
            on bsi.fk_beolvasas_sorok = bs.id
            where jt.kerdes_azonosito = ?
                and bs.fk_beolvasas in [[beolvasas_idk]]
                and bsi.fk_ismervek = ?
                and jf.ervenytelen = 0
                and jf.created_at <= ?
                and jf.created_at >= ?
                and (? is null or bsi.ismerv in [[ismerv_ertekek]])
            group by year(jf.created_at), month(jf.created_at), bsi.ismerv, jt.valasz_sorszam
        ";

        public static $jelentesek_sel_ismerv_trend_negyedev = "
            select
                year(jf.created_at) ev,
                quarter(jf.created_at) negyedev,
                bsi.ismerv as ismerv_ertek,
                jt.valasz_sorszam,
                count(*) as elofordulas
            from jelentesek_tetel jt
            left join jelentesek_fej jf
            on jf.id = jt.fk_jelentesek_fej
            left join beolvasas_sorok bs
            on bs.id = jf.fk_beolvasas_sorok
            left join beolvasas_sorok_ismervek bsi
            on bsi.fk_beolvasas_sorok = bs.id
            where jt.kerdes_azonosito = ?
                and bs.fk_beolvasas in [[beolvasas_idk]]
                and bsi.fk_ismervek = ?
                and jf.ervenytelen = 0
                and jf.created_at <= ?
                and jf.created_at >= ?
                and (? is null or bsi.ismerv in [[ismerv_ertekek]])
            group by year(jf.created_at), quarter(jf.created_at), bsi.ismerv, jt.valasz_sorszam
        ";

        public static $jelentesek_sel_ismerv_trend_ev = "
            select
                year(jf.created_at) ev,
                bsi.ismerv as ismerv_ertek,
                jt.valasz_sorszam,
                count(*) as elofordulas
            from jelentesek_tetel jt
            left join jelentesek_fej jf
            on jf.id = jt.fk_jelentesek_fej
            left join beolvasas_sorok bs
            on bs.id = jf.fk_beolvasas_sorok
            left join beolvasas_sorok_ismervek bsi
            on bsi.fk_beolvasas_sorok = bs.id
            where jt.kerdes_azonosito = ?
                and bs.fk_beolvasas in [[beolvasas_idk]]
                and bsi.fk_ismervek = ?
                and jf.ervenytelen = 0
                and jf.created_at <= ?
                and jf.created_at >= ?
                and (? is null or bsi.ismerv in [[ismerv_ertekek]])
            group by year(jf.created_at), bsi.ismerv, jt.valasz_sorszam
        ";

        public static $jelentesek_sel_ismerv_jelentes = "
            select
                bsi.ismerv as ismerv_ertek,
                jt.valasz_sorszam,
                count(*) as elofordulas
            from jelentesek_tetel jt
            left join jelentesek_fej jf
            on jf.id = jt.fk_jelentesek_fej
            left join beolvasas_sorok bs
            on bs.id = jf.fk_beolvasas_sorok
            left join beolvasas_sorok_ismervek bsi
            on bsi.fk_beolvasas_sorok = bs.id
            where jt.kerdes_azonosito = ?
                and bs.fk_beolvasas in [[beolvasas_idk]]
                and bsi.fk_ismervek = ?
                and jf.ervenytelen = 0
                and jf.created_at <= ?
                and jf.created_at >= ?
                and (? is null or bsi.ismerv in [[ismerv_ertekek]])
            group by bsi.ismerv, jt.valasz_sorszam
        ";

        public static $get_kuldo_adat_of_partner_beolvasas = "
            select
                p.email_kuldo_neve,
                p.email_kuldo_email_cime
            from partnerek p
            left join beolvasas b
            on b.fk_partnerek = p.id
            where b.id = ?
        ";

        public static $email_sablon_new = "
            insert into email_sablonok
            (`fk_partnerek`, `nev`, `targy`, `alt_text`, `text`, `sablon_tipus`, `automatikus_valasz`)
            values (?, ?, ?, ?, ?, ?, ?)
        ";

        public static $email_sablon_mod = "
            update email_sablonok
            set nev = ?, targy = ?, text = ?, alt_text = ?, sablon_tipus = ?, automatikus_valasz = ?
            where id = ?
        ";

        public static $email_sablon_act = "
            update email_sablonok
            set aktiv = ?
            where id = ?
        ";

        public static $email_sablon_sel = "
            select
                id,
                fk_partnerek as partner_id,
                nev,
                targy,
                automatikus_valasz,
                sablon_tipus,
                text,
                alt_text,
                letrehozva,
                kep_logo,
                kep_alairas,
                kep_link,
                aktiv
            from email_sablonok
            where aktiv >= ?
        ";

        public static $email_sablon_sel_partner = "
            select
                id,
                fk_partnerek as partner_id,
                nev,
                targy,
                automatikus_valasz,
                sablon_tipus,
                text,
                alt_text,
                letrehozva,
                kep_logo,
                kep_alairas,
                kep_link,
                aktiv
            from email_sablonok
            where aktiv >= ?
            and fk_partnerek = ?
        ";

        public static $email_sablon_set_picture_kep_logo = "
            update email_sablonok
            set kep_logo = ?
            where id = ?
        ";

        public static $email_sablon_set_picture_kep_alairas = "
            update email_sablonok
            set kep_alairas = ?
            where id = ?
        ";

        public static $email_sablon_set_picture_kep_link = "
            update email_sablonok
            set kep_link = ?
            where id = ?
        ";

        public static $email_sablon_sel_id = "
            select
                *
            from email_sablonok
            where id = ?
        ";

        public static $kikuldes_darabszam_eszkozonkent_havonta = "
            select 
                year(b.kikuldve) ev,
                month(b.kikuldve) ho,
                b.fk_eszkozok eszkoz_id,
                count(*) darab
            from beolvasas b
            left join eszkozok e
            on e.id = b.fk_eszkozok
            left join telephelyek t
            on t.id = e.fk_telephelyek
            left join beolvasas_sorok bs
            on bs.fk_beolvasas = b.id
            where t.fk_partnerek = ?
            and b.kikuldve is not null
            and b.kikuldve >= ?
            and b.kikuldve <= ?
            group by year(b.kikuldve), month(b.kikuldve), b.fk_eszkozok
        ";

        public static $jelentesek_kitoltesek_szama_havonta_eszkozonkent = "
            select
                year(b.kikuldve) as ev,
                month(b.kikuldve) as ho,
                f.fk_eszkozok eszkoz_id,
                count(*) as darab
            from jelentesek_fej f
            left join beolvasas_sorok bs
            on bs.id = f.fk_beolvasas_sorok
            left join beolvasas b
            on b.id = bs.fk_beolvasas
            where f.fk_eszkozok in [[eszkoz_idk]]
                and b.kikuldve >= ?
                and b.kikuldve <= ?
                and f.ervenytelen = 0
            group by year(b.kikuldve), month(b.kikuldve), f.fk_eszkozok
        ";


        public static $jelentesek_kitoltesek_szama_havonta_eszkozonkent_felhasznalonkent = "
        select
            year(b.kikuldve) as ev,
            month(b.kikuldve) as ho,
            f.fk_eszkozok eszkoz_id,
            count(DISTINCT f.fk_beolvasas_sorok) as darab
        from jelentesek_fej f
        left join beolvasas_sorok bs
        on bs.id = f.fk_beolvasas_sorok
        left join beolvasas b
        on b.id = bs.fk_beolvasas
        where f.fk_eszkozok in [[eszkoz_idk]]
            and b.kikuldve >= ?
            and b.kikuldve <= ?
            and f.ervenytelen = 0
        group by year(b.kikuldve), month(b.kikuldve), f.fk_eszkozok
    ";



        public static $kerdes_valaszok_torlese = "
            delete from kerdoivek_kerdesek_kieg
            where fk_kerdoivek_kerdesek = ?
            and adat_kod like 'valasz%'
        ";

        public static $kerdes_valaszok_felvitele = "
            insert into kerdoivek_kerdesek_kieg
            (`fk_kerdoivek_kerdesek`, `adat_kod`, `adat_content`)
            values (?, ?, ?)
        ";

        public static $kerdes_valasz_tiltasok_torlese = "
            delete from kerdoivek_kerdesek_valasz_tiltasok
            where fk_kerdoivek_kerdesek = ?
        ";

        public static $kerdes_valasz_tiltasok_felvitele = "
            insert into kerdoivek_kerdesek_valasz_tiltasok
            (`fk_kerdoivek_kerdesek`, `fk_eszkozok`, `valasz_sorszama`)
            values (?,?,?)
        ";

        public static $kikuldesi_statisztika_sel = "
        SELECT  year(b.kikuldve) as ev, month(b.kikuldve) as honap, count(distinct bs.id) as kikuldott, SUM(if(jf.ervenytelen = '0', 1, 0)) as beerkezett,  b.fk_eszkozok [[select_expand]] FROM beolvasas_sorok bs
        
        LEFT JOIN beolvasas b
        ON bs.fk_beolvasas = b.id

        
        left join jelentesek_fej jf
        on jf.fk_beolvasas_sorok = bs.id

        [[join_expand]]
        
        where 
         b.fk_eszkozok IN [[eszkoz_idk]]
        and b.id IN [[beolvasas_idk]]
        and (jf.fk_kerdoivek in [[kerdoiv_idk]] or jf.fk_kerdoivek is null)
        [[where_expand]]
        
        -- and year(b.kikuldve) > 2022
         and b.kikuldve >= ?
         and b.kikuldve <= ?

        group by year(b.kikuldve), month(b.kikuldve),  b.fk_eszkozok [[group_by_expand]]
        order by year(b.kikuldve), month(b.kikuldve) asc
        ";

        public static $kerdesek_eredmenye_ismervek_szerint = "
        select
            jt.valasz_sorszam,
            jf.fk_eszkozok as eszkoz,
            count(*) as elofordulas

             [[select_expand]]

        from jelentesek_tetel jt
        left join jelentesek_fej jf
        on jf.id = jt.fk_jelentesek_fej
        left join beolvasas_sorok bs
        on bs.id = jf.fk_beolvasas_sorok

         [[join_expand]]

        where jt.kerdes_azonosito = ?
            and jf.ervenytelen = 0
            and bs.fk_beolvasas in [[beolvasas_idk]]
            and jf.fk_eszkozok IN [[eszkoz_idk]]
            and jf.created_at >= ?
            and jf.created_at <= ?
            -- and (? is null or bsi.ismerv in [[ismerv_ertekek]])

             [[where_expand]]

        group by jt.valasz_sorszam, jf.fk_eszkozok  [[group_by_expand]]
    ";

    public static $trend_report_automata_riport = "
        select
        jt.valasz_sorszam,
        jf.fk_eszkozok as eszkoz,
        count(*) as elofordulas,
        year(jf.created_at) as ev, month(jf.created_at) as honap

        [[select_expand]]

        from jelentesek_tetel jt
        left join jelentesek_fej jf
        on jf.id = jt.fk_jelentesek_fej
        left join beolvasas_sorok bs
        on bs.id = jf.fk_beolvasas_sorok
        LEFT JOIN beolvasas b
        ON bs.fk_beolvasas = b.id

        [[join_expand]]

        where jt.kerdes_azonosito = ?
            and jf.ervenytelen = 0
            and bs.fk_beolvasas in [[beolvasas_idk]]
            and jf.fk_eszkozok IN [[eszkoz_idk]]
            and jf.created_at >= ?
            and jf.created_at <= ?
            -- and (? is null or bsi.ismerv in [[ismerv_ertekek]])

        [[where_expand]]

    group by jt.valasz_sorszam, jf.fk_eszkozok, year(jf.created_at), month(jf.created_at) [[group_by_expand]]
    order by year(jf.created_at) asc, month(jf.created_at) asc
    ";





    public static $felhasznalo_naplozas = "
    insert into felhasznalo_naplozas
    (`felhasznalo_id`,`felhasznalo_nev`, `esemeny_kod`)
    values (?,?,?)";


    public static $naplozas_sel_all="select
    n.felhasznalo_id,
    n.felhasznalo_nev,
    n.esemeny_kod,
    n.idopont,
    GROUP_CONCAT(p.nev SEPARATOR ', ') as partnerek
    from felhasznalo_naplozas n
    left join users_kapcs_partnerek up
    on up.fk_users = n.felhasznalo_id
    left join partnerek p
    on p.id = up.fk_partnerek
    where (p.aktiv = 1 or (select count(*) from users_kapcs_partnerek where fk_users = n.id) = 0)
    and n.felhasznalo_id in [[felhasznalok]]
    group by n.id";



    public static $naplozas_sel_date="select
    n.felhasznalo_id,
    n.felhasznalo_nev,
    n.esemeny_kod,
    n.idopont,
    GROUP_CONCAT(p.nev SEPARATOR ', ') as partnerek
    from felhasznalo_naplozas n
    left join users_kapcs_partnerek up
    on up.fk_users = n.felhasznalo_id
    left join partnerek p
    on p.id = up.fk_partnerek
    where (p.aktiv = 1 or (select count(*) from users_kapcs_partnerek where fk_users = n.id) = 0)
    and n.idopont <= ?
    and n.idopont >= ?
    and n.felhasznalo_id in [[felhasznalok]]
    group by n.id";


    /*
    public static $naplozas_sel="select * from `felhasznalo_naplozas` where felhasznalo_id in [[felhasznalok]]";
    */  





    }