<?php

    class DataTypes{

		public static function boolints($var){
			return (bool)preg_match('/^(0|1)+$/i',$var);
		}

		public static function ex_text_label($var){
			$b = (bool)preg_match("/^[a-z0-9_\.\-]{1,50}(;[a-z0-9_\.\-]{1,50})*$/i",$var);
			if($b){
				global $g;
                $b = (bool)$g['db_db']->isset_text_label($var)[0]['cnt'];
                if(!$b){
                    return 'not_exists';
                }
			}
			return $b;
        }

		public static function ex_text_labels($var){
			$b = (bool)preg_match("/^[a-z0-9_\.\-]{1,50}(;[a-z0-9_\.\-]{1,50})*$/i",$var);
			if($b){
				global $g;
				$var = explode(';',$var);
				foreach($var as $v){
					$b = (bool)$g['db_db']->isset_text_label($v)[0]['cnt'];
					if(!$b){
						return 'not_exists';
					}
				}
			}
			return $b;
        }

		public static function one($var){
			return $var === '1';
        }

		public static function ex_lang_code($var){
            $b = (bool)preg_match("/^[a-z]{2}$/",$var);
			if($b){
				global $g;
				$b = (bool)$g['db_db']->isset_lang_code($var)[0]['cnt'];
				if(!$b){
					return 'not_exists';
				}
			}
			return $b;
        }

		public static function boolint($var){
			return (bool)preg_match('/^(0|1)$/i',$var);
		}

        public static function ga_kovetokod_o($var) {
            return (bool)preg_match('/^[0-9a-z\-]{0,15}$/i',$var);
        }

        public static function boolint_o($var){
            return strlen($var) === 0 || (bool)preg_match('/^(0|1)$/i',$var);
        }

		public static function lang_text($var){
			return true;
        }

        public static function int($var){
            return is_int($var) || ctype_digit($var);
        }

		public static function lang_texts($var){
			$is_array = is_array($var);
			if($is_array){
				foreach($var as $text){
					if(\GI\Functions::validate($text,'lang_text')!==true){
						return false;
					}
				}
			}
			return true;
        }

        public static function ex_rendszerparameter_id($var){
			global $g;
			if(!ctype_digit($var)){
				return false;
			}
			if(!$g['db_db']->isset_rendszerparameter_id($var)[0]['cnt']){
				return 'not_exists';
			}
			return true;
        }

        public static function ex_rendszerparameter_ertek_id($var){
			global $g;
			if(!ctype_digit($var)){
				return false;
			}
			if(!$g['db_db']->isset_rendszerparameter_ertek_id($var)[0]['cnt']){
				return 'not_exists';
			}
			return true;
        }

        public static function rendszerparameter_ertek($var){
			global $g;
			if(!preg_match('/.{0,500}/i',$var)){
				return false;
			}
			return true;
        }

		public static function email($var){
            return (bool)filter_var($var, FILTER_VALIDATE_EMAIL);
		}

        public static function email_o($var){
            return $var === '' || (bool)filter_var($var, FILTER_VALIDATE_EMAIL);
        }

        public static function uj_partner_email($var) {
            return mb_strlen($var) <= 100 && \GI\Functions::validate($var, 'email') && \GI\Functions::validate($var, 'nex-partnerek-email');
        }

        public static function partner_email($var) {
            return empty($var) || mb_strlen($var) <= 100 && \GI\Functions::validate($var, 'email');
        }

        public static function uj_telephely_email($var) {
            return mb_strlen($var) <= 100 && \GI\Functions::validate($var, 'email');
        }

        public static function telephely_email($var) {
            return empty($var) || mb_strlen($var) <= 100 && \GI\Functions::validate($var, 'email');
        }

        public static function uj_user_email($var) {
            return mb_strlen($var) <= 100 && \GI\Functions::validate($var, 'email') && \GI\Functions::validate($var, 'nex-users-email');
        }

        public static function adoszam($var) {
            return (bool)preg_match('/^[A-Z0-9\-]{1,15}$/', $var);
        }

        public static function adoszam_o($var) {
            return empty($var) || (bool)preg_match('/^[A-Z0-9\-]{1,15}$/', $var);
        }

        public static function iranyitoszam($var) {
            return (bool)preg_match('/^\d{1,11}$/', $var);
        }

        public static function url($var){
            return (bool)filter_var($var, FILTER_VALIDATE_URL);
        }

        public static function url_o($var){
            return strlen($var) === 0 || (bool)filter_var($var, FILTER_VALIDATE_URL);
        }

		public static function password($var){
            return (bool)preg_match('/^.{5,30}$/',$var);
        }

        public static function ok($var) {
			return true;
        }

        public static function nev($var) {
            return mb_strlen($var) <= 50 && mb_strlen($var) > 0;
        }

        public static function cegnev($var) {
            return mb_strlen($var) <= 100 && mb_strlen($var) > 0;
        }

        public static function mit_ker($var) {
            return mb_strlen($var) <= 20 && mb_strlen($var) > 0 && preg_match('/^[a-z0-9_]+$/', $var) === 1;
        }
        
        public static function ismerv_csoport_nev($var) {
            return mb_strlen($var) <= 100 && mb_strlen($var) > 0;
        }

        public static function ismerv_nev($var) {
            return mb_strlen($var) <= 100 && mb_strlen($var) > 0;
        }


        public static function beolvasas_nev($var) {
            return mb_strlen($var) <= 100 && mb_strlen($var) > 0;
        }

        public static function pic($var){
            return true;
        }

        public static function nyelvkod($var){
            return preg_match('/[a-z]{2}/', $var) === 1;
        }

        public static function encrypted_sn_beolvasas_sor($var){
            global $g;
            $d = (string)\GI\Functions::num_decrypt($var);
            if (!ctype_digit($d)) {
                return 'invalid_encrypted_num';
            }

            $b = (bool)$g['db_db']->isset_beolvasas_sor($d)[0]['cnt'];
            if(!$b){
                return 'not_exists';
            }
            return true;
        }

        public static function nyelv_megnevezes($var){
            return mb_strlen($var) >= 1 && mb_strlen($var) <= 20;
        }

        public static function irany($var){
            return in_array(strtolower($var), ['asc', 'desc']); //kesobb dinamizalni kene
        }

        public static function oszlop($var){
            return (bool)preg_match('/^[a-zA-Z_]+$/', $var);
        }

        public static function link_nev($var){
            return (bool)preg_match('/^[a-z0-9\-_ ]{1,30}$/i', $var);
        }

        public static function url_kod($var){
            return (bool)preg_match('/^[a-z0-9\-_]{1,100}$/', $var);
        }

        public static function parameter_nev($var){
            return (bool)preg_match('/^[a-z0-9\-_]{1,100}$/', $var);
        }

        public static function datum_o($var){
            return $var === '' || (bool)preg_match("/^[0-9]{4}\.(0[1-9]|1[0-2])\.(0[1-9]|[1-2][0-9]|3[0-1])$/",$var);
        }

        public static function oraperc($var){
            return (bool)preg_match("/^[0-9]{2}\:[0-9]{2}$/",$var);
        }

        public static function het_napjai($var){
            return (bool)preg_match("/^[1-7]+$/",$var);
        }

        public static function het_napja($var){
            return (bool)preg_match("/^[1-7]$/",$var);
        }

        public static function idopont($var){
            return (bool)preg_match("/^[0-9]{4}\.(0[1-9]|1[0-2])\.(0[1-9]|[1-2][0-9]|3[0-1])\s\d{2}\:\d{2}\:\d{2}$/",$var);
        }

        public static function idopont_o($var){
            return $var === '' || (bool)preg_match("/^[0-9]{4}\.(0[1-9]|1[0-2])\.(0[1-9]|[1-2][0-9]|3[0-1])\s\d{2}\:\d{2}\:\d{2}$/",$var);
        }

        public static function telefon_o($var){
            return mb_strlen($var) <= 20 && mb_strlen($var) >= 0;
        }

        public static function telefon($var){
            return mb_strlen($var) <= 20 && mb_strlen($var) > 0;
        }

        public static function confirm_code($var){
            return (bool)preg_match('/^[a-z0-9A-Z]{30}$/', $var);
        }

        public static function captcha($p_captcha){

            if($_SERVER['REMOTE_ADDR'] === '127.0.0.1'){
                return true;
            }

            if($p_captcha === ''){
                return false;
            }

            return true;

            $res = file_get_contents("https://www.google.com/recaptcha/api/siteverify?secret=".CAPTCHA_SECRET_KEY."&response=".$p_captcha);

            if($res===false){
                return false;
            }
            else{
                $response = json_decode(
                    $res,
                    true
                );
                if($response['success'] === false){
                    return false;
                }
                return true;
            }
        }

        public static function jogstruktura($var){
            $jogstruktura = json_decode($var);
            return \GI\Functions::json_validator($jogstruktura, 'jogstruktura.json');
        }

        public static function telephelystruktura($var){
            $telephelystruktura = json_decode($var);
            return \GI\Functions::json_validator($telephelystruktura, 'telephelystruktura.json');
        }

        public static function regio_nev($var){
            return (bool)preg_match('/^.{1,100}$/', $var);
        }

        public static function jogcsoport_nev($var){
            return (bool)preg_match('/^.{1,50}$/', $var);
        }

        public static function partner_nev($var){
            return (bool)preg_match('/^.{1,100}$/', $var);
        }

        public static function partner_telepules($var){
            return (bool)preg_match('/^.{1,40}$/', $var);
        }

        public static function partner_cim($var){
            return (bool)preg_match('/^.{1,100}$/', $var);
        }

        public static function telephely_nev($var){
            return (bool)preg_match('/^.{1,100}$/', $var);
        }

        public static function telephely_kapcs_neve($var){
            return (bool)preg_match('/^.{0,100}$/', $var);
        }

        public static function telephely_megjegyzes($var){
            return (bool)preg_match('/^.{0,1000}$/', $var);
        }

        public static function felhasznalo_megjegyzes($var){
            return (bool)preg_match('/^.{0,1000}$/', $var);
        }

        public static function telephely_telepules($var){
            return (bool)preg_match('/^.{1,40}$/', $var);
        }

        public static function telephely_cim($var){
            return (bool)preg_match('/^.{1,100}$/', $var);
        }

        public static function felhasznalo_nev($var){
            return (bool)preg_match('/^.{1,100}$/', $var);
        }

        public static function eszkoz_nev($var){
            return (bool)preg_match('/^.{1,100}$/', $var);
        }

        public static function eszkoz_azonosito($var){
            return (bool)preg_match('/^[1-9]\d{4}\-[1-9]\d{4}$/', $var);
        }

        public static function eszkoz_sorozatszam($var){
            return (bool)preg_match('/^.{1,40}$/', $var);
        }

        public static function eszkoz_mac_cim($var){
            return (bool)preg_match('/^.{1,50}$/', $var);
        }

        public static function eszkoz_felbontas($var){
            return (bool)preg_match('/^(\d+x\d+){1,10}$/', $var);
        }

        public static function eszkoz_dpi($var){
            return ctype_digit($var) && (int)$var <= 32000;
        }

        public static function eszkoz_api_verzio($var){
            return ctype_digit($var) && (int)$var <= 127;
        }

        public static function eszkoz_telepites_azonosito($var){
            return mb_strlen($var) <= 162;
        }

        public static function eszkoz_modell($var){
            return mb_strlen($var) <= 100;
        }

        public static function cloud_message_key($var){
            return true;
        }

        public static function valasz_ertek($var){
            return mb_strlen($var) <= 500;
        }

        public static function kerdoiv_id_arr($var){
            return self::id_arr_check($var, 'ex-kerdoivek-id');
        }

        public static function kerdes_id_arr($var){
            return self::id_arr_check($var, 'ex-kerdoivek_kerdesek-id');
        }

        public static function partner_id_arr($var){
            return self::id_arr_check($var, 'ex-partnerek-id');
        }

        public static function eszkoz_id_arr($var){
            return self::id_arr_check($var, 'ex-eszkozok-id');
        }

        public static function telephely_id_arr($var){
            return self::id_arr_check($var, 'ex-telephelyek-id');
        }

        public static function beolvasas_id_arr($var){
            return self::id_arr_check($var, 'ex-beolvasas-id');
        }

        private static function id_arr_check($var, $validator) {
            $var = json_decode($var, true);
            if (!is_array($var)) {
                return false;
            }
            foreach ($var as $id) {
                if (!is_int($id) && !is_string($id) || is_string($id) && !ctype_digit($id)) {
                    return false;
                }
                $id = (int)$id;
                if(\GI\Functions::validate($id,$validator)!==true){
                    return false;
                }
            }
            return true;
        }

        public static function helyszin_tipus($var) {
            return in_array($var, ['eszkoz', 'regio', 'telephely']);
        }

        public static function ido_tipus($var) {
            return in_array($var, ['nap_orai', 'het_napjai']);
        }

        public static function trend_tipus($var) {
            return in_array($var, ['het', 'honap', 'negyedev', 'ev']);
        }

        public static function ismerv_ertekek_arr($var) {
            $var = json_decode($var, true);
            if (!is_array($var)) {
                return false;
            }
            return true;
        }

        public static function ev($var) {
            return (bool)preg_match('/^2\d{3}$/', $var);
        }

        public static function filenev($var) {
            return (bool)preg_match('/^[a-z0-9._-]+$/', $var);
        }

        public static function testprod($var) {
            return (bool)preg_match('/^(test|prod)$/', $var);
        }

        public static function jog_nev($var){
            return (bool)preg_match('/^.{1,80}$/', $var);
        }

        public static function jog_leiras($var){
            return (bool)preg_match('/^.{1,300}$/', $var);
        }

        public static function email_sablon_nev($var){
            return mb_strlen($var) <= 100 && mb_strlen($var) > 0;
        }

        public static function email_sablon_targy($var){
            return mb_strlen($var) <= 100 && mb_strlen($var) > 0;
        }

        public static function email_sablon_alt_text($var){
            return mb_strlen($var) > 0;
        }

        public static function email_sablon_text($var){
            return mb_strlen($var) > 0;
        }

        public static function email_sablon_kep_tipus($var){
            return in_array($var, ['kep_logo', 'kep_alairas', 'kep_link']);
        }

        public static function datum_formatum($var){
            return in_array($var, ['YYYY.mm.dd', 'dd.mm.YYYY']);
        }
	}

