<?php

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

ini_set('memory_limit', '2G');

$spreadsheet = new Spreadsheet();

if (!isset($_POST['tablazat'])) {
    exit('no data');
}

$tablazat = json_decode($_POST['tablazat'], true);

$spreadsheet->getActiveSheet()
    ->fromArray(
        $tablazat,  // The data to set
        NULL,        // Array values with this value will not be set
        'A1'         // Top left coordinate of the worksheet range where
                     //    we want to set these values (default is A1)
    );

$writer = new Xlsx($spreadsheet);

header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="export.xlsx"');
header('Cache-Control: max-age=0');
$writer->save('php://output');

exit;