var telephelyek = null;
var eszkozok = null;

var PARTNER_TELEPHELYEK = objectToArray(valaszthato_partnerek_telephelyek_new);

$(document).ready(function() {
    orszagok_select = editSelectHtml(orszagok,(act_lang == 'hu' ? 'nev_magyar' : 'nev_angol'),'id');

    /*Új telephely létrehozó form*/
    var new_telephely = {
        inic_param: {
                id: 'telephelyek_new',
                dataRight: 'telephelyek_letrehozasa',
                title: '[[$t.uj_telephely]]',
                cols: 2,
                rows: 7,
                position: 'bottom'
            },
            buttons: [
                {
                    name:"[[$t.mentes]]",
                    id: 'btn_save_telephely',
                    type: 'save',
                    ajaxReload: true,
                    visibility: function() {return 1},
                    callback: function(valid) {
                        if(valid) {
                            ajax_call_telephelyek_new($('#btn_save_telephely'));
                        }
                    },
                    onCustomAjaxDone: function(event,result,trigger){
                        if(result.EREDMENY=='OK'){
                            clearForm('telephelyek_new');
                        }
                        else if(result.EREDMENY=='HI'){
                            gi_alert(result.UZENET);
                        }
                    },
                },
                {
                    name:"[[$t.vissza]]",
                    id: 'btn_cancel_telephely',
                    visibility: function() {return 1},
                    callback: function() {
                        clearForm('telephelyek_new');
                    },
                    addClasses: 'btn-alt',
                    type: 'cancel',
                    toggleId: 'telephelyek_new'
                }
            ],
            inputs: [
                {"col": 0, "row": 0, "colspan": 2, "input": inputHtml({
                                                    id: 'telephely_name_input',
                                                    label: '[[$t.nev]]',
                                                    placeholder: '[[$t.nev]]',
                                                    required: true,
                                                    name: 'telephely_name_input',
                                                    autofocus: false,
                                                    maxlength: 100
                                                })},
                {"col": 0, "row": 1, "colspan":2, "input": emailHtml({
                                                    id: 'telephely_email_input',
                                                    label: '[[$t.email]]',
                                                    placeholder:'[[$t.email]]',
                                                    name: 'email',
                                                    validateType: 'email',
                                                    autocomplete: 'off',
                                                    required: false,
                                                    autofocus: false,
                                                    maxlength: 100
                                                })},
                {"col": 0, "row": 2, "input": telefonHtml({
                                                    id: 'telephely_telefon_input',
                                                    label: '[[$t.telefon]]',
                                                    placeholder: '[[$t.telefon_pelda]]',
                                                    name: 'telephely_telefon_input',
                                                    autofocus: false,
                                                    validateType: 'telefon',
                                                    maxlength: 20
                                                })},
                {"col": 1, "row": 2, "input": filterSelectHtml({
                                                    id: 'telephely_partner_input',
                                                    placeholder: '[[$t.valassz]]',
                                                    name: 'kerdoiv_select_input',
                                                    label: '[[$t.partner]]',
                                                    maxOptions: '1',
                                                    addclass: 'form',
                                                    required: true
                                                },
                                                filterSelectValues(PARTNER_TELEPHELYEK, 'nev', 'id')
                                                /*selectValues(valaszthato_partnerek_telephelyek_new, {"key": "nev" , "value": "id"})*/
                                            )},
                {"col": 0, "row": 3, "input": inputHtml({
                                                id: 'telephely_iranyitoszam_input',
                                                label: '[[$t.iranyitoszam]]',
                                                placeholder: '[[$t.iranyitoszam_pelda]]',
                                                required: true,
                                                validateType: 'number',
                                                maxlength: 11,
                                                name: 'telephely_iranyitoszam_input',
                                                autofocus: false,
                                            })},
                {"col": 1, "row": 3, "input": inputHtml({
                                                id: 'telephely_szekhely_input',
                                                label: '[[$t.szekhely]]',
                                                placeholder: '[[$t.szekhely]]',
                                                required: true,
                                                name: 'telephely_szekhely_input',
                                                autofocus: false,
                                                maxlength: 40
                                            })},
                {"col": 0, "row": 4, "input": inputHtml({
                                                id: 'telephely_cim_input',
                                                label: '[[$t.cim]]',
                                                placeholder: '[[$t.cim]]',
                                                required: true,
                                                name: 'telephely_cim_input',
                                                autofocus: false,
                                                maxlength: 100
                })},
                {"col": 1, "row": 4, "input": filterSelectHtml({
                                                id: 'telephely_orszag_input',
                                                placeholder: '[[$t.valassz]]',
                                                name: 'telephely_orszag_input',
                                                label: '[[$t.orszag]]',
                                                maxOptions: '1',
                                                addclass: 'form',
                                                required: true
                                            },
                                            filterSelectValues(orszagok, (act_lang == 'hu' ? 'nev_magyar' : 'nev_angol'), 'id')
                                            /*selectValues(orszagok, {"key": "nev" , "value": "id"})*/
                                          )},
                {"col": 0, "row": 5, "colspan":2, "input": inputHtml({
                                            id: 'telephely_megjegyzes_input',
                                            label: '[[$t.megjegyzes]]',
                                            placeholder: '[[$t.megjegyzes]]',
                                            name: 'telephely_megjegyzes_input',
                                            autofocus: false,
                                            maxlength: 100
                })},   
                {"col": 0, "row": 6, "colspan":2, "input": inputHtml({
                                    id: 'telephely_kapcsolattarto_input',
                                    label: '[[$t.kapcsolattarto]]',
                                    placeholder: '[[$t.kapcsolattarto]]',
                                    name: 'telephely_kapcsolattarto_input',
                                    autofocus: false,
                                    maxlength: 100
                })},                          
            ],

    };

    eszkozok = dataTable($('#eszkozok'),{
        table:{
            hide: true,
            name:'[[$t.telephely_eszkozei]]',
            right:'telephelyek_eszkozeinek_megtekintese'
        },
        ajax:{
            name:'telephelyek_eszkozok_sel',
            data:{
                "telephely_sn": function() { return selectedRowId('#telephelyek'); },
                "echo": "1"
            },
            onInicCall:false
        },
        columns:[
            { headName:"", type:"details"},
            { headName:"[[$t.nev]]", colName:"nev"},
            { headName:"[[$t.eszkoz_azonosito]]", colName:"eszkoz_azonosito" },
            { headName:"[[$t.sorozatszam]]", colName:"sorozatszam" },
            { headName:"[[$t.mac_cim]]", colName:"mac_cim" },
            { headName:"[[$t.felbontas]]", colName:"felbontas" },
            { headName:"[[$t.dpi]]", colName:"dpi" },
            { headName:"[[$t.api_verzio]]", colName:"api_verzio" },
            { headName:"[[$t.telepites_azonosito]]", colName:"telepites_azonosito" },
            { headName:"[[$t.regisztracio_idopontja]]", colName:"regisztracio_idopontja", cellRender:function(td, cellData, rowData, row, col){
                $(td).html(formatDate(cellData));
            } },
            { headName:"[[$t.telephely_nev]]", colName:"telephely_nev" },
            { headName:"[[$t.letrehozas_datuma]]", colName:"creation_date", inDetails:true, isDateFormat: true },
            { headName:"[[$t.letrehozo_neve]]", colName:"creator_nev", inDetails:true },
            { headName:"[[$t.aktiv]]", colName:"aktiv", type:"checkbox", filterType:"checkbox" }
        ]

    });

    telephelyek = dataTable($('#telephelyek'),{
        table:{
            name:'[[$t.telephelyek]]',
            right:'telephelyek_megtekintese'
        },
        ajax:{
            name:'telephelyek_sel',
            data:{
                "echo": "1",
            },
            transform: function(data){
                if(act_lang != 'hu'){
                    for(var i in data){
                       data[i].orszag = findInArray(orszagok,'id',data[i].fk_orszag)['nev_angol'];
                    }
                }
                return data;
            }
        },
        functions:{
            edit:{
                ajax:"telephelyek_mod",
                right:"telephelyek_modositasa",
                data:{
                    '#name':'parameter_nev',
                    '#id':'telephely_sn',
                    '#data':'parameter_ertek',
                },
                text:{

                }
            }
        },
        columns:[
            { headName:"[[$t.nev]]", colName:"nev", canEdit:true },
            { headName:"[[$t.email]]", colName:"email", canEdit:true },
            { headName:"[[$t.telefon]]", colName:"telefon", canEdit:true },
            { headName:"[[$t.orszag]]", colName:"fk_orszag", renderCol:"orszag", filterType:"select-orszagok" ,type:'select', canEdit:true, editContent:function(){return orszagok_select;}, editName:'orszag_sn'},
            { headName:"[[$t.iranyitoszam]]", colName:"iranyitoszam", canEdit:true },
            { headName:"[[$t.telepules]]", colName:"telepules", canEdit:true },
            { headName:"[[$t.cim]]", colName:"cim", canEdit:true },
            { headName:"[[$t.megjegyzes]]", colName:"megjegyzes", canEdit:true },
            { headName:"[[$t.kapcsolattarto]]", colName:"kapcs_neve", canEdit:true },
            { headName:"[[$t.letrehozas_datuma]]", colName:"letrehozas_datuma", inDetails:true, isDateFormat: true },
            { headName:"[[$t.letrehozo]]", colName:"letrehozo", inDetails:true },
            { headName:"[[$t.partner_nev]]", colName:"partner_nev" }
        ],

        detailTables:[
            {table: eszkozok},
        ],

        buttons: [
            {
                name: "[[$t.uj_telephely]]",
                id: 'new_telephely_button',
                dataRight: 'telephelyek_letrehozasa',
                visibility: function() {return 1;},
                callback: function() {},
                type: "new",
                toggleId: 'telephelyek_new',
            },          
            {
                name: "[[$t.minta_xls]]",
                id: 'download_xls',
                dataRight: 'telephely_import',
                visibility: function() {return 1;},
                callback: function() {
                    window.open('/'+act_lang+'/telephelyek/download-excel',"_blank");
                },
            },           
            {
                name: "[[$t.beolvasas_xls_bol]]",
                id: 'upload_xls',
                dataRight: 'telephely_import',
                visibility: function() {return 1;},
                callback: function() {
                    popupUplodoad({
                        id: 'file',
                        ajax: 'ajax/telephelyek_import',
                        onUploadSuccess: function(id, data){                            
                            data = JSON.parse(data);
                            if(data[0] == "OK"){
                                var text = '';
                                for(var i in data[1]){
                                    if(data[1][i] == '0'){
                                        text += (i*1+2) +', ';
                                    }
                                }                                
                                if(text == ''){                                    
                                    gi_alert("[[$t.sikeres_feltoltes]]",function(){
                                        close_pop_up();
                                        close_pop_up();
                                    });
                                }else{
                                    text = text.substr(0,text.length - 2);
                                    gi_alert("[[$t.hibas_sorok]]"+'<br/>'+text,function(){
                                        close_pop_up();
                                        close_pop_up();
                                    });
                                }
                                telephelyek.ajax.reload();
                                
                            }else if(data[1] == "nincs_fajl"){
                                gi_alert("[[$t.nincs_fajl]]");
                            }else if(data[1] == "hibas_feltoltes"){
                                gi_alert("[[$t.hibas_feltoltes]]");
                            }else{
                                gi_alert("[[$t.hibas_feltoltes]]");
                            }
                        }
                     });
                },
            }
        ],

        forms : [new_telephely]

    });

});

function ajax_call_telephelyek_new(element){

    var data = {
        "nev": $('#telephely_name_input').val(),
        "email": $('#telephely_email_input').val(),
        "telefon": $('#telephely_telefon_input').val(),
        "partner_sn": $('#telephely_partner_input').val()[0],
        "orszag_sn": $('#telephely_orszag_input').val()[0],
        "iranyitoszam": $('#telephely_iranyitoszam_input').val(),
        "telepules": $('#telephely_szekhely_input').val(),
        "cim": $('#telephely_cim_input').val(),
        "megjegyzes": $('#telephely_megjegyzes_input').val(),
        "kapcs_neve": $('#telephely_kapcsolattarto_input').val()
    };

    var resultText = {};

    postApi('telephelyek_new',data,element,resultText);
}