<?php

use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;
use PhpOffice\PhpSpreadsheet\Cell\DataValidation;

if (isset($g['parameters'][0]) && $g['parameters'][0] === 'download-excel') {
    define('EMPTY_TELEPHELY_XLSX', GI_PATH_OTHER . 'empty_location.xlsx');
    $filePathParts = explode("/", EMPTY_TELEPHELY_XLSX);

    header('Content-Type: application/octet-stream');
    header("Content-Transfer-Encoding: Binary");
    header("Content-disposition: attachment; filename=\"" . $filePathParts[count($filePathParts) - 1] . "\"");

    $spreadsheet = IOFactory::load(EMPTY_TELEPHELY_XLSX);

    // add partnerek lista
    $partnerWorkSheet = $spreadsheet->getSheet(1);
    $partnerek = \UserFunctions::kezelheto_entitasok(
        $_SESSION['user']['id'],
        'partner',
        'partnerek_megtekintese',
        true
    );
    for ($i = 1; $i <= count($partnerek); $i++) {
        $partnerWorkSheet->getCell("A$i")->setValue($partnerek[$i-1]['nev']);
    }

    // add orszagok lista
    $orszagWorksheet = $spreadsheet->getSheet(2);
    $orszagok = $g['db_db']->orszagok_listaja_sel();
    for ($i = 1; $i <= count($orszagok); $i++) {
        $orszagWorksheet->getCell("A$i")->setValue($orszagok[$i-1]['nev_magyar']);
    }

    // add partner validation
    $validation = $spreadsheet->getSheet(0)->getCell('B2')->getDataValidation();
    $validation->setType(DataValidation::TYPE_LIST);
    $validation->setErrorStyle(DataValidation::STYLE_STOP);
    $validation->setAllowBlank(false);
    $validation->setShowInputMessage(true);
    $validation->setShowErrorMessage(true);
    $validation->setShowDropDown(true);
    $validation->setErrorTitle('Input error');
    $validation->setError('Value is not in list.');
    $validation->setFormula1('partners!$A$1:$A$' . count($partnerek));

    for ($i = 2; $i <= 300; $i++) {
        $spreadsheet->getSheet(0)->getCell("B$i")->setDataValidation(clone $validation);
    }

    // add orszag validation
    $validation = $spreadsheet->getSheet(0)->getCell('C2')->getDataValidation();
    $validation->setType(DataValidation::TYPE_LIST);
    $validation->setErrorStyle(DataValidation::STYLE_STOP);
    $validation->setAllowBlank(false);
    $validation->setShowInputMessage(true);
    $validation->setShowErrorMessage(true);
    $validation->setShowDropDown(true);
    $validation->setErrorTitle('Input error');
    $validation->setError('Value is not in list!');
    $validation->setFormula1('countries!$A$1:$A$' . count($orszagok));

    for ($i = 2; $i <= 300; $i++) {
        $spreadsheet->getSheet(0)->getCell("C$i")->setDataValidation(clone $validation);
    }

    // Maximum string hossz beallitas
    $length = [
        "A" => 100,
        "D" => 10,
        "E" => 40,
        "F" => 100,
        "G" => 100,
        "H" => 100,
        "I" => 20,
        "J" => 1000,
    ];

    foreach ($length as $k => $v) {
        $validation = $spreadsheet->getSheet(0)->getCell($k . '2')->getDataValidation();
        $validation->setType(DataValidation::TYPE_TEXTLENGTH);
        $validation->setErrorStyle(DataValidation::STYLE_STOP);
        $validation->setAllowBlank(false);
        $validation->setShowInputMessage(true);
        $validation->setShowErrorMessage(true);
        $validation->setErrorTitle('Input error');
        $validation->setError('Value is too long!');
        $validation->setFormula1(0);
        $validation->setFormula2((int)$v);

        for ($i = 2; $i <= 300; $i++) {
            $spreadsheet->getSheet(0)->getCell("$k$i")->setDataValidation(clone $validation);
        }
    }

    // Aktiv oszlop beallitasa
    $validation = $spreadsheet->getSheet(0)->getCell('K2')->getDataValidation();
    $validation->setType(DataValidation::TYPE_LIST);
    $validation->setErrorStyle(DataValidation::STYLE_STOP);
    $validation->setAllowBlank(false);
    $validation->setShowInputMessage(true);
    $validation->setShowErrorMessage(true);
    $validation->setErrorTitle('Input error');
    $validation->setError('Only 0 or 1!');
    $validation->setFormula1('"0,1"');

    for ($i = 2; $i <= 300; $i++) {
        $spreadsheet->getSheet(0)->getCell("K$i")->setDataValidation(clone $validation);
    }

    // Download
    $writer =  new Xlsx($spreadsheet);
    $writer->save('php://output');
    exit();
}

$orszagok = $g['db_db']->orszagok_listaja_sel();
$g['te']->add('orszagok', json_encode($orszagok));

$valaszthato_partnerek_telephelyeknel = \UserFunctions::kezelheto_entitasok(
    $_SESSION['user']['id'],
    'partner',
    'telephelyek_letrehozasa'
);
$g['te']->add('valaszthato_partnerek_telephelyek_new', json_encode($valaszthato_partnerek_telephelyeknel));
