var partnerek = null;

$(document).ready(function() {
    orszagok_select = editSelectHtml(orszagok,(act_lang == 'hu' ? 'nev_magyar' : 'nev_angol'),'id');
    var new_partner = {
        inic_param: {
                id: 'partnerek_new',
                dataRight: 'partnerek_letrehozasa',
                title: '[[$t.uj_partner]]',
                cols: 2,
                rows: 6,
                position: 'bottom'
            },
            buttons: [
                {
                    name:"[[$t.mentes]]",
                    id: 'btn_save_partner',
                    ajaxReload: true,
                    type: 'save',
                    visibility: function() {return 1},
                    callback: function(valid) {

                        if(valid) {
                            ajax_call_partnerek_new($('#btn_save_partner'));
                        }
                    },
                    onCustomAjaxDone: function(event,result,trigger){
                        if(result.EREDMENY=='OK'){
                            clearForm('partnerek_new');
                        }
                        else if(result.EREDMENY=='HI'){
                            gi_alert(result.UZENET);
                        }
                    },
                },
                {
                    name:"[[$t.vissza]]",
                    id: 'btn_cancel_partner',
                    visibility: function() {return 1},
                    callback: function() {
                        clearForm('partnerek_new');
                    },
                    addClasses: 'btn-alt',
                    type: 'cancel',
                    toggleId: 'partnerek_new'
                }
            ],
            inputs: [
                {"col": 0, "row": 0, "colspan": 2, "input": inputHtml({
                                                    id: 'partner_name_input',
                                                    label: '[[$t.nev]]',
                                                    placeholder: '[[$t.nev]]',
                                                    required: true,
                                                    name: 'partner_name_input',
                                                    autofocus: false,
                                                    maxlength: 100
                                                })},
                {"col": 0, "row": 1, "colspan":2, "input": emailHtml({
                                                    id: 'partner_email_input',
                                                    label: '[[$t.email]]',
                                                    placeholder:'[[$t.email]]',
                                                    ajaxparameter:'email',
                                                    name: 'email',
                                                    autocomplete: 'off',
                                                    autofocus: false,
                                                    maxlength: 100,
                                                    required: true,
                                                    validateType: 'email'
                                                })},
                {"col": 0, "row": 2, "input": telefonHtml({
                                                    id: 'partner_telefon_input',
                                                    label: '[[$t.telefon]]',
                                                    placeholder: '[[$t.telefon_pelda]]',
                                                    name: 'partner_telefon_input',
                                                    autofocus: false,
                                                    validateType: 'telefon',
                                                    maxlength: 20
                                                })},
                {"col": 1, "row": 2, "input": inputHtml({
                                                    id: 'partner_adoszam_input',
                                                    label: '[[$t.adoszam]]',
                                                    placeholder: '[[$t.adoszam_pelda]]',
                                                    name: 'partner_adoszam_input',
                                                    autofocus: false,
                                                    addclass: 'adoszam-input',

                                                    maxlength: 15
                                                })},
                {"col": 0, "row": 3, "input": filterSelectHtml({
                                                    id: 'partner_orszag_input',
                                                    placeholder: '[[$t.valassz]]',
                                                    label: '[[$t.orszag]]',
                                                    name: 'partner_orszag_input',
                                                    maxOptions: '1',
                                                    addclass: 'form',
                                                    required: true
                                                },
                                                filterSelectValues(orszagok, act_lang == 'hu' ? 'nev_magyar' : 'nev_angol', 'id')
                                                /*selectValues(orszagok, {"key": "nev" , "value": "id"})*/
                                              )},
                {"col": 0, "row": 4, "input": inputHtml({
                                                id: 'partner_iranyitoszam_input',
                                                label: '[[$t.iranyitoszam]]',
                                                placeholder: '[[$t.iranyitoszam_pelda]]',
                                                required: true,
                                                validateType: 'number',
                                                maxlength: 11,
                                                name: 'partner_iranyitoszam_input',
                                                autofocus: false,
                                                addclass: 'iranyitoszam-input'
                                            })},
                {"col": 1, "row": 3, "input": inputHtml({
                                                id: 'partner_szekhely_input',
                                                label: '[[$t.szekhely]]',
                                                placeholder: '[[$t.szekhely]]',
                                                required: true,
                                                name: 'partner_szekhely_input',
                                                autofocus: false,
                                                maxlength: 40
                                            })},
                {"col": 1, "row": 4, "input": inputHtml({
                                                id: 'partner_cim_input',
                                                label: '[[$t.cim]]',
                                                placeholder: '[[$t.cim]]',
                                                required: true,
                                                name: 'partner_cim_input',
                                                autofocus: false,
                                                maxlength: 100
                                            })},
                { "col": 0, "row": 5, "input": emailHtml({
                                                    id: 'partner_kikuld_email',
                                                    label: '[[$t.kikuldo_email_cim]]',
                                                    placeholder:'[[$t.kikuldo_email_cim]]',
                                                    name: 'partner_kikuld_email',
                                                    autocomplete: 'off',
                                                    autofocus: false,
                                                    maxlength: 100,
                                                    required: true,
                                                    validateType: 'email'
                                                })
                },
                { "col": 1, "row": 5, "input": inputHtml({
                                                id: 'partner_kikuld_nev',
                                                label: '[[$t.kikuldo_nev]]',
                                                placeholder: '[[$t.kikuldo_nev]]',
                                                required: true,
                                                name: 'partner_kikuld_nev',
                                                autofocus: false,
                                                maxlength: 100
                                            })},
            ],

    };

    partnerek = dataTable($('#partnerek'),{
        table:{
            name:'[[$t.partnerek]]',
            right:'partnerek_megtekintese'
        },
        ajax:{
            name:'partnerek_sel',
            data:{
                "echo": "1",
                "inaktivakat_is": "1"
            },
            transform: function(data){
                if(act_lang != 'hu'){
                    for(var i in data){
                       data[i].szekhely_orszag = findInArray(orszagok,'id',data[i].fk_szekhely_orszag)['nev_angol'];
                    }
                }
                return data;
            }
        },
        functions:{
            edit:{
                ajax:"partnerek_mod",
                right:"partnerek_modositasa",
                data:{
                    '#name':'parameter_nev',
                    '#id':'partner_sn', 
                    '#data':'parameter_ertek', 
                },
                text:{}
            },
            activate:{
                ajax:"partnerek_akt",
                right:"partnerek_aktivalasa",
                data:{
                    '#id':'partner_sn',
                    'aktiv': "1"
				},
                dataCol: 'aktiv',
                icon: 'fa-undo-alt',
            },
            inactivate:{
                ajax:"partnerek_akt",
                right:"partnerek_aktivalasa",
                data:{
                    '#id':'partner_sn',
                    'aktiv': "0"
                },
				dataCol: 'aktiv',
			},
        },
        columns:[
            { headName:"[[$t.nev]]", colName:"nev", canEdit:true },
            { headName:"[[$t.adoszam]]", colName:"adoszam", canEdit:true },
            { headName:"[[$t.email]]", colName:"email", canEdit:true },
            { headName:"[[$t.telefon]]", colName:"telefon", canEdit:true },
            { headName:"[[$t.kikuldo_email_cim]]", colName:"email_kuldo_email_cime", canEdit:true },
            { headName:"[[$t.kikuldo_nev]]", colName:"email_kuldo_neve", canEdit:true },
            { headName:"[[$t.szekhely_orszag]]", colName:"fk_szekhely_orszag",renderCol:"szekhely_orszag", filterType:"select-orszagok" ,type:'select', canEdit:true, editContent:function(){return orszagok_select;}, editName:'szekhely_orszag_sn'},
            { headName:"[[$t.szekhely_iranyitoszam]]", colName:"szekhely_iranyitoszam", canEdit:true },
            { headName:"[[$t.szekhely_telepules]]", colName:"szekhely_telepules", canEdit:true },
            { headName:"[[$t.szekhely_cim]]", colName:"szekhely_cim", canEdit:true },
            { headName:"[[$t.letrehozas_datuma]]", colName:"letrehozas_datuma",cellRender:function(td, cellData, rowData, row, col){
                $(td).html(formatDate(cellData));
            } },
            { headName:"[[$t.letrehozo_neve]]", colName:"letrehozo_neve" },
            { headName:"[[$t.aktiv]]", colName:"aktiv", type:"checkbox", filterType:"checkbox" },
        ],
        detailTables:[

        ],
        forms: [new_partner],
        buttons: [
            {
                name: "[[$t.uj_partner]]",
                id: 'new_partner_button',
                dataRight: 'partnerek_letrehozasa',
                visibility: function() {return 1;},
                callback: function() {
                },
                type: "new",
                toggleId: 'partnerek_new',
            }
        ]
    });

    $('#partner_kikuld_email').val('survey@ceedback.eu');
    $('#partner_kikuld_nev').val('Ceedback');

});

function ajax_call_partnerek_new(element){

    var data = {
        "nev": $('#partner_name_input').val(),
        "email": $('#partner_email_input').val(),
        "telefon": $('#partner_telefon_input').val(),
        "adoszam": $('#partner_adoszam_input').val(),
        "szekhely_orszag_sn": $('#partner_orszag_input').val()[0],
        "szekhely_iranyitoszam": $('#partner_iranyitoszam_input').val(),
        "szekhely_telepules": $('#partner_szekhely_input').val(),
        "szekhely_cim": $('#partner_cim_input').val(),
        "email_kuldo_email_cime": $('#partner_kikuld_email').val(),
        "email_kuldo_neve": $('#partner_kikuld_nev').val()
    };

    var resultText = {};

    postApi('partnerek_new',data,element,resultText);
}