const PARTNEREK = objectToArray(szurheto_adatok.partnerek);
var ismerv_csoportok = null;
var ismervek = null;

new_ismerv_csoport = {
    inic_param: {
            id: 'ismerv_csoport_new',
            dataRight: 'tomeges_kikuldes',
            title: '[[$t.uj_ismerv_csoport]]',
            cols: 1,
            rows: 1,
            position: 'bottom'
        },
        buttons: [
            {
                name:"[[$t.mentes]]",
                id: 'btn_save_ismerv_csoport',
                ajaxReload: true,
                type: 'save',
                visibility: function() {return 1},
                callback: function(valid) {
                    if(valid) {
                        ajax_call_ismerv_csoportok_new($('#btn_save_ismerv_csoport'));
                    }
                },
                onCustomAjaxDone: function(event,result,trigger){
                    if(result.EREDMENY=='OK'){
                        clearForm('ismerv_csoport_new');
                    }
                    else if(result.EREDMENY=='HI'){
                        gi_alert(result.UZENET);
                    }
                },
            },
            {
                name:"[[$t.vissza]]",
                id: 'btn_cancel_ismerv_csoport',
                visibility: function() {return 1},
                callback: function() {
                    clearForm('ismerv_csoport_new');
                },
                addClasses: 'btn-alt',
                type: 'cancel',
                toggleId: 'ismerv_csoport_new'
            }
        ],
        inputs: [
            {"col": 0, "row": 0, "input": inputHtml({
                                                id: 'ismer_csoport_nev',
                                                label: '[[$t.ismerv_csoport_nev]]',
                                                placeholder: '[[$t.ismerv_csoport_nev]]',
                                                required: true,
                                                name: 'ismer_csoport_nev',
                                                autofocus: false,
                                                maxlength: 100
                                            })},
            
        ],

};

new_ismerv = {
    inic_param: {
            id: 'ismerv_new',
            dataRight: 'tomeges_kikuldes',
            title: '[[$t.uj_ismerv]]',
            cols: 1,
            rows: 2,
            position: 'bottom'
        },
        buttons: [
            {
                name:"[[$t.mentes]]",
                id: 'btn_save_ismerv',
                ajaxReload: true,
                type: 'save',
                visibility: function() {return 1},
                callback: function(valid) {
                    if(selectedRowData('#ismerv_csoportok').kikuldve) {
                        gi_alert('[[$t.ismerv_mar_kikuldve]]');
                    }
                    else if(valid) {
                        ajax_call_ismervek_new($('#btn_save_ismerv'));
                    }
                },
                onCustomAjaxDone: function(event,result,trigger){
                    if(result.EREDMENY=='OK'){
                        clearForm('ismerv_new');
                    }
                    else if(result.EREDMENY=='HI'){
                        gi_alert(result.UZENET);
                    }
                },
            },
            {
                name:"[[$t.vissza]]",
                id: 'btn_cancel_ismerv',
                visibility: function() {return 1},
                callback: function() {
                    clearForm('ismerv_new');
                },
                addClasses: 'btn-alt',
                type: 'cancel',
                toggleId: 'ismerv_new'
            }
        ],
        inputs: [
            {"col": 0, "row": 0, "input": inputHtml({
                                                id: 'ismerv_nev',
                                                label: '[[$t.ismerv_nev]]',
                                                placeholder: '[[$t.ismerv_nev]]',
                                                required: true,
                                                name: 'ismerv_nev',
                                                autofocus: false,
                                                maxlength: 100
                                            })},
                                            ,
        {"col": 0, "row": 1, "input": checkboxHtml({
                                                id: 'ismerv_mutat',
                                                label: 'Az ismérv látszódni fog a kiküldéskor',
                                                name: 'ismerv_checkbox',
                                                checked: false
                                            })}
            
            
        ],

};

$(document).ready(function(){

    var select = filterSelectHtml({
            id: 'partner_select_input',
            placeholder: '[[$t.partner]]',
            name: 'partner_select_input',
            maxOptions: 1,
            addclass: 'form'
        }, 
        filterSelectValues(PARTNEREK, 'nev', 'id')
        );
    
    $('#partner_valaszto_input').html(select);
    $('#partner_select_input').selectpicker();

    if(PARTNEREK.length > 0) {
        for(var i in PARTNEREK) {
            if(isDefined(PARTNEREK[i])) {
                defaultPartnerId = PARTNEREK[i].id;
                break;
            }
        }
        $('#partner_select_input').selectpicker('val', defaultPartnerId);

    }

    if(PARTNEREK.length > 0) {
        inic();
    }

    /*Ha csak egy partner van, nem kell megmutatni a selectet*/
    if(PARTNEREK.filter(function(value) { return value !== undefined }).length == 1) {
        $('#partner_valaszto_input, .info').addClass('d-none');
    }
    

    $('.selectpicker').on('change', function() {
        if(!isDefined($('#partner_select_input').val()[0]) || $('#partner_select_input').val()[0] == '') {
            $('#partner_select_input').selectpicker('val', defaultPartnerId);
        } else {
            inic();
        }
        
    });

    ismervek = dataTable($('#ismervek'),{
        table:{
            name:'[[$t.ismervek]]',
            right:'tomeges_kikuldes',
            hide:true,
        },
        ajax:{
            name:'ismervek_sel',
            data:{
                "echo": "1",
                "ismerv_csoport_id": function() { return selectedRowId('#ismerv_csoportok'); }
            },
            onInicCall:false
        },
        functions:{
            edit:{
                ajax:"ismervek_mod",
                right:"partnerek_modositasa",
                data:{
                    '#id':'ismerv_id', 
                    '#data':'nev',
                },
                errorTxt:{
                    'mar_hasznalt': '[[$t.ismerv_mar_kikuldve]]'
                }
            },
            delete:{
                ajax:"ismervek_del",
                right:"tomeges_kikuldes",
                data:{
                    '#id':'ismerv_id',
                },
                errorTxt:{
                    'mar_hasznalt': '[[$t.ismerv_mar_kikuldve]]'
                }
            }
        },
        columns:[
            { headName:"[[$t.nev]]", colName:"nev", canEdit:true },
            { headName:"[[$t.mutat]]", colName:"ismerv_mutat", type:"checkbox", filterType:"checkbox"}
        ],
        detailTables:[

        ],
        forms: [new_ismerv],
        buttons: [
            {
                name: "[[$t.uj_ismerv]]",
                id: 'new_ismerv_button',
                dataRight: 'tomeges_kikuldes',
                visibility: function() {return 1},
                callback: function() {
                },
                type: "new",
                toggleId: 'ismerv_new',
            }
        ],
        
    });

    ismerv_csoportok = dataTable($('#ismerv_csoportok'),{
        table:{
            name:'[[$t.ismerv_csoportok]]',
            right:'tomeges_kikuldes',
            addClass:"mt-4"
        },
        ajax:{
            name:'ismerv_csoportok_sel',
            data:{
                "echo": "1",
                "partner_id": function () { return $('#partner_select_input').val()[0]; }
            },
            transform: function(data) {
                for(var i in data) {
                    data[i]["kikuldve"] = data[i]['kikuldve_darab'] > 0;
                }

                return data;
            }
        },
        functions:{
            edit:{
                ajax:"ismerv_csoportok_mod",
                right:"tomeges_kikuldes",
                data:{
                    '#id':'ismerv_csoport_id', 
                    '#data':'nev',
                },
                errorTxt:{
                    'mar_hasznalt': '[[$t.ismerv_mar_kikuldve]]'
                }
            },
            delete:{
                ajax:"ismerv_csoportok_del",
                right:"tomeges_kikuldes",
                data:{
                    '#id':'ismerv_csoport_id',
                },
                errorTxt:{
                    'mar_hasznalt': '[[$t.ismerv_mar_kikuldve]]'
                }
            }
        },
        columns:[
            { headName:"[[$t.nev]]", colName:"nev", canEdit:true },
            { headName:"[[$t.kikuldve]]", colName:"kikuldve", type:"checkbox", filterType:"checkbox"},
        ],
        detailTables:[
            {table: ismervek},
        ],
        forms: [new_ismerv_csoport],
        buttons: [
            {
                name: "[[$t.uj_ismerv_csoport]]",
                id: 'new_ismerv_csoport_button',
                dataRight: 'tomeges_kikuldes',
                visibility: function() {return 1;},
                callback: function() {
                },
                type: "new",
                toggleId: 'ismerv_csoport_new',
            }
        ]
    });

    
});


function inic() {
    if(ismerv_csoportok != null) {
        ismerv_csoportok.table().rows('.selected').deselect();
        ismerv_csoportok.ajax.reload();
        
    }
    
}

function ajax_call_ismerv_csoportok_new(elem) {
    var data = {
        "partner_id": $('#partner_select_input').val()[0],
        "nev": $('#ismer_csoport_nev').val()
    };

    var resultText = {
    };

    postApi('ismerv_csoportok_new',data,elem,resultText,null,function(result){
        if(result.EREDMENY == 'OK'){
            ismerv_csoportok.ajax.reload();
        }
    });
}

function ajax_call_ismervek_new(elem) {
    var data = {
        "ismerv_csoport_id": selectedRowId('#ismerv_csoportok'),
        "nev": $('#ismerv_nev').val(),
        "ismerv_mutat":$('#ismerv_mutat').prop('checked')
    };

    var resultText = {
    };

    postApi('ismervek_new',data,elem,resultText,null,function(result){
        if(result.EREDMENY == 'OK'){
            ismervek.ajax.reload();
        }
    });
}