var kerdoivek = null;
var struct;
var sorrend = [];

var kitoltes = {};

$(document).ready(function() {
    $('#cf-web-view-wrapper').removeClass('d-none');

    /*Amint betölt az oldal meghívjuk az ajaxot*/
    var data = {
        "kerdoiv_sn": "1"
    };

    var resultText = {};
    
    postApi('kerdoiv_json_sel',data,null,resultText,null,function(result){
		struct = result;
        initQuery(act_lang);
	});

    /*Input lekezelése*/
    $(document).on('keyup', '.cf-view-input', function() {
        var tobb_min = $('.cf-next-button').data('tobb-min'); 
        var tobb_max = $('.cf-next-button').data('tobb-min'); 
        var tobb = $('.cf-next-button').data('tobb');

        var color = struct['szinek'].find(x => x.objektum_nev == 'gomb_szoveg').szinkod;
        var bg_color = '#' + struct['szinek'].find(x => x.objektum_nev == 'gomb_hatter').szinkod;
        var selected_background = LightenDarkenColor(bg_color, 30);

        /*Több válasz esetén*/
        if (isDefined(tobb_min) || isDefined(tobb_max)) {
            /*Most vitte be az első karaktert*/
            if($(this).val().length > 0) {
                if(!$(this).hasClass('active')) {
                    if(tobb > tobb_max) {
                        /*$('.cf-view-numcell, .cf-view-cell, .cf-view-cell-2').removeClass('active');*/
                        activateInput('.cf-view-numcell, .cf-view-cell, .cf-view-cell-2', 0, selected_background, bg_color);
                        $('.cf-next-button').data('tobb', 1);
                    } else {
                         $('.cf-next-button').data('tobb', tobb+1);
                    }
                    activateInput(this, 1, selected_background, bg_color);
                }
            }
            /*Üres input mező*/
            else {
                activateInput(this, 0, selected_background, bg_color);
                $('.cf-next-button').data('tobb', tobb-1);
            }

            if($('.cf-next-button').data('tobb') >= tobb_min) {
                toggleNextButton(1);
            } else {
                toggleNextButton(0);
            }
        }

        else {
            activateInput('.cf-view-numcell, .cf-view-cell, .cf-view-cell-2', 0, selected_background, bg_color);
        
            if($(this).val().length > 0) {
                activateInput(this, 1, selected_background, bg_color);

                $('.cf-next-button').data('valasz-ertek', 'egyeb');
                toggleNextButton(1);
            }
            else {
                activateInput(this, 0, selected_background, bg_color);
                $('.cf-next-button').data('valasz-ertek', null);
                toggleNextButton(0);
            }
        }
    });

    /*Nyelvválasztó*/
    $(document).on('click', '.cf-view-lang img', function() {
        var sorrend = $('.cf-next-button').data('kovetkezo-sorrend') - 1;
        hideViewFormWindow();
        $('.cf-view-lang img').removeClass('active');
        var lang = $(this).data('lang');

        if(sorrend == 0) {
            initQuery(lang);
        } else {
            showViewFormWindow();
            stepQuery(sorrend,  lang);
            
        }
        $('.cf-next-button').data('lang', lang);
    });
});


/*Kérdőív inicializálása*/
function initQuery(nyelv) {

    var sorrend = [];
    sorrend.push({tipus: 'kezdooldal', sorrend: 0});
    var sorrendOffset = 1;/*Ennyivel toljuk el a kérdések relatív sorrendjét, ha vannak rendszerszintű kérdések*/


    if(isDefined(struct['nyelvek'][nyelv]['rendszerszintu_kerdesek'])) {
        for(var i in struct['nyelvek'][nyelv]['rendszerszintu_kerdesek']) {
            var s = parseInt(struct['nyelvek'][nyelv]['rendszerszintu_kerdesek'][i].sorrend);
            sorrend[s] = {tipus: 'rendszerszintu_kerdesek', id: struct['nyelvek'][nyelv]['rendszerszintu_kerdesek'][i].id, sorrend: s}
        }
        sorrendOffset++;
    }

    if(isDefined(struct['nyelvek'][nyelv]['kerdesek'])) {
        for(var i in struct['nyelvek'][nyelv]['kerdesek']) {
            var s = parseInt(struct['nyelvek'][nyelv]['kerdesek'][i].sorrend) + sorrendOffset;
            sorrend[s] = {tipus: 'kerdesek', id: struct['nyelvek'][nyelv]['kerdesek'][i].id, sorrend: s};
        }
    }


    var s = parseInt(struct['nyelvek'][nyelv]['kerdesek'][i].sorrend) + sorrendOffset + 1;
    sorrend.push({tipus: 'zarooldal', sorrend: s});

    /*Sorrend megrodítása a kirajzolásért*/
    var forditottSorrend = sorrend;
    forditottSorrend.reverse();

    /*Oldalak beszúrása*/
    for(var i in forditottSorrend) {
        getNewPage(forditottSorrend[i], nyelv);
    }

    applyStyle();
    applyEventHandlers();

}

/*Új oldal generálása*/
function getNewPage(kerdes, nyelv) {
    var nyelvValaszto = '<div class="cf-view-lang">' + createLangSelectors(nyelv) + '</div>';
    var color = struct['szinek'].find(x => x.objektum_nev == 'gomb_szoveg').szinkod;
    var tovabbGombSzoveg = '<i class="fas fa-angle-right"></i>';
    var tovabbGomb = '<button class="btn cf-next-button disabled d-none" disabled>'+tovabbGombSzoveg+'</button>';

    var oldal = '';
    var pageId = 'page-';

    /*Kezdőoldal*/
    if(kerdes.tipus == 'kezdooldal') {
        pageId = pageId + 0;
        var erintoKepernyo = '<div class="cf-tap-screen"></div>';
        var cim = '<p class="cf-cover-title">' + struct['nyelvek'][nyelv]['szovegek'].kezdo_oldal + '</p>';
        var alcim = '<p class="cf-cover-subtitle">' +struct['nyelvek'][nyelv]['szovegek'].kezdo_oldal_kieg + '</p>';
        var fejlecWrapper = '<div class="cf-cover-wrapper">' + cim + alcim + '</div>';

        oldal = '<div id="'+pageId+'" class="view-form-page cover-page active-page">' +erintoKepernyo + fejlecWrapper + tovabbGomb + nyelvValaszto+'</div>';
        $('#cf-web-view-wrapper').append(oldal);

    }
    else if(kerdes.tipus == 'rendszerszintu_kerdesek' || kerdes.tipus == 'kerdesek') {
        var aktualis_id = kerdes.id;
        var aktualis_tipus = kerdes.tipus;
        var aktualis_kerdes = struct['nyelvek'][nyelv][aktualis_tipus].find(x => x.id == aktualis_id);
        pageId = pageId + kerdes.sorrend;

        /*Kérdés kiolvasása*/
        var str = 'valasz_tipus_'+aktualis_kerdes.valasz_tipus_id+'_kieg';
        var subtitle = isDefined(struct['nyelvek'][nyelv]['szovegek'][str]) ? struct['nyelvek'][nyelv]['szovegek'][str] : '' ;

        var kerdes_txt;

        /*Rendszerszintű kérdés*/
        if(aktualis_tipus == "rendszerszintu_kerdesek" && (isDefined(aktualis_kerdes.eredeti_kerdes_szoveg) || isDefined(aktualis_kerdes.felulirt_kerdes_szoveg))) {
            kerdes_txt = '<div class="cf-question-header"><p>'+ (isDefined(aktualis_kerdes.felulirt_kerdes_szoveg) ? aktualis_kerdes.felulirt_kerdes_szoveg : aktualis_kerdes.eredeti_kerdes_szoveg)+ '<br><span class="cf-subtitle">' + subtitle +  '</span></p></br></div>';
        } 
        /*Felhasználó definiált kérdés*/
        else {
            kerdes_txt = '<div class="cf-question-header"><p>' + aktualis_kerdes.kerdes_szoveg + '<br><span class="cf-subtitle">' + subtitle +  '</span></p></div>';
        }

        /*Tovább gomb megjelenítése*/
        var next_btn_txt = '<i class="fas fa-angle-right"></i>';
        var next_button = '<button class="btn cf-next-button disabled d-none" disabled>'+next_btn_txt+'</button>';
        /*Nyelvek*/
        var lang_selector = '<div class="cf-view-lang">' + createLangSelectors(nyelv) + '</div>';

        /*lehetséges válaszok generálása*/
        var valasz = generateAnswerChoices(aktualis_kerdes, nyelv);

        oldal = '<div id="'+pageId+'" class="view-form-page question-page">' +kerdes_txt +  '<div class="cf-view-content-wrapper">' + valasz + next_button + lang_selector+ '</div>'+'</div>';
        $('#cf-web-view-wrapper').append(oldal);

        /*A szabad szöveges válasz nem kötelező*/
        if(aktualis_kerdes.valasz_tipus_kod == 'szabad_szoveg') {
            toggleNextButton(1);
        }

        /*Ha több választ is meg lehet adni*/
        var tobb_min = aktualis_kerdes.kerdes_extrak.find(x => x.adat_kod == 'tobb_min');
        var tobb_max = aktualis_kerdes.kerdes_extrak.find(x => x.adat_kod == 'tobb_max');

        if(isDefined(tobb_min)) {
            if(!isDefined(tobb_max)) { tobb_max = tobb_min; }
            $('#'+pageId).data('tobb-min', tobb_min.adat_content);
            $('#'+pageId).data('tobb-max', tobb_max.adat_content);
            $('#'+pageId).data('tobb', 0);
        }
        /*$('#'+pageId).data('kovetkezo-sorrend', ++sorszam);*/
        $('#'+pageId).data('lang', nyelv);

    }
    else if (kerdes.tipus == 'zarooldal') {
        var title = '<div class="text-center cf-back-wrapper "><p class="cf-back-title cf-view-content">' + struct['nyelvek'][nyelv]['szovegek']['utolso_oldal'] + '</div></div>';
        pageId = pageId + kerdes.sorrend;
        oldal = '<div id="'+pageId+'" class="view-form-page back-page">' + title +'</div>';
        $('#cf-web-view-wrapper').append(oldal);
    }

}

/*Kérdőív léptetése*/
function stepQuery(sorszam, nyelv) {


   
}

/*Léptetés animáció*/
function stepAnimation(sorrend, nyelv) {

    var aktivOldal = $('.active-page');
    var aktivOldalId = aktivOldal[0].id;

    toggleElem('.cf-view-action',1);
    animateCSS('#'+aktivOldalId, 'slideOutLeft', function() {  
        stepQuery(sorrend, nyelv);  
        $('#'+aktivOldalId).addClass('d-none');
        $('#'+aktivOldalId).removeClass('active-page');
        $('#'+aktivOldalId).prev('.view-form-page:first').addClass('active-page');
        toggleElem('.cf-view-action',0);
    });

}

    
function showViewFormWindow() {
    $('#view-form-wrapper').removeClass('d-none');
}

function hideViewFormWindow() {
    $('#view-form-wrapper').addClass('d-none');
    toggleElem('#kerdoiv_megtekintese_button',0);
}

function applyEventHandlers() {
    $('.cf-view-numcell, .cf-view-cell, .cf-view-cell-2, .cf-view-smiley, .cf-tap-screen, .cf-cover-wrapper').on('click', function() {

        var aktivOldal = $('.active-page');
        var aktivoldalId = aktivOldal[0].id;

        
        /*A kijelölt gombok és inputok háttere világosabbá válik*/
        var bg_color = '#' + struct['szinek'].find(x => x.objektum_nev == 'gomb_hatter').szinkod;
        var selected_background = LightenDarkenColor(bg_color, 30);

        var tobb_min = $('#'+aktivoldalId).data('tobb-min'); 
        var tobb_max = $('#'+aktivoldalId).data('tobb-min'); 
        var tobb = $('#'+aktivoldalId).data('tobb');

        /*Több válasz esetén*/
        if (isDefined(tobb_min) || isDefined(tobb_max)) {
            if($(this).hasClass('active')) {
                activateInput(this, 0, selected_background, bg_color);
                $('#'+aktivoldalId).data('tobb', tobb-1);
            } else {
                if(tobb > tobb_max) {
                    /*Többi deaktiválás*/
                    activateInput('.cf-view-numcell, .cf-view-cell, .cf-view-cell-2, .cf-view-smiley', 0, selected_background, bg_color);
                    activateInput('.cf-view-input', 0, selected_background, bg_color);
                    $('.cf-view-input').val('');

                    /*Aktiválás*/
                    activateInput(this, 1,  selected_background, bg_color);
                    $(this).css('background-color', selected_background);
                    $('#'+aktivoldalId).data('tobb', 1);
                } else {
                    activateInput(this, 1, selected_background, bg_color);
                    $(this).css('background-color', selected_background);
                    $('#'+aktivoldalId).data('tobb', tobb+1);
                }
                
            }

            if($('#'+aktivoldalId).data('tobb') >= tobb_min) {
                toggleNextButton(1);
            } else {
                toggleNextButton(0);
            }
        }
         
        /*Egy lehetséges válasz esetén*/
        else {
            activateInput('.cf-view-numcell, .cf-view-cell, .cf-view-cell-2', 0, selected_background, bg_color);
            activateInput('.cf-view-input', 0, selected_background, bg_color);
            $('.cf-view-input').val('');

            /*Ugrás*/
            if(isDefined($(this).data('ugras'))) {
                $('#'+aktivoldalId).data('ugras', $(this).data('ugras'));
            }
    
            activateInput(this, 1, selected_background, bg_color);
            $('#'+aktivoldalId).data('valasz-ertek', $(this).data('value'));
            $('#'+aktivoldalId).removeClass('disabled');
            $('#'+aktivoldalId).prop('disabled', false);
  
            if($(this).hasClass('cf-view-cell-2')) {
                $('#'+aktivoldalId).removeClass('d-none');
            } else {
                $('.cf-next-button').click();
            }
        }
    });

/*Kérdőíveknél következő oldalra lépés*/
   $('.cf-next-button').on('click', function() {

    var aktivOldal = $('.active-page');
    var aktivoldalId = aktivOldal[0].id;


     var kovetkezo = isDefined($('#'+aktivoldalId).data('ugras')) ? $('#'+aktivoldalId).data('ugras') : null;
     var tobb_min = $('#'+aktivoldalId).data('tobb-min'); 
     var tobb_max = $('#'+aktivoldalId).data('tobb-max'); 
     
     if(isDefined(tobb_min) || isDefined(tobb_max)) {
         if($('#'+aktivoldalId).data('tobb') >= tobb_min &&  $('#'+aktivoldalId).data('tobb') <= tobb_max) {
             stepAnimation(kovetkezo,  $('#'+aktivoldalId).data('lang'));
         }    
     } else {
         stepAnimation(kovetkezo,  $('#'+aktivoldalId).data('lang'));
     }
     
 });
}
    


function generateAnswerChoices(kerdes, nyelv) {

    switch(kerdes.valasz_tipus_kod) {
        case 'szamok10': case 'szamok110':
            var min = 0;
            var max = 10;
            if(isDefined(kerdes.valasz_tipus_extrak)) {
                min = isDefined(kerdes.valasz_tipus_extrak.find(x => x.adat_kod=='min').adat_content) ? kerdes.valasz_tipus_extrak.find(x => x.adat_kod=='min').adat_content : min ;
                max = isDefined(kerdes.valasz_tipus_extrak.find(x => x.adat_kod=='max').adat_content) ? kerdes.valasz_tipus_extrak.find(x => x.adat_kod=='max').adat_content : max;
            } 
            return generateScaleChoices(min, max);

        case 'egyedi_valaszok':
            var valaszok = [];
            var egyebSorszam = -1;
            var ugrasok = [];
            for (var i in kerdes.kerdes_extrak) {
                /*van egyéb opció*/
                if(kerdes.kerdes_extrak[i].adat_kod.slice(-5) == 'ugrik') {
                    var ind = kerdes.kerdes_extrak[i].adat_kod.replace('valasz','').replace('_ugrik','');
                    ugrasok[ind] = kerdes.kerdes_extrak[i].adat_content;
                }
                else if(kerdes.kerdes_extrak[i].adat_kod.slice(-5) == 'egyeb')  {
                    egyebSorszam = kerdes.kerdes_extrak[i].adat_kod.replace('valasz','').replace('_egyeb','');
                }
                else if(kerdes.kerdes_extrak[i].adat_kod.slice(-2) == nyelv) {
                    valaszok.push(kerdes.kerdes_extrak[i].adat_content);
                }
            }

            return generateCustomChoices(valaszok, egyebSorszam, ugrasok);

        case 'igen_nem': 
            var ugrasok = [];
            for (var i in kerdes.kerdes_extrak) {
                /*van egyéb opció*/
                if(kerdes.kerdes_extrak[i].adat_kod.slice(-5) == 'ugrik') {
                    var ind = kerdes.kerdes_extrak[i].adat_kod.replace('valasz','').replace('_ugrik','');
                    ugrasok[ind] = kerdes.kerdes_extrak[i].adat_content;
                }
            }
            return generateYesNoQuestion(ugrasok, nyelv);
        case 'szabad_szoveg':
            return generateTextArea();

        case 'smiley5':
            return generateSmiley(kerdes.valasz_tipus_extrak);
    }

}

/*Számskálás válasz generálása*/ 
function  generateScaleChoices(min, max) {

    var db = parseInt(max) - parseInt(min) + 1;
    var window_width = $('.view-form-page').width();
    var window_margin = Math.ceil(window_width*0.05);
    
    var inner_width = window_width - (window_margin * 2);
    var cell_width = Math.ceil(inner_width / db);
    var margin = Math.ceil(cell_width * 0.1);
    cell_width -= margin;

    var cell_height = Math.min(200, 1.5*cell_width);
    
    var outline_color = struct['szinek'].find(x => x.objektum_nev == 'gomb_szoveg').szinkod;
    var row = '<div class="cf-view-content cf-view-numrow">';
    for(i = min; i <= max; i++) {
        row += '<button data-value="'+ i +'" class="btn cf-view-numcell cf-view-action" style="width:'+ cell_width +'px; height:'+ cell_height+'px; max-height:'+cell_height+'px!important; margin-right:'+ margin +'px; border-color: #'+ outline_color +'">' + i + '</button>';
    }
    row += '</div>';

    return row;
}

/*Egyedileg definiált válaszok*/
function generateCustomChoices(valaszok, egyebSorszam, ugrasok) {
    var outline_color = struct['szinek'].find(x => x.objektum_nev == 'gomb_szoveg').szinkod;
    var border_color = struct['szinek'].find(x => x.objektum_nev == 'gomb_hatter').szinkod;
    var hasInputField = isDefined(valaszok.find(x => x == 'Egyeb'));

    function sorrendezes(a, b){
        var a_sorrend = parseInt(a.sorrend);
        var b_sorrend = parseInt(b.sorrend); 
        return ((a_sorrend < b_sorrend) ? -1 : ((a_sorrend > b_sorrend) ? 1 : 0));
    }
    
    valaszok.sort(sorrendezes);

    var dimensions = getGrid(valaszok.length, 3);
    var col_num = 12 / dimensions[1];
    var row = '<div class="container mt-3 cf-view-content"><div class="row">';

    for(i = 0; i < valaszok.length; i++) {

        var data_ugras = '';
        if(isDefined(ugrasok[i])){
            data_ugras = 'data-ugras="' + ugrasok[i] + '"';
        }

        if(i % dimensions[1] == 0) {
            if(i == valaszok.length) {
                row += '</div>';
            } else {
                if(i == egyebSorszam-1) {
                    row += '</div><div class="row"><div class="col-'+ col_num +'"><input data-value="'+ valaszok[i] + '" '+data_ugras+' class="form-control cf-view-input cf-view-action" style="border-color: #'+ border_color +'; color: #'+outline_color+'" type="text" placeholder="[[$t.egyeb_valasz]]"></div>';
                }
                else if (hasInputField) {
                    row += '</div><div class="row"><div class="col-'+ col_num +'"><button data-value="'+ valaszok[i] +'" '+data_ugras+' class="btn cf-view-cell-2 cf-view-action"  style="border-color: #'+ outline_color +'">' + valaszok[i] + '</button></div>';
                } else {
                    row += '</div><div class="row"><div class="col-'+ col_num +'"><button data-value="'+ valaszok[i] +'" '+data_ugras+' class="btn cf-view-cell cf-view-action" style="border-color: #'+ outline_color +'">' + valaszok[i] + '</button></div>';
                }
            }
        } else {
            if(i == egyebSorszam-1) {
                row += '<div class="col-'+ col_num +'"><input data-value="'+ valaszok[i] + '" class="form-control cf-view-input cf-view-action" style="border-color: #'+ border_color +'; color: #'+outline_color+'" type="text" placeholder="[[$t.egyeb_valasz]]"></div>';
            }
            else if (hasInputField) {
                row += '<div class="col-'+ col_num +'"><button data-value="'+ valaszok[i] +'" '+data_ugras+' class="btn cf-view-cell-2 cf-view-action" style="border-color: #'+ outline_color +'">' + valaszok[i] + '</button></div>';
            } else {
                row += '<div class="col-'+ col_num +'"><button data-value="'+ valaszok[i] +'" '+data_ugras+' class="btn cf-view-cell cf-view-action" style="border-color: #'+ outline_color +'">' + valaszok[i] + '</button></div>';
            }
        }
    }
    row += '</div>';
    return row;
}

function generateTextArea() {
    var border_color = struct['szinek'].find(x => x.objektum_nev == 'gomb_hatter').szinkod;
    var row = '<div class="container mt-3 cf-view-content"> <div class="row">';
        row += '<div class="col-12"><textarea class="form-control cf-view-textarea cf-view-action" rows="10" style="border-color: #'+border_color+'; color: #000" maxlength="500"></textarea></div>';
    row += '</div></div>';
    return row;

}

function generateSmiley(list) {
    var html = '<div class="cf-view-content">';
    for (var i in list) {
        html += '<img data-value="'+ i +'" class="cf-view-smiley cf-view-action" src="'+get_img_urls(list[i].adat_content.replace('jpg', 'png')).orig+'"></img>';
    }
    html += '</div>';
    return html;
}

function generateYesNoQuestion(ugrasok, lang) {
    var igen = isDefined(struct['nyelvek'][lang]['szovegek']['igen_szoveg']) ? struct['nyelvek'][lang]['szovegek']['igen_szoveg'] : '[[$t.igen]]';
    var nem = isDefined(struct['nyelvek'][lang]['szovegek']['nem_szoveg']) ? struct['nyelvek'][lang]['szovegek']['nem_szoveg'] : '[[$t.nem]]';

    var row = '<div class="container cf-view-content"> <div class="row m-auto">';
        row += '<div class="col-6"><button data-value="1" class="btn cf-view-cell cf-view-yn cf-view-action m-auto">'+igen+'</button></div>';
        row += '<div class="col-6"><button data-value="0" class="btn cf-view-cell cf-view-yn cf-view-action m-auto">'+nem+'</button></div>';
    row += '</div></div>';

    return row;
    
}

function applyStyle() {
    for(var i in struct['szinek']) {
        switch(struct['szinek'][i]['objektum_nev']) {
            case 'fejlec_szoveg':
                $('.cf-cover-title, .cf-question-header, .cf-back-title').css('color', '#'+struct['szinek'][i]['szinkod']);
            break;
            case 'fejlec_szoveg_kieg':
                $('.cf-subtitle, .cf-cover-subtitle').css('color', '#'+struct['szinek'][i]['szinkod']);
            break;
            case 'zaro_oldal_szoveg':
                $('.cf-back-title, .cf-next-button i').css('color', '#'+struct['szinek'][i]['szinkod']);
            break;
            case 'fejlec_hatter':
                $('.cf-question-header').css('background-color', '#'+struct['szinek'][i]['szinkod']);
            break;
            case 'gomb_hatter':
                $(' .cf-view-numcell, .cf-view-cell, .cf-view-cell-2, .cf-view-input').css('background-color', '#'+struct['szinek'][i]['szinkod']);
            break;
            case 'gomb_szoveg':
                $('.cf-view-numcell, .cf-view-cell, .cf-view-cell-2, .cf-view-input').css('color', '#'+struct['szinek'][i]['szinkod']);
            break;
        }
    }

    var kezdoHatterkep = get_img_urls(struct['hatterkepek'].kep_kezdo_oldal);
    $('.cover-page').css('background-image', 'url('+kezdoHatterkep.orig+')');
    $('.cover-page').css('background-size', 'cover');
    $('.cover-page').css('background-repeat', 'no-repeat');

    var hatterkep = get_img_urls(struct['hatterkepek'].kep_kerdes_oldal);
    $('.question-page').css('background-image', 'url('+hatterkep.orig+')');
    $('.question-page').css('background-size', 'cover');
    $('.question-page').css('background-repeat', 'no-repeat');

    var hatterkepVegso = get_img_urls(struct['hatterkepek'].kep_utolso_oldal);
    $('.back-page').css('background-image', 'url('+hatterkepVegso.orig+')');
    $('.back-page').css('background-size', 'cover');
    $('.back-page').css('background-repeat', 'no-repeat');
}


function getGrid(size, maxColumnNumber) {
    if(size == 0) {
        return new Array(0,0);
    }
    else if (size == 1) {
        return new Array(1,1);
    }
    else {
        var mod;

        if(size < maxColumnNumber*2) {
            mod = 2;
            while(size % mod != 0  && mod < maxColumnNumber) {
                mod++;
            }
        } else {
            mod = maxColumnNumber;
        }
        return new Array(Math.ceil(size/mod), mod);
    }
}


function LightenDarkenColor(col, amt) {
  
    var usePound = false;
  
    if (col[0] == "#") {
        col = col.slice(1);
        usePound = true;
    }
 
    var num = parseInt(col,16);
 
    var r = (num >> 16) + amt;
 
    if (r > 255) r = 255;
    else if  (r < 0) r = 0;
 
    var b = ((num >> 8) & 0x00FF) + amt;
 
    if (b > 255) b = 255;
    else if  (b < 0) b = 0;
 
    var g = (num & 0x0000FF) + amt;
 
    if (g > 255) g = 255;
    else if (g < 0) g = 0;
 
    return (usePound?"#":"") + (g | (b << 8) | (r << 16)).toString(16);
  
}

function activateInput(elem, add, activeColor, inactiveColor) {
    if(add) {
        $(elem).addClass('active');
        if($(elem).is('.cf-view-numcell, .cf-view-cell, .cf-view-cell-2, .cf-view-input')) {
            $(elem).css('background-color', activeColor);
        }
    } else {
        $(elem).removeClass('active');
        if($(elem).is('.cf-view-numcell, .cf-view-cell, .cf-view-cell-2, .cf-view-input')) {
            $(elem).css('background-color', inactiveColor);
        }
    }
}

function toggleNextButton(show) {
    if(show) {
        $('.cf-next-button').removeClass('d-none');
        $('.cf-next-button').removeClass('disabled');
        $('.cf-next-button').prop('disabled', false);
    } else {
        $('.cf-next-button').addClass('d-none');
        $('.cf-next-button').addClass('disabled');
        $('.cf-next-button').prop('disabled', true);
    }
}

function toggleElem(elem, disable) {
    if(disable) {
        $(elem).addClass('disabled');
        $(elem).prop('disabled', true);
    } else {
        $(elem).removeClass('disabled');
        $(elem).prop('disabled', false);
    }
    
}

function createLangSelectors(nyelv) {

    var lang_selector = '';
    if(Object.keys(struct['nyelvek']).length > 1) {
        for (var i in struct['nyelvek']) {
            if(i == nyelv) {
                lang_selector += '<img id="lang_'+i+'" data-lang="'+i+'" class="mr-2 active" src="/includables/langpics/'+ i +'.png"></img>'
            } else {
                lang_selector += '<img id="lang_'+i+'" data-lang="'+i+'" class="mr-2" src="/includables/langpics/'+ i +'.png"></img>'
            }
            
        }
    }
    return lang_selector;
}






