
var REGIOK = objectToArray(szurheto_adatok.regiok);
var TELEPHELYEK = objectToArray(szurheto_adatok.telephelyek);
var ESZKOZOK = objectToArray(szurheto_adatok.eszkozok);
var KERDOIVEK = objectToArray(szurheto_adatok.kerdoivek);
var PARTNEREK = objectToArray(szurheto_adatok.partnerek);
var KERDESEK = objectToArray(szurheto_adatok.kerdesek);

var GRAFIKON_ADATOK = [];

var validKerdesek = getValidKerdesek(KERDESEK, KERDOIVEK);

var jelentesek = null;

$(document).ready(function() {

    google.charts.load('current', {packages: ['corechart', 'line']});

    var jelentes_szuro = {
        inic_param: {
                id: 'jelentes_szuro',
                cols: 3,
                rows: 3,
            },
            buttons: [
                {
                    name:"[[$t.szures]]",
                    id: 'btn_riport_szures',
                    type: 'filter',
                    visibility: function() {return 1},
                    callback: function(valid) {
                        if(valid) {
                            $('#jelentes-holder').html('');
                            $('#btn_riport_nyomtatas').removeClass('is-inactive');
                            $('#btn_riport_nyomtatas').prop('disabled', false);
                            $('.megjelenites-vezerles').removeClass('d-none');
                            $('.megjelenites-vezerles input').prop('checked', false);
                            GRAFIKON_ADATOK = [];
                            nyersAdatokLekeres();   
                        }
                        
                    },
                    onCustomAjaxDone: function(event,result,trigger){
                    }   
                },
                {
                    name:"[[$t.nyomtatas]]",
                    id: 'btn_riport_nyomtatas',
                    type: 'print',
                    addClass : 'mb-2',
                    visibility: function() {
                        return 0;
                    },
                    callback: function() {
                        var partnerId = $('#partner_select_input').val()[0];
                        var partner = findInArray(PARTNEREK, 'id', partnerId);
                        var reportData = {
                            type: 'line',
                            tipus: '[[$t.jelentesek_trend]]',
                            partner: partner
                        };
                        printData(reportData);
                    },
                    onCustomAjaxDone: function(event,result,trigger){
                    }   
                }
            ],
            inputs: [
                {"col": 0, "row": 0, "input": filterSelectHtml({
                                    id: 'partner_select_input',
                                    label: '[[$t.partner]]',
                                    placeholder: '[[$t.valassz]]',
                                    name: 'partner_select_input',
                                    maxOptions: 1,
                                    addclass: 'form',
                                    required: true
                                },
                                filterSelectValues(szurheto_adatok.partnerek , 'nev', 'id')
                            )
                },
                {"col": 1, "row": 0, "input": filterSelectHtml({
                                    id: 'eszkoz_select_input',
                                    label: '[[$t.csatorna]]',
                                    placeholder: '[[$t.valassz]]',
                                    name: 'eszkoz_select_input',
                                    maxOptions: 'inf',
                                    addclass: 'form',
                                    required: true
                                },
                                filterSelectValues(szurheto_adatok.eszkozok , 'nev', 'id')
                            )
                },
                {"col": 2, "row": 0, "input": filterSelectHtml({
                                    id: 'kikuldes_select_input',
                                    label: '[[$t.kikuldes]]',
                                    placeholder: '[[$t.mind]]',
                                    name: 'kikuldes_select_input',
                                    maxOptions: 'inf',
                                    addclass: 'form',
                                },
                                filterSelectValues(szurheto_adatok.partnerek , 'nev', 'id')
                            )
                },
                {"col": 0, "row": 1, "input": filterSelectHtml({
                                                id: 'kerdes_select_input',
                                                label: '[[$t.kerdes]]',
                                                placeholder: '[[$t.mind]]',
                                                name: 'kerdes_select_input',
                                                maxOptions: 'inf',
                                                addclass: 'form',
                                            },
                                            filterSelectValues(validKerdesek, 'kerdes_szovege', 'azonosito', false)
                                        )
                },
                {"col": 1, "row": 1, "input": filterSelectHtml({
                                    id: 'ismerv_select_input',
                                    label: '[[$t.ismerv_tipus]]',
                                    placeholder: '[[$t.valassz]]',
                                    name: 'ismerv_select_input',
                                    maxOptions: 1,
                                    addclass: 'form',
                                    required: true
                                },
                                filterSelectValues(szurheto_adatok.regiok  , 'nev', 'id')
                            )
                },
                {"col": 2, "row": 1, "input": filterSelectHtml({
                                    id: 'ismervertek_select_input',
                                    label: '[[$t.ismerv]]',
                                    placeholder: '[[$t.mind]]',
                                    name: 'ismervertek_select_input',
                                    maxOptions: 'inf',
                                    addclass: 'form'
                                },
                                filterSelectValues(szurheto_adatok.telephelyek, 'nev', 'id')
                            )
                },
                {"col": 0, "row": 2, "input": filterSelectHtml({
                                                    id: 'idoszak_select_input',
                                                    placeholder: '[[$t.mind]]',
                                                    label: '[[$t.idoszak]]',
                                                    name: 'idoszak_select_input',
                                                    maxOptions: '1',
                                                    addclass: 'form'
                                                },
                                                [
                                                    {name:'[[$t.ma]]', value:'ma'},
                                                    {name:'[[$t.elozo_nap]]', value:'tegnap'},
                                                    {name:'[[$t.utolso_het]]', value:'utolso_het'},
                                                    {name:'[[$t.utolso_honap]]', value:'utolso_honap'},
                                                    {name:'[[$t.ez_a_honap]]', value:'ez_a_honap'},
                                                    {name:'[[$t.elozo_honap]]', value:'elozo_honap'},
                                                    {name:'[[$t.ez_az_ev]]', value:'ez_az_ev'},
                                                    {name:'[[$t.egyeb]]', value:'sajat'}
                                                ]
                )},
                {"col": 1, "row": 2, "input": datepickerHtml({
                                                id: 'kezdo_datum_input',
                                                label: '[[$t.kezdo_datum]]',
                                                addClass: 'd-none'
                                            })
                },
                {"col": 2, "row": 2, "input": datepickerHtml({
                                    id: 'veg_datum_input',
                                    label: '[[$t.veg_datum]]',
                                    addClass: 'd-none'
                                })
                },
            ],
    };

    formHtml('#jelentes_szuro', jelentes_szuro.inic_param, jelentes_szuro.inputs, jelentes_szuro.buttons);


    initDatepicker({id: 'kezdo_datum_input', dateOnly: true});
    initDatepicker({id: 'veg_datum_input', dateOnly: true});


    /*Firefoxban enélkül nem jelennek meg a selectek*/
    $('#szuro_select_input').selectpicker();
    $('#partner_select_input').selectpicker();
    $('#kikuldes_select_input').selectpicker();
    $('#kerdes_select_input').selectpicker();
    $('#ismerv_select_input').selectpicker();
    $('#ismervertek_select_input').selectpicker();
    $('#idoszak_select_input').selectpicker();
    $('#eszkoz_select_input').selectpicker();



    $('.selectpicker').on('change', function() {
        selectUjraepites(this.id);
    });

    $('.selectpicker').on('blur', function() {
        console.log('blur');
    });

    initChartAndTableTogglers();
    szuroNullazas();

});

function selectUjraepites(selectId, force) {

    var selectTipus = selectId.split('_')[0];

    var selectErtekek = $('#'+selectId).val();
    switch(selectTipus) {
        case 'partner':
            szuroNullazas();

            if(selectErtekek.length > 0) {
                /*selectSzures('kikuldes',selectTipus,selectErtekek);*/
                selectSzures('eszkoz',selectTipus,selectErtekek);
                $('#eszkoz_select_input').prop('disabled', false);
                $(".btn[data-id='eszkoz_select_input']").removeClass("disabled");
            } else {
                refillSelect('partner_select_input',filterSelectValues(szurheto_adatok.partnerek , 'nev', 'id'));
            }
        break;
        case "eszkoz":
            refillSelect('kikuldes_select_input',[]);
            refillSelect('kerdes_select_input',filterSelectValues(validKerdesek, 'kerdes_szovege', 'azonosito', false));
            refillSelect('ismerv_select_input',[]);
            refillSelect('ismervertek_select_input',[]);
            $('#kikuldes_select_input').prop('disabled', true);
            $(".btn[data-id='kikuldes_select_input']").addClass("disabled");
            $('#kerdes_select_input').prop('disabled', true);
            $(".btn[data-id='kerdes_select_input']").addClass("disabled");
            $('#ismerv_select_input').prop('disabled', true);
            $(".btn[data-id='ismerv_select_input']").addClass("disabled");
            $('#ismervertek_select_input').prop('disabled', true);
            $(".btn[data-id='ismervertek_select_input']").addClass("disabled");

            
            if(selectErtekek.length > 0) {
                selectSzures('kikuldes',selectTipus,selectErtekek);
            } else {
                $('#kikuldes_select_input').prop('disabled', true);
                $(".btn[data-id='kikuldes_select_input']").addClass("disabled");
                $('#kerdes_select_input').prop('disabled', true);
                $(".btn[data-id='kerdes_select_input']").addClass("disabled");
                $('#ismerv_select_input').prop('disabled', true);
                $(".btn[data-id='ismerv_select_input']").addClass("disabled");
                $('#ismervertek_select_input').prop('disabled', true);
                $(".btn[data-id='ismervertek_select_input']").addClass("disabled");
                
                /*refillSelect('eszkoz_select_input',filterSelectValues(szurheto_adatok.eszkozok , 'nev', 'id'));*/
                selectSzures('eszkoz','partner',$('#partner_select_input').val());
            }
        break;
        /*case 'kikuldes':
            if(selectErtekek.length == 0) {
                $('#kerdes_select_input').prop('disabled', true);
                $(".btn[data-id='kerdes_select_input']").addClass("disabled");
                $('#ismerv_select_input').prop('disabled', true);
                $(".btn[data-id='ismerv_select_input']").addClass("disabled");
                $('#ismervertek_select_input').prop('disabled', true);
                $(".btn[data-id='ismervertek_select_input']").addClass("disabled");
            } else {
                var i = selectSzures('kerdes',selectTipus,selectErtekek);
                if(i.length > 0) {
                    $('#kerdes_select_input').prop('disabled', false);
                    $(".btn[data-id='kerdes_select_input']").removeClass("disabled");
                }
                selectSzures('ismerv',selectTipus,selectErtekek);
            }
        break;*/

        case 'ismerv':
            var kikuldesIdk = $('#kikuldes_select_input').val();
            if(KIKULDESEK.length == 0) {
                $('#ismervertek_select_input').prop('disabled', true);
                $(".btn[data-id='ismervertek_select_input']").addClass("disabled");
            } else {
                var kikuld = $('#kikuldes_select_input').val().length == 0 ? KIKULDESEK : $('#kikuldes_select_input').val();
                selectSzures('ismervertek',selectTipus,kikuld);
            }
        break;

    }
}

function szuroNullazas() {
    console.log("nullazas");
    refillSelect('kikuldes_select_input',filterSelectValues([] , 'nev', 'id'));
    refillSelect('ismerv_select_input',filterSelectValues([] , 'nev', 'id'));
    refillSelect('ismervertek_select_input',filterSelectValues([] , 'nev', 'id'));
    refillSelect('eszkoz_select_input',filterSelectValues([] , 'nev', 'id'));
    refillSelect('kerdes_select_input',filterSelectValues(validKerdesek , 'kerdes_szovege', 'azonosito', false));

    $('#kikuldes_select_input').prop('disabled', true);
    $(".btn[data-id='kikuldes_select_input']").addClass("disabled");
    $('#kerdes_select_input').prop('disabled', true);
    $(".btn[data-id='kerdes_select_input']").addClass("disabled");
    $('#eszkoz_select_input').prop('disabled', true);
    $(".btn[data-id='eszkoz_select_input']").addClass("disabled");
    $('#ismerv_select_input').prop('disabled', true);
    $(".btn[data-id='ismerv_select_input']").addClass("disabled");
    $('#ismervertek_select_input').prop('disabled', true);
    $(".btn[data-id='ismervertek_select_input']").addClass("disabled");
}

/*Nyers adatok lekérdezése*/
function nyersAdatokLekeres() {
    var kerdesek = $('#kerdes_select_input').val();
    
    if(kerdesek.length == 0) {
        kerdesek = [];
        $('#kerdes_select_input option').each(function() {
            kerdesek.push($(this).val());
        });
    }

    var idoszak = $('#idoszak_select_input').val()[0];
    var ismervId = $('#ismerv_select_input').val()[0];
    var ismervErtekek = $('#ismervertek_select_input').val();

    var kikuldesIds = [];
    var kikuldesLista = $('#kikuldes_select_input').val();
    if(kikuldesLista.length < 1) {
        for(var i in KIKULDESEK) {
            var val = KIKULDESEK[i].value;
            kikuldesIds.push(val.split('#')[0]);
        }
    } else {
        for(var i in kikuldesLista) {
            var val = kikuldesLista[i];
            kikuldesIds.push(val.split('#')[0]);
        }
    }

    if(ismervErtekek.length == 0) {
        ismervErtekek = [];
        for(var i in ISMERV_ERTEKEK) {
            ismervErtekek.push(ISMERV_ERTEKEK[i].value);
        }
    }
   
    function call_jelentesek_sel_ismerv_jelentes(ind) {
        var id = kerdesek[ind];
        var data = {
            "echo": "1",
            "idopont_tol": computeDates(idoszak).kezdet,
            "idopont_ig": computeDates(idoszak).veg,
            "kerdes_id": id,
            'beolvasas_idk': JSON.stringify(kikuldesIds),
            "ismerv_id": ismervId,
            "ismerv_ertekek": JSON.stringify(ismervErtekek)
        };
    
        var resultText = {};
    
        postApi('jelentesek_sel_ismerv_jelentes',data,$('#btn_riport_szures'),resultText,null,function(result){
            if(isDefined(result.echo)) {
                initDataTable(result.data,id);
                if(ind < kerdesek.length - 1) {
                    ind++;
                    call_jelentesek_sel_ismerv_jelentes(ind);
                }
            }
        });
    }

    if(kerdesek.length > 0) {
        call_jelentesek_sel_ismerv_jelentes(0);
    }
}

function initDataTable(kitoltesek, kerdesId) {
    
    var feldolgozottAdat = adatFeldolgozas(kitoltesek,kerdesId);
    if(feldolgozottAdat.length == 0) {
        return;
    }

    /*Fejléc*/
    var tablaFejlec = [];
    

    
    var cimke = "[[$t.ismerv_ertek]]";
    

    tablaFejlec.push({ headName: cimke, colName:"ismerv_ertek"});
    tablaFejlec.push({ headName:"[[$t.id]]", colName:"id", inDetails: true});

    var offset = feldolgozottAdat.van_szarmaztatott ? 1 : 0;
    for(var i = 0; i < feldolgozottAdat.fejlec.length-offset; ++i) {
        if(isDefined(feldolgozottAdat.fejlec[i])) {
            tablaFejlec.push({
                headName: feldolgozottAdat.fejlec[i],
                colName: 'valasz'+i
            });
        } 
    }

    tablaFejlec.push({ headName: '[[$t.valaszok_szama]]', colName:"valaszok_szama"});

    if(offset > 0) {
        tablaFejlec.push({
            headName: feldolgozottAdat.fejlec[(feldolgozottAdat.fejlec.length-offset)],
            colName: 'valasz'+(feldolgozottAdat.fejlec.length-offset)
        });
    }

    /*Adatok*/
    var tablaSorok = [];

    for (var i in feldolgozottAdat.sorok) {
        var feldolgozottAdatSor = feldolgozottAdat.sorok[i];
        var ujSor = {
            "ismerv_ertek": feldolgozottAdatSor.metaadatok.ismerv_ertek,
            "id" : feldolgozottAdatSor.metaadatok.ismerv_id
        };
        var offset = feldolgozottAdat.van_szarmaztatott ? 1 : 0;
        for(var j = 0 ; j < feldolgozottAdatSor.sor_adat.length-offset; ++j) {
            ujSor["valasz"+j] = feldolgozottAdatSor.sor_adat[j] || ' ';
        }
        ujSor["valaszok_szama"] = feldolgozottAdatSor.metaadatok.valaszok_szama;

        if(offset > 0) {
            ujSor["valasz"+(feldolgozottAdatSor.sor_adat.length-offset)] = feldolgozottAdatSor.sor_adat[(feldolgozottAdatSor.sor_adat.length-offset)] || ' ';
        }

        tablaSorok.push(ujSor);        
    }
    var lathatosagSelect = filterSelectHtml({
                            id: 'lathatosag_select_input-'+kerdesId,
                            placeholder: '[[$t.tabla_es_grafikon_megjelenites]]',
                            name: 'lathatosag_select_input-'+kerdesId,
                            maxOptions: 'inf',
                            addclass: 'form cf-report-visibility'
                        },
                        [
                            {"name": '[[$t.tabla_eltuntet]]', "value": 'tabla_eltuntet'},
                            {"name": '[[$t.grafikon_eltuntet]]', "value": 'grafikon_eltuntet'},
                        ]
                    );
    var exportBtn = buttonHtml({
                        name:"[[$t.export]]",
                        id: 'btn_riport_export_'+kerdesId,
                        type: 'print',
                        addClasses : 'btn-main ml-2 export-btn',
                        visibility: function() {
                            return 1;
                        },
                        callback: null,
                        onCustomAjaxDone: function(event,result,trigger){
                        }   
                    });

    $('#jelentes-holder').append('<div id="tabla-blokk-'+kerdesId+'" class="mb-4"></div>');

    var szuresiAdatok = "[[$t.ismerv_jelentes_szuresi_szoveg]]"; 

    $('#tabla-blokk-'+kerdesId).html('<h2 class="table_name">'+feldolgozottAdat.kerdes+'</h2><div class="cf-filter-string">'+szuresiAdatok+'</div><div class="lathatosag-holder mb-3">'+lathatosagSelect+exportBtn+'</div><div class="table-recreate"><div id="jelentesek-'+kerdesId+'"></div></div>');
    
    var partnerNev = '';
    var kerdes = findInArray(KERDESEK,'id',kerdesId);
    if(!$.isArray(kerdes.fk_kerdoivek)) {
            var kerdoiv = findInArray(KERDOIVEK, 'id', kerdes.fk_kerdoivek);    
            var kerdesPartnere = findInArray(PARTNEREK, 'id', kerdoiv.fk_partner);
            partnerNev = kerdesPartnere.nev + ' - ';
    }

    szuresiAdatokOsszeallitas('#tabla-blokk-'+kerdesId);

    /*Dátum a letöltött fájl címébe*/
    var datum = getDate(new Date());
    var datumStr = datum.year + (datum.month < 10 ? '0' : '') + datum.month + (datum.day < 10 ? '0' : '') + datum.day; 
    /*Data table előállítása*/
    jelentesek = dataTable($('#jelentesek-'+kerdesId),{
        table: {
            hasExport: true,
            exportTitle: '[[$t.title]]'+ ' ' + partnerNev + '[[$t.jelentesek_ismerv]]' + " " + formatDate(datumStr),
            sumFooter : {
                hasSumFooter: true,
                exportSumFooter: feldolgozottAdat.osszegzo_sor,
                hasCalculatedCol: feldolgozottAdat.van_szarmaztatott,
                type: feldolgozottAdat.kerdes_tipus,
                isNPS: feldolgozottAdat.nps,
                isCES:feldolgozottAdat.ces
            }
        },
        data:function(callback,element){            
            callback({data: tablaSorok});
        },
        columns: tablaFejlec,
    });

    $('#jelentesek-'+kerdesId+'_wrapper .dt-buttons .buttons-excel').css('display', 'none');
    $('#lathatosag_select_input-'+kerdesId).selectpicker();
    $('#btn_riport_export_'+kerdesId).on('click', function() {
        $(this).parent().parent().find('.buttons-excel').trigger('click');
    });

    grafikonokInit(feldolgozottAdat.grafikon, kerdesId);
}

function adatFeldolgozas(kitoltesek, kerdesId) {

    if(kitoltesek.length == 0) {
        return [];
    }
    var tablaFejlec = [];
    var tablaSorok = [];
    var grafikonAdatok = {};
    var van_szarmaztatott = false;

    var adatok = getKerdesAdatok(KERDESEK, KERDOIVEK, kerdesId);
    var kerdes = adatok["kerdes"];
    var lehetsegesValaszok = adatok["lehetsegesValaszok"];
    var nps_e =  adatok['nps_e'];
    var ces_e = adatok['ces_e'];


    /*FEJLEC*/
    tablaFejlec = lehetsegesValaszok;

    var ismervErtekTomb = [];

    var realLength = tablaFejlec.reduce(x => x+1, 0);
    var osszegzoSor = tombokTombjeInic(realLength, 0);

    /*CELLÁK*/
    var tabla = [];
    for(var i in kitoltesek) {
        var kitoltes = kitoltesek[i];
        var ismervErtek = kitoltesek[i].ismerv_ertek;

        if(!isDefined(tabla[ismervErtek])) {
            ismervErtekTomb.push(ismervErtek);
            tabla[ismervErtek] = tombokTombjeInic(tablaFejlec.length, "0");
        } 

        var korrigaltId = kitoltes.valasz_sorszam - 1;


        if(ces_e){
            if(adatok['kerdes']['valasz_tipus_kod'].slice(0,8)=="ikonok-5"){
                /*detractors*/
                if(kitoltes.valasz_sorszam == 1 || kitoltes.valasz_sorszam == 2 ) {    
                    tabla[ismervErtek][2] = isDefined(tabla[ismervErtek][2]) ? parseInt(tabla[ismervErtek][2]) + parseInt(kitoltes.elofordulas) : kitoltes.elofordulas;
                    osszegzoSor[2] += parseInt(kitoltes.elofordulas);
                }
                /*neutrals*/ 
                else if( kitoltes.valasz_sorszam == 3) { 
                    tabla[ismervErtek][1] = isDefined(tabla[ismervErtek][1]) ? parseInt(tabla[ismervErtek][1]) + parseInt(kitoltes.elofordulas) : kitoltes.elofordulas;
                    osszegzoSor[1] += parseInt(kitoltes.elofordulas);
                }
                /*promoters*/
                else if(kitoltes.valasz_sorszam==4 || kitoltes.valasz_sorszam==5) {
                    tabla[ismervErtek][0] = isDefined(tabla[ismervErtek][0]) ? parseInt(tabla[ismervErtek][0]) + parseInt(kitoltes.elofordulas) : kitoltes.elofordulas;
                    osszegzoSor[0] += parseInt(kitoltes.elofordulas);
                }
            }
        /*NPS esetén más a tábla modellje*/ 
        }else  if(nps_e) {
            if(adatok['kerdes']['valasz_tipus_kod'].slice(0,8) == "ikonok-4") {
                /*detractors*/
                if(kitoltes.valasz_sorszam == 1) {    
                    tabla[ismervErtek][2] = isDefined(tabla[ismervErtek][2]) ? parseInt(tabla[ismervErtek][2]) + parseInt(kitoltes.elofordulas) : kitoltes.elofordulas;
                    osszegzoSor[2] += parseInt(kitoltes.elofordulas);
                }
                /*neutrals*/ 
                else if(kitoltes.valasz_sorszam == 2 || kitoltes.valasz_sorszam == 3) { 
                    tabla[ismervErtek][1] = isDefined(tabla[ismervErtek][1]) ? parseInt(tabla[ismervErtek][1]) + parseInt(kitoltes.elofordulas) : kitoltes.elofordulas;
                    osszegzoSor[1] += parseInt(kitoltes.elofordulas);
                }
                /*promoters*/
                else {
                    tabla[ismervErtek][0] = isDefined(tabla[ismervErtek][0]) ? parseInt(tabla[ismervErtek][0]) + parseInt(kitoltes.elofordulas) : kitoltes.elofordulas;
                    osszegzoSor[0] += parseInt(kitoltes.elofordulas);
                }
            } else {
                /*detractors*/
                if(korrigaltId < 7) {    
                    tabla[ismervErtek][2] = isDefined(tabla[ismervErtek][2]) ? parseInt(tabla[ismervErtek][2]) + parseInt(kitoltes.elofordulas) : kitoltes.elofordulas;
                    osszegzoSor[2] += parseInt(kitoltes.elofordulas);
                }
                /*neutrals*/ 
                else if(korrigaltId < 9) { 
                    tabla[ismervErtek][1] = isDefined(tabla[ismervErtek][1]) ? parseInt(tabla[ismervErtek][1]) + parseInt(kitoltes.elofordulas) : kitoltes.elofordulas;
                    osszegzoSor[1] += parseInt(kitoltes.elofordulas);

                }
                /*promoters*/
                else {
                    tabla[ismervErtek][0] = isDefined(tabla[ismervErtek][0]) ? parseInt(tabla[ismervErtek][0]) + parseInt(kitoltes.elofordulas) : kitoltes.elofordulas;
                    osszegzoSor[0] += parseInt(kitoltes.elofordulas);
                }
            }
            
        } else if (kerdes.valasz_tipus_kod.slice(0,6) == 'ikonok' || kerdes.valasz_tipus_kod == 'szamok-1-10' || kerdes.valasz_tipus_kod == 'szamok-0-10' || kerdes.valasz_tipus_kod == 'szamok-1-6' || kerdes.valasz_tipus_kod == 'szamok-1-5') { 
            tabla[ismervErtek][tablaFejlec.length - 2 - korrigaltId] = kitoltes.elofordulas;
            osszegzoSor[tablaFejlec.length - 2 - korrigaltId] += parseInt(kitoltes.elofordulas);
        } else if(kerdes.valasz_tipus_kod == 'igen_nem') {
            tabla[ismervErtek][korrigaltId] = kitoltes.elofordulas;
            osszegzoSor[korrigaltId] += parseInt(kitoltes.elofordulas);
        } else {
            tabla[ismervErtek][kitoltes.valasz_sorszam] = kitoltes.elofordulas;
            osszegzoSor[kitoltes.valasz_sorszam-1] += parseInt(kitoltes.elofordulas);
        }
    }

    var osszes_valasz_szama = 0;
    for(var i in tabla) {
        var sor = tabla[i];
        var valaszok_szama = 0;
        var szarmaztatottErtek = szarmaztatottErtekSzamitas(kerdes.valasz_tipus_kod,sor,nps_e,ces_e);

        var ind = $.inArray(i,ismervErtekTomb);
        if(ind < 0) {continue;}
        if(isDefined(sor) && sor != null) {
            for(var k in sor) {
                if($.isNumeric(sor[k])) {
                    valaszok_szama = parseInt(valaszok_szama) + parseInt(sor[k]);
                }
            }

            osszes_valasz_szama += valaszok_szama;
            if(szarmaztatottErtek != null) {
                sor[sor.length-1] = szarmaztatottErtek;
                van_szarmaztatott = true;
            }
            var ujSor = {
                metaadatok: {
                    ismerv_ertek: ismervErtekTomb[ind],
                    ismerv_id: ind,
                    szarmaztatott_ertek: szarmaztatottErtek,
                    valaszok_szama: valaszok_szama
                },
                sor_adat: sor
            };

            tablaSorok.push(ujSor);
        }
    }
    

    /*Összesítés*/
    /*Külön kell figyelni rá, hogy volt-e származtatott érték oszlop*/
    osszegzoSor.push("0");
    if(van_szarmaztatott) {
        osszegzoSor[osszegzoSor.length-1] = "\u200C"+szarmaztatottErtekSzamitas(kerdes.valasz_tipus_kod,osszegzoSor,nps_e,ces_e);
        osszegzoSor[osszegzoSor.length-2] = osszes_valasz_szama;
    } else {
        osszegzoSor[osszegzoSor.length-1] = osszes_valasz_szama;
    }

    /*Grafikon adatok*/
    var npsExtra = findInArray(kerdes.kerdes_extrak, 'adat_kod', 'nps');
    var nps_e = isDefined(npsExtra) ?  npsExtra.adat_content : 0;
    var cesExtra = findInArray(kerdes.kerdes_extrak, 'adat_kod', 'ces');
    var ces_e = isDefined(cesExtra) ?  cesExtra.adat_content : 0;

    csakNyers = true;
    lehetsegesValaszok = lehetsegesValaszokLegyujtes(kerdes.valasz_tipus_kod,kerdes.kerdes_extrak,kerdes.valasz_tipus_extrak,csakNyers, kerdes.azonosito);
    

    if(kerdes.valasz_tipus_kod.slice(0,6) == 'ikonok' || kerdes.valasz_tipus_kod == 'szamok-1-10' || kerdes.valasz_tipus_kod == 'szamok-0-10' || kerdes.valasz_tipus_kod == 'szamok-1-6' || kerdes.valasz_tipus_kod == 'szamok-1-5' || nps_e) { 
        lehetsegesValaszok.reverse();
    }

    
    /*Idegen nyelvek miatt kell*/
    kerdes.kerdes_szoveg = KERDESEK[kerdes.id].kerdes_szovege;

    /*A kérdés tényleges szövege is trükkös, főleg a felüldefiniálható rendszerszintű kérdés miatt*/
    var kerdesSzoveg = '';
    var kerdoivIdk = [];
    if($('#kerdoiv_select_input').length > 0) {
        kerdoivIdk = $('#kerdoiv_select_input').val();
    } else if($('#kikuldes_select_input').length > 0) {
        var eszkozIdk = $('#eszkoz_select_input').val();
        for(var i in eszkozIdk) {
            var eszkoz = findInArray(ESZKOZOK, 'id', eszkozIdk[i]);
            kerdoivIdk.push(eszkoz.fk_kerdoivek);
        }
    }
    if(kerdes.id == "2" && kerdoivIdk.length == 1) {
        kerdesSzoveg = kerdesKeerdoivAlapjan(kerdes, kerdoivIdk[0]);
    } else {
        kerdesSzoveg = (kerdes.eredeti_kerdes_szoveg != null && kerdes.eredeti_kerdes_szoveg.length > 0) ? kerdes.eredeti_kerdes_szoveg : kerdes.kerdes_szoveg;
    }
    console.log(kerdes);

    grafikonAdatok = {
        "szoveg":kerdesSzoveg,
        "tipus": kerdes.valasz_tipus_kod,
        "nps": nps_e,
        "ces": ces_e,
        "lehetseges_valaszok": lehetsegesValaszok,
        "lebontasok": [],
        "data": []
    };

    var tablaSorokLength = tablaSorok.length;
    for(var i = 0; i < tablaSorokLength; ++i) {
        var sor = tablaSorok[i];
        grafikonAdatok["lebontasok"].push(sor.metaadatok.ismerv_ertek);
    }
    grafikonAdatok["lebontasok"].push('[[$t.osszegzes]]');
         
    var ind = 0;
    for(var i in lehetsegesValaszok) {
        var valaszSzoveg = lehetsegesValaszok[i];
        var data = [];
        for(var j = 0; j < tablaSorokLength; ++j) {
            var sor = tablaSorok[j];
            var valaszokSzama = "";
            valaszokSzama = sor.sor_adat[i];
            data.push(valaszokSzama);
        }
        data.push(osszegzoSor[ind]);
        ++ind;
        
        var dataset = {
            label: valaszSzoveg,
            data: data
        };
        grafikonAdatok["data"].push(dataset);
    }

    /* Az üres sorokat csak ilyen körülményesen lehet kiírtani*/
    var grafikonLebontasok = [];
    var grafikonData = [];
    for(var i in grafikonAdatok["data"]) {
        grafikonData.push({
            label: grafikonAdatok["data"][i].label,
            data: []
        });
    }

    for(var i in grafikonAdatok["lebontasok"]) {
        var arr = [];
        var count = 0;
        for(var j in grafikonAdatok["data"]){
            count += parseInt(grafikonAdatok["data"][j].data[i]);
            arr.push(grafikonAdatok["data"][j].data[i]);
        }

        if(count != 0) {
            for(var j in grafikonAdatok["data"]){
                grafikonData[j].data.push(grafikonAdatok["data"][j].data[i]);
            }
            grafikonLebontasok.push(grafikonAdatok["lebontasok"][i]);
        } 
        
    }

    grafikonAdatok["lebontasok"] = grafikonLebontasok;
    grafikonAdatok["data"] = grafikonData;
    
    return {
        kerdes: kerdesSzoveg,
        fejlec: tablaFejlec,
        sorok: tablaSorok,
        grafikon: grafikonAdatok,
        van_szarmaztatott: van_szarmaztatott,
        osszegzo_sor: osszegzoSor,
        kerdes_tipus:  kerdes.valasz_tipus_kod,
        nps: nps_e,
        ces: ces_e
    }
}

function szuresiAdatokOsszeallitas(id) {
    var szoveg = $(id).find('.cf-filter-string').html();

    var ismerv = $('#ismerv_select_input').val()[0];
    ismerv = findInArray(ISMERVEK,'value',ismerv);

    var idoszak = $('#idoszak_select_input').val()[0];

    szoveg = szoveg.replace('#ismerv#', '<span class="font-weight-bold">'+ismerv.name+'</span>');
    szoveg = szoveg.replace('#kezdo_datum#', '<span class="font-weight-bold">'+formatDate(computeDates(idoszak).kezdet.split(' ')[0])+'</span>');
    szoveg = szoveg.replace('#veg_datum#', '<span class="font-weight-bold">'+formatDate(computeDates(idoszak).veg.split(' ')[0])+'</span>');


    $(id).find('.cf-filter-string').html(szoveg);

}

function grafikonokInit(grafikon, kerdesId) {

    $('#charts').html(''); 

    if(grafikon.lehetseges_valaszok.length > 30) { return; }

    if(grafikon.tipus == "szabad_szoveg") { return }

    var lebontasokSzama = grafikon.lebontasok.length;

    if(lebontasokSzama > 0) {

        var height = Math.max(lebontasokSzama * 50, 180);
        var width = window.innerWidth * 0.6;
        var szinek = [];

        /*Itt lehet nagyon sok válasz, így a grafikon legend sok helyet elfoglal, ezért itt növeljük a méretet.*/
        if(grafikon.tipus.slice(0,15) == 'egyedi_valaszok' || grafikon.tipus.slice(0,7) == 'ertekek' || grafikon.tipus=='dropdown') {
            height += 100;
        }

        /*$('#tabla-blokk-'+kerdesId).append('<div style="margin:auto;height:'+height+'px; width:'+width+'px"><canvas id="chart-'+kerdesId+'" height="'+height+'" width="800"></canvas></div>');*/
        $('#tabla-blokk-'+kerdesId).append('<div class="canvas-holder" style="margin:auto;height:'+height+'px;"><canvas id="chart-'+kerdesId+'" ></canvas></div>');
        var ctx = document.getElementById("chart-"+kerdesId);
        ctx.height = height;
 
        var real_length =  grafikon.lehetseges_valaszok.reduce(x => x+1, 0);
        if(grafikon.nps == "1") {
            szinek = szinGeneralas('NPS', real_length);
            drawBarChart("chart-"+kerdesId, grafikon.lebontasok, grafikon.data, szinek, true,false);

        }else if(grafikon.ces=="1"){
              szinek = szinGeneralas('CES', real_length);
            drawBarChart("chart-"+kerdesId, grafikon.lebontasok, grafikon.data, szinek, false,true, grafikon.tipus);
        }else {
            szinek = szinGeneralas(grafikon.tipus, real_length);
            drawBarChart("chart-"+kerdesId, grafikon.lebontasok, grafikon.data, szinek, false, false,grafikon.tipus);
        }

        /*Lehetséges nyomtatáshoz kellenek*/
        GRAFIKON_ADATOK.push({
            id:kerdesId,
            adat: grafikon
        });
    }
}