<?php

// lekerdezni a globalis jogokat
$global_rights = array_column(
    $g['db_db']->sel_global_rights_of_user($_SESSION['user']['id']),
    'id'
);

// lekerdezni a beloginolt user altal letrehozott jogcsoportokat es a belerakott jogokat
$jogcsoport_jogok = $g['db_db']->sel_user_jogcsoport_jogok($_SESSION['user']['id'], $g['lang']);
$jogcsoportok = [];
$jog_idk = [];
foreach ($jogcsoport_jogok as $jog) {
    $jog_idk []= $jog['elemi_jog_id'];
    if (!isset($jogcsoportok[$jog['jogcsoport_id']])) {
        $jogcsoportok[$jog['jogcsoport_id']] = [];
    }
    $jog['globalis_jog'] = in_array($jog['elemi_jog_id'], $global_rights);
    if (!$jog['globalis_jog']) {
        $jog['partnerekhez_adhato'] = array_column(
            $g['db_db']->get_partner_of_partner_jog($jog['elemi_jog_id'], $_SESSION['user']['id']),
            'fk_partnerek'
        );
    }
    $jogcsoportok[$jog['jogcsoport_id']] []= $jog;
}

// lekerdezni, hogy mik azok a jogok, amiket meg nem rendezett jogcsoportba
$jog_idk = array_unique($jog_idk);
$jogcsoportok['be_nem_sorolt'] = $g['db_db']->get_be_nem_sorolt_jogok(
    $_SESSION['user']['id'],
    $_SESSION['user']['id'],
    $g['lang'],
    empty($jog_idk) ? '1' : '0',
    ['jogok' => empty($jog_idk) ? '(1)' : '(' . implode(', ', $jog_idk) . ')']
);

foreach ($jogcsoportok['be_nem_sorolt'] as &$jog) {
    $jog['globalis_jog'] = in_array($jog['elemi_jog_id'], $global_rights);
    if (!$jog['globalis_jog']) {
        $jog['partnerekhez_adhato'] = array_column(
            $g['db_db']->get_partner_of_partner_jog($jog['elemi_jog_id'], $_SESSION['user']['id']),
            'fk_partnerek'
        );
    }
}
unset($jog);

// atadni feluletnek
$g['te']->add('adhato_jogcsoportok', json_encode($jogcsoportok));

$adhato_partnerek_hozzarendeles = \UserFunctions::kezelheto_entitasok($_SESSION['user']['id'], 'partner', 'felhasznalok_partner_hozzarendeles');
$g['te']->add('adhato_partnerek_hozzarendeles', json_encode($adhato_partnerek_hozzarendeles));

$adhato_partnerek_felh_letrehozas = \UserFunctions::kezelheto_entitasok($_SESSION['user']['id'], 'partner', 'felhasznalok_letrehozasa');
$g['te']->add('adhato_partnerek_felh_letrehozas', json_encode($adhato_partnerek_felh_letrehozas));
