<?php

use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;
use PhpOffice\PhpSpreadsheet\Cell\DataValidation;

if (isset($g['parameters'][0]) && $g['parameters'][0] === 'download-excel') {
    define('EMPTY_ESZKOZ_XLSX', GI_PATH_OTHER . 'empty_device.xlsx');
    $filePathParts = explode("/", EMPTY_ESZKOZ_XLSX);

    header('Content-Type: application/octet-stream');
    header("Content-Transfer-Encoding: Binary");
    header("Content-disposition: attachment; filename=\"" . $filePathParts[count($filePathParts) - 1] . "\"");

    $spreadsheet = IOFactory::load(EMPTY_ESZKOZ_XLSX);

    // add telephelyek lista
    $telephelyWorkSheet = $spreadsheet->getSheet(1);
    $telephelyek = \UserFunctions::kezelheto_entitasok(
        $_SESSION['user']['id'],
        'telephely',
        'telephelyek_megtekintese',
        true
    );
    for ($i = 1; $i <= count($telephelyek); $i++) {
        $telephelyWorkSheet->getCell("A$i")->setValue($telephelyek[$i-1]['nev']);
    }

    // add telephely validation
    $validation = $spreadsheet->getSheet(0)->getCell('B2')->getDataValidation();
    $validation->setType(DataValidation::TYPE_LIST);
    $validation->setErrorStyle(DataValidation::STYLE_STOP);
    $validation->setAllowBlank(false);
    $validation->setShowInputMessage(true);
    $validation->setShowErrorMessage(true);
    $validation->setShowDropDown(true);
    $validation->setErrorTitle('Input error');
    $validation->setError('Value is not in list.');
    $validation->setFormula1('locations!$A$1:$A$' . count($telephelyek));

    for ($i = 2; $i <= 300; $i++) {
        $spreadsheet->getSheet(0)->getCell("B$i")->setDataValidation(clone $validation);
    }

    // Maximum string hossz beallitas
    $length = [
        "A" => 100
    ];

    foreach ($length as $k => $v) {
        $validation = $spreadsheet->getSheet(0)->getCell($k . '2')->getDataValidation();
        $validation->setType(DataValidation::TYPE_TEXTLENGTH);
        $validation->setErrorStyle(DataValidation::STYLE_STOP);
        $validation->setAllowBlank(false);
        $validation->setShowInputMessage(true);
        $validation->setShowErrorMessage(true);
        $validation->setErrorTitle('Input error');
        $validation->setError('Value is too long!');
        $validation->setFormula1(0);
        $validation->setFormula2((int)$v);

        for ($i = 2; $i <= 300; $i++) {
            $spreadsheet->getSheet(0)->getCell("$k$i")->setDataValidation(clone $validation);
        }
    }

    // Online oszlop beallitasa
    $validation = $spreadsheet->getSheet(0)->getCell('C2')->getDataValidation();
    $validation->setType(DataValidation::TYPE_LIST);
    $validation->setErrorStyle(DataValidation::STYLE_STOP);
    $validation->setAllowBlank(false);
    $validation->setShowInputMessage(true);
    $validation->setShowErrorMessage(true);
    $validation->setErrorTitle('Input error');
    $validation->setError('Only 0 or 1!');
    $validation->setFormula1('"0,1"');

    for ($i = 2; $i <= 300; $i++) {
        $spreadsheet->getSheet(0)->getCell("C$i")->setDataValidation(clone $validation);
    }

    // Aktiv oszlop beallitasa
    $validation = $spreadsheet->getSheet(0)->getCell('D2')->getDataValidation();
    $validation->setType(DataValidation::TYPE_LIST);
    $validation->setErrorStyle(DataValidation::STYLE_STOP);
    $validation->setAllowBlank(false);
    $validation->setShowInputMessage(true);
    $validation->setShowErrorMessage(true);
    $validation->setErrorTitle('Input error');
    $validation->setError('Only 0 or 1!');
    $validation->setFormula1('"0,1"');

    for ($i = 2; $i <= 300; $i++) {
        $spreadsheet->getSheet(0)->getCell("D$i")->setDataValidation(clone $validation);
    }

    // Download
    $writer =  new Xlsx($spreadsheet);
    $writer->save('php://output');
    exit();
}

$telephelyek_uj = \UserFunctions::kezelheto_entitasok($_SESSION['user']['id'], 'telephely', 'eszkoz_letrehozasa');

$partnerek_telephelyek = [];
foreach ($telephelyek_uj as $telephely) {
    if (!isset($partnerek_telephelyek[$telephely['fk_partner']])) {
        $partnerek_telephelyek[$telephely['fk_partner']] = [
            'partner_nev' => $telephely['partner_nev'],
            'telephelyek' => []
        ];
    }
    $partnerek_telephelyek[$telephely['fk_partner']]['telephelyek'] []= $telephely;
}
$g['te']->add('adhato_telephelyek_uj', json_encode($telephelyek_uj));
$g['te']->add('adhato_partnerek_telephelyek', json_encode($partnerek_telephelyek));

$telephelyek_hozza = \UserFunctions::kezelheto_entitasok($_SESSION['user']['id'], 'telephely', 'eszkozok_kerdoiv_hozzarendeles');
$g['te']->add('adhato_telephelyek_hozza', json_encode($telephelyek_hozza));

$kerdoivek = \UserFunctions::kezelheto_entitasok($_SESSION['user']['id'], 'kerdoiv', 'kerdoivek_megtekintese');
$g['te']->add('hozzarendelheto_kerdoivek', json_encode($kerdoivek));
