$(document).ready(function() {
    jogok = dataTable($('#jogok'),{
        table:{
            name:'[[$t.jogok]]',
        },
        ajax:{
            name:'elemi_jogok_sel',
            data:{
                "echo": "1",
            },
        },
        columns:[
            { headName:"[[$t.nyelv]]", colName:"lang", filterType:"select", filterContent:filterSelectValues(admin_nyelvek,'nyelv_nev','nyelv_kod'), postName:"lang" },
            { headName:"[[$t.kod]]", colName:"kod" },
            { headName:"[[$t.nev]]", colName:"nev", canEdit: true },
            { headName:"[[$t.leiras]]", colName:"leiras", canEdit: true },
            { headName:"[[$t.adhato]]", colName:"adhato", type:"checkbox", filterType:"checkbox"},
            { headName:"[[$t.partnerhez_adhato]]", colName:"partnerhez_adhato", type:"checkbox", filterType:"checkbox"}
        ],
        functions: {
            textedit:{
                right:"elemi_jogok_kezelese",
                title:"[[$t.szoveg_modositas]]",
                icon: 'fa-pen',
                callback: function(element,rowData){

                    popupForm({
                        inic_param: {
                            title:"[[$t.szoveg_modositas]]",
                            id: 'kapcsolat_form',
                            cols: 2,
                            rows: 1,
                        },
                        buttons: [
                            {
                                id: 'btn_mentes',
                                type: 'save',
                                visibility: function() {return 1},
                                callback: function(valid) {

                                    var data = {
                                        'lang': rowData['lang'],
                                        'leiras': $('#leiras').val(),
                                        'elemi_jog_id':rowData['id'],
                                        'nev': $('#nev').val()
                                    };

                                    postApi('elemi_jogok_forditas_set', data, $('#kapcsolat_form'), {}, null, function(result){

                                        if(result['EREDMENY'] == 'OK'){
                                            var row = jogok.row('#'+rowData['id']).data();
                                            row['leiras'] = data['leiras'];
                                            row['nev'] = data['nev'];
                                            jogok.cell('#'+rowData['id'],2).invalidate();
                                            jogok.cell('#'+rowData['id'],3).invalidate();
                                            close_pop_up();
                                        }else{
                                            gi_alert(result['UZENET']);
                                        }
                                    });
                                },
                            },
                        ],
                        inputs: [
                            {"col": 0, "row": 0, "input": inputHtml({
                                                                    id: 'nev',
                                                                    label: '[[$t.nev]]',
                                                                    placeholder: '[[$t.nev]]',
                                                                    name: 'nev',
                                                                    addclass: 'form required',
                                                                    required: true,
                                                                    maxlength: 50
                                                                })
                             },
                             {"col": 1, "row": 0, "input": inputHtml({
                                                                    id: 'leiras',
                                                                    label: '[[$t.leiras]]',
                                                                    placeholder: '[[$t.leiras]]',
                                                                    name: 'leiras',
                                                                    addclass: 'form required',
                                                                    maxlength: 100
                                                                })
                            },

                        ],
                    });
                    $('#leiras').val(rowData['leiras']);
                    $('#nev').val(rowData['nev']);

                }

            }
        }
    });
});