<?php

namespace A;

set_time_limit(1000000);


require '../vendor/autoload.php';
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

$locale = 'hu_HU';
$validLocale = \PhpOffice\PhpSpreadsheet\Settings::setLocale($locale);
if (!$validLocale) {
    echo 'Unable to set locale to ' . $locale . " - reverting to en_us" . PHP_EOL;
}

class trend_report extends \GI\Ajax{

    public $rights_required = [
        'tomeges_kikuldes'
    ];

    public $parameters = array(
        'echo' => 'int',
        'idopont_tol' => 'lang_text',
        'idopont_ig' => 'lang_text',
        'kerdes_idk' => 'lang_text',
        'kerdes_idk_szoveggel' => 'lang_text',
        'ismerv-tipus_kulon' => 'lang_text',
        'csatorna_kulon' => 'lang_text',
        'ismerv-tipus_reszletez' => 'lang_text',
        'csatorna_reszletez' => 'lang_text',
        'beolvasas_idk' => 'beolvasas_id_arr',
        'eszkoz_idk' => 'eszkoz_id_arr',
        'ismerv_idk' => 'eszkoz_id_arr',
        'ismerv_sorrend' => 'eszkoz_id_arr',
                'ismerv_sorrend_szoveggel' => 'lang_text'

        //'ismerv_ertekek' => 'ismerv_ertekek_arr'
    );

    public function ajax($params){

        $styleArray2 = [
            'font' => [
                'bold' => true,
            ],
            /*'borders' => [
                'top' => [
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                ],
            ],*/
            
        ];

        $styleArray = [
            'font' => [
                'bold' => true,
                'color' => [
                    'argb' => 'FFFFFF',
                ]
            ],
            'alignment' => [
                'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT,
            ],
            /*'borders' => [
                'top' => [
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                ],
            ],*/
            'fill' => [
                'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                'color' => [
                    'argb' => 'FFA0A0A0',
                ]
            ],
        ];


        $styleArrayCenter = [
            'font' => [
                'bold' => true,
                'color' => [
                    'argb' => 'FFFFFF',
                ]
            ],
            'alignment' => [
                'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
            ],
            /*'borders' => [
                'top' => [
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                ],
            ],*/
            'fill' => [
                'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                'color' => [
                    'argb' => 'FFA0A0A0',
                ]
            ],
        ];

        $styleArrayBodyRight = [
          
            'alignment' => [
                'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT,
            ]
            
        ];

        $styleHeader = [
            'borders' => [
                'top' => [
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                ],
                'bottom' => [
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                ],
            ],
            
        ];

        global $g;

        $ismerv_sorrend = json_decode($params['ismerv_sorrend'], true);
        $beolvasas_idk = json_decode($params['beolvasas_idk'], true);

        $eszkoz_idk = json_decode($params['eszkoz_idk'], true);
        $kerdes_idk = json_decode($params['kerdes_idk'], true);
        $kerdes_idk_szoveggel = json_decode($params['kerdes_idk_szoveggel'], true);


                $ismerv_sorrend_szoveggel = json_decode($params['ismerv_sorrend_szoveggel'], true);


        $jelentesek = [];
        for($k = 0; $k < count($kerdes_idk); $k++) {
            $selectExpand = "";
            $groupByExpand = "";
            $whereExpand = "";
            $joinExpand = "";

            for($i = 1; $i <= count($ismerv_sorrend); $i++) {
                $selectExpand .= ",bsi".$i.".ismerv as ismerv" . $i;
                $groupByExpand .= ",bsi".$i.".ismerv";
                $whereExpand .= " and bsi".$i.".fk_ismervek IN (".$ismerv_sorrend[$i-1].") ";
                $joinExpand .= "\n left join beolvasas_sorok_ismervek bsi".$i."
                on bsi".$i.".fk_beolvasas_sorok = bs.id ";
            }

            $kerdes_jelentes = $g['db_db']->trend_report_automata_riport(
                $kerdes_idk[$k],
                $params['idopont_tol'],
                $params['idopont_ig'],
               // $this->arrEmptyToNullToSelect($ismerv_ertekek),
                [
                    'beolvasas_idk' => $this->strArrToSelect($beolvasas_idk),
                    'eszkoz_idk' => $this->strArrToSelect($eszkoz_idk),
                    //'ismerv_ertekek' => $this->strArrToSelect($ismerv_ertekek)
                    //'ismerv_idk' => $this->strArrToSelect($ismerv_idk),
                    'select_expand' => $selectExpand,
                    'group_by_expand' => $groupByExpand,
                    'where_expand' => $whereExpand,
                    'join_expand' => $joinExpand,
                ]
            );

            array_push($jelentesek, $kerdes_jelentes);
        }

        $out = [
            'echo' => $params['echo'],
            'data' => $jelentesek
        ];

        //return $out;

        $eszkozok = [];
        foreach($eszkoz_idk as $eszkoz_id) {
            $eszkoz = $g["db_db"]->get_eszkoz(
                $eszkoz_id
            );
            $eszkozok[$eszkoz_id] = $eszkoz[0]["nev"];
        }


        $tableRows = 0;

        $spreadsheet = new Spreadsheet();
        $activeWorksheet = $spreadsheet->getActiveSheet();
        $activeWorksheet->setCellValue('A2', "Trend ismérvek szerint");
        //$activeWorksheet->setCellValue('A4', "Kérdőív:");
        //$activeWorksheet->setCellValue('B4', "Mind");
        $activeWorksheet->setCellValue('A4', "Csatorna:");
        $activeWorksheet->setCellValue('B4', implode("; ", $eszkozok) . ($params["csatorna_reszletez"] == "true" ? " részletez" : ""));
        $activeWorksheet->setCellValue('A5', "Ismérv típus");
        $activeWorksheet->setCellValue('B5', implode("; ", $ismerv_sorrend_szoveggel) . ($params["ismerv-tipus_reszletez"] == "true" ? " részletez" : ""));
        $activeWorksheet->setCellValue('A6', "Időszak");
        $activeWorksheet->setCellValue('B6', $params['idopont_tol'] . " - " . $params['idopont_ig']);

        $spreadsheet->getDefaultStyle()->getNumberFormat()->setFormatCode('# ##0');


        $activeWorksheet->getStyle('A2:A6')->applyFromArray($styleArray2);
        $activeWorksheet->getStyle('A2:B6')->applyFromArray($styleHeader);

        array_push($eszkoz_idk, "osszesen");

        $kulon_indexek = [];
        $filenames = [];

        // kerdes_idk[k] = jelentesek[k]
        for($k = 0; $k < count($kerdes_idk); $k++) {
            $mainTable = [];

            $kerdes_szovege = "";
            $kerdes = $g['db_db']->get_kerdes_by_azonosito($kerdes_idk[$k]);
            //if ($kerdes[0]) {
                $kerdes_szovege = $kerdes_idk_szoveggel[$k];
            //}

            $valasz_ertekek = [];
            $ossz_suly = 1;
            $nps = false;
            if (strpos($kerdes[0]["kod"], 'ikonok-5') !== false) {
                $valasz_ertekek = [5, 4, 3, 2, 1];
                $ossz_suly = 15;
            }
            if ($kerdes[0]["kod"] == 'szamok-0-10') {
                $valasz_ertekek = [10, 9, 8, 7, 6, 5, 4, 3, 2, 1];
                $nps = true;
            }
            if ($kerdes[0]["kod"] == 'szamok-1-10') {
                $valasz_ertekek = [10, 9, 8, 7, 6, 5, 4, 3, 2, 1];
                $ossz_suly = 55;
            }
            if ($kerdes[0]["kod"] == 'szamok-1-6') {
                $valasz_ertekek = [6, 5, 4, 3, 2, 1];
                $ossz_suly = 21;
            }
            if ($kerdes[0]["kod"] == 'szamok-1-5') {
                $valasz_ertekek = [5, 4, 3, 2, 1];
                $ossz_suly = 15;
            }
            if (strpos($kerdes[0]["kod"], 'ikonok-4') !== false) {
                $valasz_ertekek = [4, 3, 2, 1];
                $ossz_suly = 10;
            }    
            array_push($valasz_ertekek, "Eredmény", "Válaszok száma");

            $honapok = [];
            foreach($jelentesek[$k] as $adatSor) {
                $honapAzon = $adatSor["ev"] . "-" . $adatSor["honap"];
                if (!in_array($honapAzon, $honapok)) {
                    array_push($honapok, $honapAzon);
                }
            }

            $fejlecSorok = [NULL];
            foreach($honapok as $honapEgyseg) {
                $ev = explode("-", $honapEgyseg)[0];
                $honap = explode("-", $honapEgyseg)[1];
                array_push($fejlecSorok, $ev . ". " . $honap . ". ");
            }

            $mainTable = [$fejlecSorok];


            //return $jelentesek;

             // main table start
            $mainSzamok = [
                
            ];

            foreach($honapok as $honapEgyseg) {
                $ev = explode("-", $honapEgyseg)[0];
                $honap = explode("-", $honapEgyseg)[1];

                foreach($jelentesek[$k] as $adatSor) {
                    if ($adatSor["ev"] == $ev && $adatSor["honap"] == $honap) {
                        $mainSzamok[$adatSor["eszkoz"] . "_" . $honapEgyseg][$adatSor["valasz_sorszam"]] += $adatSor["elofordulas"];
                        $mainSzamok[$adatSor["eszkoz"] . "_" . $honapEgyseg]["Válaszok száma"] += $adatSor["elofordulas"];

                        if ($nps) {
                            if (in_array($adatSor["valasz_sorszam"], array("11", "10"))) {
                                $mainSzamok[$adatSor["eszkoz"] . "_" . $honapEgyseg]["Támogatók"] += $adatSor["elofordulas"];
                            } else if (in_array($adatSor["valasz_sorszam"], array("9", "8"))) {
                                $mainSzamok[$adatSor["eszkoz"] . "_" . $honapEgyseg]["Semlegesek"] += $adatSor["elofordulas"];
                            } else {
                                $mainSzamok[$adatSor["eszkoz"] . "_" . $honapEgyseg]["Hátráltatók"] += $adatSor["elofordulas"];
                            }
                        }
            
                        $mainSzamok["osszesen" . "_" . $honapEgyseg][$adatSor["valasz_sorszam"]] += $adatSor["elofordulas"];
                        $mainSzamok["osszesen" . "_" . $honapEgyseg]["Válaszok száma"] += $adatSor["elofordulas"];

                        if ($nps) {

                            if (in_array($adatSor["valasz_sorszam"], array("11", "10"))) {
                                $mainSzamok["osszesen" . "_" . $honapEgyseg]["Támogatók"] += $adatSor["elofordulas"];
                            } else if (in_array($adatSor["valasz_sorszam"], array("9", "8"))) {
                                $mainSzamok["osszesen" . "_" . $honapEgyseg]["Semlegesek"] += $adatSor["elofordulas"];
                            } else {
                                $mainSzamok["osszesen" . "_" . $honapEgyseg]["Hátráltatók"] += $adatSor["elofordulas"];
                            }

                            $mainSzamok[$adatSor["eszkoz"] . "_" . $honapEgyseg]["Támogatók-szazalek"] = $mainSzamok[$adatSor["eszkoz"] . "_" . $honapEgyseg]["Támogatók"] / ($mainSzamok[$adatSor["eszkoz"] . "_" . $honapEgyseg]["Válaszok száma"]);
                            $mainSzamok["osszesen" . "_" . $honapEgyseg]["Támogatók-szazalek"] = $mainSzamok["osszesen" . "_" . $honapEgyseg]["Támogatók"] / ($mainSzamok["osszesen" . "_" . $honapEgyseg]["Válaszok száma"]);

                            $mainSzamok[$adatSor["eszkoz"] . "_" . $honapEgyseg]["Semlegesek-szazalek"] = $mainSzamok[$adatSor["eszkoz"] . "_" . $honapEgyseg]["Semlegesek"] / ($mainSzamok[$adatSor["eszkoz"] . "_" . $honapEgyseg]["Válaszok száma"]);
                            $mainSzamok["osszesen" . "_" . $honapEgyseg]["Semlegesek-szazalek"] = $mainSzamok["osszesen" . "_" . $honapEgyseg]["Semlegesek"] / ($mainSzamok["osszesen" . "_" . $honapEgyseg]["Válaszok száma"]);

                            $mainSzamok[$adatSor["eszkoz"] . "_" . $honapEgyseg]["Hátráltatók-szazalek"] = $mainSzamok[$adatSor["eszkoz"] . "_" . $honapEgyseg]["Hátráltatók"] / ($mainSzamok[$adatSor["eszkoz"] . "_" . $honapEgyseg]["Válaszok száma"]);
                            $mainSzamok["osszesen" . "_" . $honapEgyseg]["Hátráltatók-szazalek"] = $mainSzamok["osszesen" . "_" . $honapEgyseg]["Hátráltatók"] / ($mainSzamok["osszesen" . "_" . $honapEgyseg]["Válaszok száma"]);

                            $mainSzamok[$adatSor["eszkoz"] . "_" . $honapEgyseg]["NPS"] = $mainSzamok[$adatSor["eszkoz"] . "_" . $honapEgyseg]["Támogatók-szazalek"] - ($mainSzamok[$adatSor["eszkoz"] . "_" . $honapEgyseg]["Hátráltatók-szazalek"]);
                            $mainSzamok["osszesen" . "_" . $honapEgyseg]["NPS"] = $mainSzamok["osszesen" . "_" . $honapEgyseg]["Támogatók-szazalek"] - ($mainSzamok["osszesen" . "_" . $honapEgyseg]["Hátráltatók-szazalek"]);

                        }
                    }
                }
            }

            foreach($eszkoz_idk as $eszkoz_id) {
                if ($eszkoz_id == "osszesen") {
                    $eszkoz_sor = ["Összesen:"];
                } else {
                    $eszkoz_sor = [$eszkozok[$eszkoz_id]];
                }

                foreach($honapok as $honapEgyseg) {
                    $ev = explode("-", $honapEgyseg)[0];
                    $honap = explode("-", $honapEgyseg)[1];
                    
                    if ($nps) {
                        foreach(array("NPS") as $valasz_ertek) {
                            if ($mainSzamok[$eszkoz_id  . "_" . $honapEgyseg][$valasz_ertek]) {
                                array_push($eszkoz_sor, $mainSzamok[$eszkoz_id  . "_" . $honapEgyseg][$valasz_ertek]);
                            } else {
                                array_push($eszkoz_sor, 0);
                            }
                        }
                    } else {
                        $sulyhozSzamlalo = 0;
                        foreach($valasz_ertekek as $valasz_ertek) {
                            if ($mainSzamok[$eszkoz_id  . "_" . $honapEgyseg]["Válaszok száma"] != 0) {
                                if ($valasz_ertek >= 0 && $valasz_ertek <= 11) $sulyhozSzamlalo += floatval($mainSzamok[$eszkoz_id  . "_" . $honapEgyseg][$valasz_ertek]) * (floatval($valasz_ertek) * 25 - 25);

                            }
                            if ($valasz_ertek === "Válaszok száma") {
                                /*if ($mainSzamok[$eszkoz_id]["Válaszok száma"] == 0) {
                                    array_push($eszkoz_sor, 0);
                                } else {
                                    array_push($eszkoz_sor, $mainSzamok[$eszkoz_id]["Válaszok száma"]);
                                }*/
                                continue;
                            } 
                            if ($valasz_ertek === "Eredmény") {
                                if ($sulyhozSzamlalo == 0) {
                                    array_push($eszkoz_sor, 0);
                                    continue;
                                }
                                array_push($eszkoz_sor, $sulyhozSzamlalo / $mainSzamok[$eszkoz_id  . "_" . $honapEgyseg]["Válaszok száma"] / 100);
                                continue;
                            }
                            if ($mainSzamok[$eszkoz_id]["Válaszok száma"] == 0) {
                                //array_push($eszkoz_sor, 0);
                            } else {
                                //array_push($eszkoz_sor, $mainSzamok[$eszkoz_id][$valasz_ertek] / $mainSzamok[$eszkoz_id]["Válaszok száma"]);
                            }
                            
                        }
                    }
                }

                array_push($mainTable, $eszkoz_sor);
            }

            if ($params["ismerv-tipus_kulon"] != "true" && $params["csatorna_kulon"] != "true") {
                $activeWorksheet->getCell('A' . ((11 + $tableRows) +2))->setValue($kerdes_szovege . ($nps ? " (NPS)" : ""))  ;
                $activeWorksheet->getStyle('A' . ((11 + $tableRows) +2))->applyFromArray($styleArray2);
                $activeWorksheet->fromArray(
                    $mainTable,  // The data to set
                    NULL,        // Array values with this value will not be set
                    'A' . ((11 + $tableRows) +3),        // Top left coordinate of the worksheet range where
                    true          //    we want to set these values (default is A1)
                );

                $activeWorksheet->getStyle(('B' . ((11 + $tableRows) +3)) . ":" . $this->numToChar(count($mainTable[0])-1) . ((11 + $tableRows) +3))->applyFromArray($styleArrayCenter);

                $activeWorksheet->getStyle(('A' . ((11 + $tableRows) +3)) )->applyFromArray($styleArray);
                $activeWorksheet->getStyle(('A' . (((11 + $tableRows) +2) + count($mainTable))) . ":" . ($this->numToChar(count($mainTable[0])-1)) . (((11 + $tableRows) +2) + count($mainTable)) )->applyFromArray($styleArray2);


                $activeWorksheet->getStyle($this->numToChar(1). ((11 + $tableRows) +4) . ":" . $this->numToChar(count($mainTable[0])-1) . ((11 + $tableRows) +2 + count($mainTable)))->getNumberFormat()->setFormatCode(
                    \PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_PERCENTAGE_00
                );
                $activeWorksheet->getStyle($this->numToChar(1). ((11 + $tableRows) +4) . ":" . $this->numToChar(count($mainTable[0])-1) . ((11 + $tableRows) +2 + count($mainTable)))->applyFromArray($styleArrayBodyRight);
                $activeWorksheet->getStyle($this->numToChar(1). ((11 + $tableRows) +4) . ":" . $this->numToChar(count($mainTable[0])-1) . ((11 + $tableRows) +2 + count($mainTable)))->getNumberFormat()->setFormatCode('0.0%');

                $tableRows += count($mainTable) +3;
            }

            // main table end

            // ismerv table start
            $csatornaIterate = $params["csatorna_reszletez"] == "true" ? (count($eszkoz_idk)-1) : 1;
            for($csatornaIndex = 0; $csatornaIndex < $csatornaIterate; $csatornaIndex++) {
                $upperLevel_ismerv_ertekek = [null, null];
                $csatornaZeroRows = $tableRows + 10;
                for($ismerv_table_level = 1; $ismerv_table_level <= count($ismerv_sorrend); $ismerv_table_level++) {
                    $iterates = $params["ismerv-tipus_reszletez"] == "true" ? count($upperLevel_ismerv_ertekek)-1 : 1;
                    for($upperLevelIndex = 0; $upperLevelIndex < $iterates; $upperLevelIndex++) {

                        $ismervAzon = "ismerv" . $ismerv_table_level;
                        $ismerv_ertekek = [];
                        foreach($jelentesek[$k] as $adatSor) {
                            if (!in_array($adatSor[$ismervAzon], $ismerv_ertekek)) {
                                array_push($ismerv_ertekek, $adatSor[$ismervAzon]);
                            }
                        }
                        
                        $ismervSzamok = [];
                        foreach($honapok as $honapEgyseg) {
                            $ev = explode("-", $honapEgyseg)[0];
                            $honap = explode("-", $honapEgyseg)[1];
                            foreach($jelentesek[$k] as $adatSor) {
                                if ($adatSor["ev"] == $ev && $adatSor["honap"] == $honap) {
                                    if (($params["csatorna_reszletez"] == "true" && $adatSor["eszkoz"] == $eszkoz_idk[$csatornaIndex]) || $params["csatorna_reszletez"] == "false") {
                                        $ismervSzamok[$adatSor[$ismervAzon] . "_" . $honapEgyseg][$adatSor["valasz_sorszam"]] += $adatSor["elofordulas"];
                                        $ismervSzamok[$adatSor[$ismervAzon] . "_" . $honapEgyseg]["upperLevelIsmerv"] = $adatSor["ismerv" . ($ismerv_table_level -1)];
                                        $ismervSzamok[$adatSor[$ismervAzon] . "_" . $honapEgyseg]["Válaszok száma"] += $adatSor["elofordulas"];

                                        if ($nps) {
                                            if (in_array($adatSor["valasz_sorszam"], array("11", "10"))) {
                                                $ismervSzamok[$adatSor[$ismervAzon] . "_" . $honapEgyseg]["Támogatók"] += $adatSor["elofordulas"];
                                            } else if (in_array($adatSor["valasz_sorszam"], array("9", "8"))) {
                                                $ismervSzamok[$adatSor[$ismervAzon] . "_" . $honapEgyseg]["Semlegesek"] += $adatSor["elofordulas"];
                                            } else {
                                                $ismervSzamok[$adatSor[$ismervAzon] . "_" . $honapEgyseg]["Hátráltatók"] += $adatSor["elofordulas"];
                                            }
                                        }

                                        if (($params["ismerv-tipus_reszletez"] == "true" && $adatSor["ismerv" . ($ismerv_table_level -1)] == $upperLevel_ismerv_ertekek[$upperLevelIndex]) || $params["ismerv-tipus_reszletez"] == "false") {

                                            $ismervSzamok["osszesen". "_" . $honapEgyseg][$adatSor["valasz_sorszam"]] += $adatSor["elofordulas"];
                                            $ismervSzamok["osszesen". "_" . $honapEgyseg]["upperLevelIsmerv"] = $adatSor["ismerv" . ($ismerv_table_level -1)];
                                            $ismervSzamok["osszesen". "_" . $honapEgyseg]["Válaszok száma"] += $adatSor["elofordulas"];

                                            if ($nps) {
                                                if (in_array($adatSor["valasz_sorszam"], array("11", "10"))) {                                            
                                                    $ismervSzamok["osszesen". "_" . $honapEgyseg]["Támogatók"] += $adatSor["elofordulas"];
                                                } else if (in_array($adatSor["valasz_sorszam"], array("9", "8"))) {    
                                                    $ismervSzamok["osszesen". "_" . $honapEgyseg]["Semlegesek"] += $adatSor["elofordulas"];
                                                } else {    
                                                    $ismervSzamok["osszesen". "_" . $honapEgyseg]["Hátráltatók"] += $adatSor["elofordulas"];
                                                }

                                                $ismervSzamok[$adatSor[$ismervAzon] . "_" . $honapEgyseg]["Támogatók-szazalek"] = $ismervSzamok[$adatSor[$ismervAzon] . "_" . $honapEgyseg]["Támogatók"] / ($ismervSzamok[$adatSor[$ismervAzon] . "_" . $honapEgyseg]["Válaszok száma"]); 
                                                $ismervSzamok["osszesen". "_" . $honapEgyseg]["Támogatók-szazalek"] = $ismervSzamok["osszesen". "_" . $honapEgyseg]["Támogatók"] / ($ismervSzamok["osszesen". "_" . $honapEgyseg]["Válaszok száma"]);

                                                $ismervSzamok[$adatSor[$ismervAzon] . "_" . $honapEgyseg]["Semlegesek-szazalek"] = $ismervSzamok[$adatSor[$ismervAzon] . "_" . $honapEgyseg]["Semlegesek"] / ($ismervSzamok[$adatSor[$ismervAzon] . "_" . $honapEgyseg]["Válaszok száma"]);
                                                $ismervSzamok["osszesen". "_" . $honapEgyseg]["Semlegesek-szazalek"] = $ismervSzamok["osszesen". "_" . $honapEgyseg]["Semlegesek"] / ($ismervSzamok["osszesen". "_" . $honapEgyseg]["Válaszok száma"]);

                                                $ismervSzamok[$adatSor[$ismervAzon] . "_" . $honapEgyseg]["Hátráltatók-szazalek"] = $ismervSzamok[$adatSor[$ismervAzon] . "_" . $honapEgyseg]["Hátráltatók"] / ($ismervSzamok[$adatSor[$ismervAzon] . "_" . $honapEgyseg]["Válaszok száma"]);
                                                $ismervSzamok["osszesen". "_" . $honapEgyseg]["Hátráltatók-szazalek"] = $ismervSzamok["osszesen". "_" . $honapEgyseg]["Hátráltatók"] / ($ismervSzamok["osszesen". "_" . $honapEgyseg]["Válaszok száma"]);
                                                
                                                $ismervSzamok[$adatSor[$ismervAzon] . "_" . $honapEgyseg]["NPS"] = $ismervSzamok[$adatSor[$ismervAzon] . "_" . $honapEgyseg]["Támogatók-szazalek"] - ($ismervSzamok[$adatSor[$ismervAzon] . "_" . $honapEgyseg]["Hátráltatók-szazalek"]);
                                                $ismervSzamok["osszesen". "_" . $honapEgyseg]["NPS"] = $ismervSzamok["osszesen". "_" . $honapEgyseg]["Támogatók-szazalek"] - ($ismervSzamok["osszesen". "_" . $honapEgyseg]["Hátráltatók-szazalek"]);

                                            }
                                        }
                                    }
                                }

                            }
                        }

                        array_push($out, $ismervSzamok);

                        if ($params["csatorna_reszletez"] != "true") {
                            $fejlecSorok[0] = implode("; ", $eszkozok);
                        } else {
                            $fejlecSorok[0] = $eszkozok[$eszkoz_idk[$csatornaIndex]];
                        }
                        $ismervTable = [$fejlecSorok];

                        array_push($ismerv_ertekek, "osszesen");
                        foreach($ismerv_ertekek as $ismerv_ertek) {
                            $ismerv_sor = [$ismerv_ertek];
                            if ($ismerv_sor[0] == "osszesen" && $params["ismerv-tipus_reszletez"] == "true") {
                            $ismerv_sor[0] = $upperLevel_ismerv_ertekek[$upperLevelIndex] . " Összesen:";
                            } else if ($ismerv_sor[0] == "osszesen") {
                                $ismerv_sor[0] = "Összesen:";
                            }
                            
                            $reszletezMatch = false;
                            foreach($honapok as $honapEgyseg) {
                                $ev = explode("-", $honapEgyseg)[0];
                                $honap = explode("-", $honapEgyseg)[1];

                                if ($nps) {
                                    $reszletezMatch = false;
                                    if ($params["ismerv-tipus_reszletez"] == "false") {
                                        $reszletezMatch = true;
                                    }
                                    foreach(array("NPS") as $valasz_ertek) {
                                        if ($params["ismerv-tipus_reszletez"] == "true" && $upperLevel_ismerv_ertekek[$upperLevelIndex] == $ismervSzamok[$ismerv_ertek . "_" . $honapEgyseg]["upperLevelIsmerv"] || $ismerv_ertek == "osszesen" || $params["ismerv-tipus_reszletez"] == "false") {
                                            array_push($ismerv_sor, $ismervSzamok[$ismerv_ertek . "_" . $honapEgyseg][$valasz_ertek]);
                                            $reszletezMatch = true;
                                        } else {
                                            array_push($ismerv_sor, 0);
                                            $reszletezMatch = true;
                                        }
                                    }

                                } else {
                                    $reszletezMatch = false;
                                    if ($params["ismerv-tipus_reszletez"] == "false") {
                                        $reszletezMatch = true;
                                    }
                                    $sulyhozSzamlalo = 0;
                                    if (empty($ismervSzamok[$ismerv_ertek . "_" . $honapEgyseg]) == true) {
                                        array_push($ismerv_sor, "N/A");
                                        $reszletezMatch = true;
                                        continue;
                                    }
                                    foreach($valasz_ertekek as $valasz_ertek) {
                                        if ($params["ismerv-tipus_reszletez"] == "true" && $upperLevel_ismerv_ertekek[$upperLevelIndex] == $ismervSzamok[$ismerv_ertek . "_" . $honapEgyseg]["upperLevelIsmerv"] || $ismerv_ertek == "osszesen" || $params["ismerv-tipus_reszletez"] == "false") {
                                            
                                            if ($ismervSzamok[$ismerv_ertek . "_" . $honapEgyseg]["Válaszok száma"] != 0) {
                                                if ($valasz_ertek >= 0 && $valasz_ertek <= 11) $sulyhozSzamlalo += floatval($ismervSzamok[$ismerv_ertek . "_" . $honapEgyseg][$valasz_ertek]) * (floatval($valasz_ertek) * 25 - 25);
                                            }
                                            if ($valasz_ertek == "Eredmény") {
                                                if ($sulyhozSzamlalo == 0) {
                                                    array_push($ismerv_sor, 0);
                                                    $reszletezMatch = true;
                                                    break;
                                                }
                                                array_push($ismerv_sor, $sulyhozSzamlalo / $ismervSzamok[$ismerv_ertek . "_" . $honapEgyseg]["Válaszok száma"] / 100);
                                                $reszletezMatch = true;
                                                break;
                                            }
                                            //array_push($ismerv_sor, $ismervSzamok[$ismerv_ertek . "_" . $honapEgyseg][$valasz_ertek]);
                                            //$reszletezMatch = true;
                                        } else {
                                            array_push($ismerv_sor, 0);
                                            $reszletezMatch = true;
                                            break;
                                        }
                                    }
                                }
                            }

                            if ($reszletezMatch && $this->arrayContainsNonZeroElements(array_slice($ismerv_sor, 1))) {
                                array_push($ismervTable, $ismerv_sor);
                            }
                        }


                        $activeWorksheet->getCell('A' . ((11 + $tableRows) +2))->setValue($kerdes_szovege . ($nps ? " (NPS)" : ""));

                        $activeWorksheet->getStyle('A' . ((11 + $tableRows) +2))->applyFromArray($styleArray2);


                        $activeWorksheet->getStyle(('B' . ((11 + $tableRows) +3)) . ":" . $this->numToChar(count($ismervTable[0])-1) . ((11 + $tableRows) +3))->applyFromArray($styleArrayCenter);
                        $activeWorksheet->getStyle(('A' . ((11 + $tableRows) +3)))->applyFromArray($styleArray);

                        $activeWorksheet->getStyle(('A' . (((11 + $tableRows) +2) + count($ismervTable))) . ":" . ($this->numToChar(count($ismervTable[0])-1)) . (((11 + $tableRows) +2) + count($ismervTable)) )->applyFromArray($styleArray2);


                        $activeWorksheet->getStyle($this->numToChar(1). ((11 + $tableRows) +4) . ":" . $this->numToChar(count($ismervTable[0])-1) . ((11 + $tableRows) +3 + count($ismervTable)))->getNumberFormat()->setFormatCode(
                            \PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_PERCENTAGE_00
                        );
                        $activeWorksheet->getStyle($this->numToChar(1). ((11 + $tableRows) +4) . ":" . $this->numToChar(count($ismervTable[0])-1) . ((11 + $tableRows) +3 + count($ismervTable)))->applyFromArray($styleArrayBodyRight);
                        $activeWorksheet->getStyle($this->numToChar(1). ((11 + $tableRows) +4) . ":" . $this->numToChar(count($ismervTable[0])-1) . ((11 + $tableRows) +3 + count($ismervTable)))->getNumberFormat()->setFormatCode('0.0%');



                        $activeWorksheet->fromArray(
                            $ismervTable,  // The data to set
                            NULL,        // Array values with this value will not be set
                            'A' . ((11 + $tableRows) +3),        // Top left coordinate of the worksheet range where
                            true          //    we want to set these values (default is A1)
                        );

                        $tableRows += count($ismervTable) +3;

                        // ISMERV TABLE VEGE

                        if ($params["ismerv-tipus_kulon"] == "true") {
                            $temp_eszkoz = "";
                            if ($params["csatorna_kulon"] == "true") {
                                $temp_eszkoz = $eszkozok[$eszkoz_idk[$csatornaIndex]];
                            }
                            $temp_ismerv = $upperLevel_ismerv_ertekek[$upperLevelIndex];
                            array_push($kulon_indexek, array(
                                "id" => $upperLevel_ismerv_ertekek[$upperLevelIndex] . ".-." .  $temp_eszkoz . ".-." . $k,
                                "row_from" => $tableRows - count($ismervTable) +8,
                                "row_to" => $tableRows + 10
                            ));
                        }
                    }

                    $upperLevel_ismerv_ertekek = $ismerv_ertekek;

                }

                // CSATORNA VEGE
                if ($params["csatorna_kulon"] == "true" && $params["ismerv-tipus_kulon"] != "true") {
                    $temp_eszkoz = $eszkozok[$eszkoz_idk[$csatornaIndex]];
                    array_push($kulon_indexek, array(
                        "id" => "???" . ".-." .$temp_eszkoz . ".-." . $k,
                        "row_from" => $csatornaZeroRows + 1,
                        "row_to" => $tableRows + 10
                    ));
                }
            }


            // ismerv table end
            
        }

        if ($params["ismerv-tipus_kulon"] == "true" || $params["csatorna_kulon"] == "true") {
            $sheet_letrehozva = [];
            foreach($kulon_indexek as $kulon_index) {
                $kulon_index_parts = explode(".-.", $kulon_index["id"]);
                $ismerv = $kulon_index_parts[0];
                $csatorna = $kulon_index_parts[1];
                $kerdes = $kulon_index_parts[2];
                if (!in_array($ismerv . $csatorna, $sheet_letrehozva)) {
                    array_push($sheet_letrehozva, $ismerv . $csatorna);
                    $clonedSpreadsheet = clone $spreadsheet;

                    $overall_minus = 0;
                    for($ki2 = count($kulon_indexek) -1; $ki2 >= 0; $ki2--) {
                        $kulon_index2 = $kulon_indexek[$ki2];
                        $kulon_index_parts2 = explode(".-.", $kulon_index2["id"]);
                        $ismerv2 = $kulon_index_parts2[0];
                        $csatorna2 = $kulon_index_parts2[1];
                        $kerdes2 = $kulon_index_parts2[2];

                        if ($params["ismerv-tipus_kulon"] == "true" && $params["csatorna_kulon"] == "true" && ($ismerv !== $ismerv2 || $csatorna !== $csatorna2)) {
                            $clonedSpreadsheet->getActiveSheet()->removeRow($kulon_index2["row_from"], $kulon_index2["row_to"] - $kulon_index2["row_from"] + 1);                                
                        }
                        if ($params["ismerv-tipus_kulon"] == "true" && $params["csatorna_kulon"] != "true" && $ismerv !== $ismerv2 || $params["csatorna_kulon"] == "true" && $params["ismerv-tipus_kulon"] != "true" && $csatorna !== $csatorna2) {
                            $clonedSpreadsheet->getActiveSheet()->removeRow($kulon_index2["row_from"], $kulon_index2["row_to"] - $kulon_index2["row_from"] + 1);                                
                        }
                    }

                    if (($params["ismerv-tipus_kulon"] == "true" && $ismerv != "???" && $ismerv != "") || $params["ismerv-tipus_kulon"] != "true") {
                        if ($ismerv === "???") $ismerv = "";
                        $clonedSpreadsheet->getActiveSheet()->setCellValue('B4', $csatorna);
                        $writer = new Xlsx($clonedSpreadsheet);
                        $timestamp = (strpos($params["idopont_tol"], "1999") !== false  ? "" : $params["idopont_tol"]) . "-" . $params["idopont_ig"];
                        $filename = "trend".$params["partner_nev"].$timestamp.$ismerv.$csatorna.'.xlsx';
                        $writer->save($filename);
                        array_push($filenames, $filename);
                    }
                    //return;
                }

            }
        }

        foreach(range('A','ZZ') as $columnID) {
            $spreadsheet->getActiveSheet()->getColumnDimension($columnID)
                ->setWidth(15, 'pt');;
        }

        $writer = new Xlsx($spreadsheet);
        $timestamp = (strpos($params["idopont_tol"], "1999") !== false ? "" : $params["idopont_tol"]) . "-" . $params["idopont_ig"];
        $writer->save('trend'.$params["partner_nev"].$timestamp.'.xlsx');

        if ($params["csatorna_kulon"] == "true" || $params["ismerv-tipus_kulon"] == "true") {
            $timestamp = (strpos($params["idopont_tol"], "1999") !== false ? "" : $params["idopont_tol"]) . "-" . $params["idopont_ig"];
            unlink('trend'.$params["partner_nev"].$timestamp.'.zip');

            $zip = new \ZipArchive();
            $zipname = 'trend'.$params["partner_nev"].$timestamp.'.zip';

            if ($zip->open($zipname, \ZipArchive::CREATE) === TRUE) {
                foreach ($filenames as $filename) {
                    if(file_exists($filename)) {
                        $zip->addFile($filename);
                    } else {
                    }
                }
                $zip->close();
                return 'trend'.$params["partner_nev"].$timestamp.'.zip';
        }
        }

        return 'trend'.$params["partner_nev"].$timestamp.'.xlsx';



    }

    private function arrToSelect(array $arr) {
        return empty($arr) ? '(1)' : '(' . implode(',', $arr) . ')';
    }

    private function strArrToSelect(array $arr) {
        return empty($arr) ? '(1)' : '("' . implode('","', $arr) . '")';
    }

    private function varEmptyToNullToSelect($var) {
        return empty($var) ? null : $var;
    }

    private function arrEmptyToNullToSelect(array $arr) {
        return empty($arr) ? null : 1;
    }

    private function arrayContainsNonZeroElements($array) {
        foreach ($array as $element) {
            if ($element !== 0) {
                return true;
            }
        }
        return false;
    }

    private function numToChar($n) {
        $alphabet = range('A', 'Z');
        $result = '';
    
        do {
            $remainder = $n % 26;
            $result = $alphabet[$remainder] . $result;
            $n = intval($n / 26) - 1;
        } while ($n >= 0);
    
        return $result;
    }

    

}