<?php

    namespace A;

    use PhpOffice\PhpSpreadsheet\IOFactory;
    use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
    use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;
    use PhpOffice\PhpSpreadsheet\Cell\DataValidation;

    class tomeges_import extends \GI\Ajax{

        public $rights_required = array(
            'tomeges_kikuldes'
        );

        public $parameters = array(
            'ismerv_csoport_id' => 'ex-ismerv_csoportok-id',
            'partner_id' => 'ex-partnerek-id',
            'nev' => 'beolvasas_nev'
        );

        public function ajax($params){

            global $g;

            if (!isset($_FILES['file']['tmp_name'])) {
                return ['HI', 'nincs_fajl'];
            }

            if ($_FILES['file']['error'] !== UPLOAD_ERR_OK) {
                return ['HI', 'hibas_feltoltes'];
            }

            $g['db_db']->beolvasas_new(
                $params['nev'],
                $params['ismerv_csoport_id'],
                $params['partner_id']
            );

            $beolvasasId = $g['db_db']->get_max_beolvasas_id()[0]['max_id'];

            $ismervek = $g['db_db']->ismervek_sel(
                $params['ismerv_csoport_id']
            );

            $filename = $_FILES['file']['tmp_name'];

            $spreadsheet = IOFactory::load($filename);
            $sheet = $spreadsheet->getSheet(0);

            $i = 2;
            while (!empty($userId = $sheet->getCell("A$i")->getValue())) {
                $userEmail = $sheet->getCell("B$i")->getValue();
                
                $g['db_db']->beolvasas_sor_new(
                    $userId,
                    $userEmail,
                    $beolvasasId
                );

                $beolvasasSorId = $g['db_db']->get_max_beolvasas_sor_id()[0]['max_id'];

                $col = "C";

                foreach ($ismervek as $ismerv) {
                    $ismervVal = $sheet->getCell($col.$i)->getValue();

                    $g['db_db']->beolvasas_sor_ismerv_new(
                        $beolvasasSorId,
                        $ismerv['id'],
                        $ismervVal
                    );

                    $col++;
                }

                ++$i;
            }
        }

    }
