<?php

    namespace A;

    class telephelyek_mod extends \GI\Ajax{

        public $rights_required = array(
            'telephelyek_modositasa'
        );

        public $parameters = array(
            'telephely_sn' => 'ex-telephelyek-id',
            'parameter_nev' => 'parameter_nev',
            'parameter_ertek' => 'ok'
        );

        public function ajax($params){

            global $g;

            // jog ellenorzes
            if(!\UserFunctions::kezelheto_entitas_e($_SESSION['user']['id'], 'telephely', 'telephelyek_modositasa', $params['telephely_sn'])){
                return ['HI', 'right_error'];
            }

            // parameter ellenorzese
            $kapcsoloTabla = [
                'nev' => ['telephely_nev', 'nev'],
                'email' => ['telephely_email', 'email'],
                'telefon' => ['telefon_o', 'telefon'],
                'kapcs_neve' => ['telephely_kapcs_neve', 'kapcs_neve'],
                'orszag_sn' => ['ex-orszagok-ctr_id', 'fk_orszag'],
                'iranyitoszam' => ['iranyitoszam', 'iranyitoszam'],
                'telepules' => ['telephely_telepules', 'telepules'],
                'cim' => ['telephely_cim', 'cim'],
                'megjegyzes' => ['telephely_megjegyzes', 'megjegyzes']
            ];

            if (!array_key_exists($params['parameter_nev'], $kapcsoloTabla)) {
                return ['HI', 'rossz_parameter_nev'];
            }

            if (!\GI\Functions::validate($params['parameter_ertek'], $kapcsoloTabla[$params['parameter_nev']][0])) {
                return ['HI', 'rossz_parameter_ertek'];
            }

            $g['db_db']->telephelyek_mod(
                $params['parameter_ertek'],
                $params['telephely_sn'],
                ['col' => $kapcsoloTabla[$params['parameter_nev']][1]]
            );

        }

    }
