<?php

    namespace A;

    use PhpOffice\PhpSpreadsheet\IOFactory;
    use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
    use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;
    use PhpOffice\PhpSpreadsheet\Cell\DataValidation;

    class telephelyek_import extends \GI\Ajax{

        public $rights_required = array(
            'telephely_import'
        );

        public $parameters = array(

        );

        public function ajax($params){

            global $g;

            if (!isset($_FILES['file']['tmp_name'])) {
                return ['HI', 'nincs_fajl'];
            }

            if ($_FILES['file']['error'] !== UPLOAD_ERR_OK) {
                return ['HI', 'hibas_feltoltes'];
            }

            $filename = $_FILES['file']['tmp_name'];

            $spreadsheet = IOFactory::load($filename);

            $sheet = $spreadsheet->getSheet(0);

            $ujTelephelyek = [];
            $i = 2;
            while (!empty($name = $sheet->getCell("A$i")->getValue())) {
                $ujTelephelyek []= [
                    'nev' => $name,
                    'partner_nev' => $sheet->getCell("B$i")->getValue(),
                    'orszag_nev' => $sheet->getCell("C$i")->getValue(),
                    'iranyitoszam' => $sheet->getCell("D$i")->getValue(),
                    'telepules' => $sheet->getCell("E$i")->getValue(),
                    'cim' => $sheet->getCell("F$i")->getValue(),
                    'kapcs_nev' => $sheet->getCell("G$i")->getValue(),
                    'email' => $sheet->getCell("H$i")->getValue(),
                    'telefon' => $sheet->getCell("I$i")->getValue(),
                    'megjegyzes' => $sheet->getCell("J$i")->getValue()
                ];
                ++$i;
            }

            $res = [];
            foreach ($ujTelephelyek as $k => $telephely) {
                try {
                    // telephely letrehozas
                    $g['db_db']->import_telephely_new(
                        $telephely['nev'],
                        $telephely['partner_nev'],
                        $telephely['orszag_nev'],
                        $telephely['iranyitoszam'],
                        $telephely['telepules'],
                        $telephely['cim'],
                        $telephely['kapcs_nev'],
                        $telephely['email'],
                        $telephely['telefon'],
                        $telephely['megjegyzes'],
                        $_SESSION['user']['id']
                    );
                    $res[$k] = 1;
                } catch (\Exception $ex) {
                    $res[$k] = 0;
                }

            }

            return ['OK', $res];

        }

    }
