<?php

    namespace A;

    class partnerek_mod extends \GI\Ajax{

        public $rights_required = array(
            'partnerek_modositasa'
        );

        public $parameters = array(
            'partner_sn' => 'ex-partnerek-id',
            'parameter_nev' => 'parameter_nev',
            'parameter_ertek' => 'ok'
        );

        public function ajax($params){

            global $g;

            // jog ellenorzes
            if(!\UserFunctions::kezelheto_entitas_e($_SESSION['user']['id'], 'partner', 'partnerek_modositasa', $params['partner_sn'])){
                return ['HI', 'right_error'];
            }

            $kapcsoloTabla = [
                'nev' => ['partner_nev', 'nev'],
                'email' => ['partner_email', 'email'],
                'telefon' => ['telefon_o', 'telefon'],
                'adoszam' => ['ok', 'adoszam'],
                'szekhely_orszag_sn' => ['ex-orszagok-ctr_id', 'fk_szekhely_orszag'],
                'szekhely_iranyitoszam' => ['iranyitoszam', 'szekhely_iranyitoszam'],
                'szekhely_telepules' => ['partner_telepules', 'szekhely_telepules'],
                'szekhely_cim' => ['partner_cim', 'szekhely_address'],
                'email_kuldo_neve' => ['nev', 'email_kuldo_neve'],
                'email_kuldo_email_cime' => ['email', 'email_kuldo_email_cime']
            ];

            if (!array_key_exists($params['parameter_nev'], $kapcsoloTabla)) {
                return ['HI', 'rossz_parameter_nev'];
            }

            if (!\GI\Functions::validate($params['parameter_ertek'], $kapcsoloTabla[$params['parameter_nev']][0])) {
                return ['HI', 'rossz_parameter_ertek'];
            }

            $g['db_db']->partnerek_mod(
                $params['parameter_ertek'],
                $params['partner_sn'],
                ['col' => $kapcsoloTabla[$params['parameter_nev']][1]]
            );

        }

    }
