<?php

    namespace A;

    class jogcsoportok_jogok_hozzarendelese extends \GI\Ajax{

        public $rights_required = array(
            'jogcsoportok_kezelese'
        );

        public $parameters = array(
            'jogcsoport_sn' => 'ex-jogcsoportok-id',
            'jogstruktura' => 'jogstruktura'
        );

        public function ajax($params){

            global $g;

            // ellenorizni hogy a sajat jogcsoportja-e
            if ($g['db_db']->is_sajat_jogcsoport($params['jogcsoport_sn'], $_SESSION['user']['id'])[0]['cnt'] == '0') {
                return ['HI', 'nem_sajat_jogcsoport'];
            }

            // ellenorizni hogy a jogstrukturaban jo elemi jogok vannak-e
            $jogstruktura = json_decode($params['jogstruktura'], true);
            foreach ($jogstruktura as $jog) {
                if (!in_array($jog['elemi_jog_kod'], $g['jogok'])) {
                    return ['HI', 'nem_letezo_elemi_jog', $jog['elemi_jog_kod']];
                }
            }

            // hozzaadasok es torlesek elvegzese
            foreach ($jogstruktura as $jog) {
                if ($jog['hozzaadas']) {
                    $g['db_db']->add_jog_to_jogcsoport($params['jogcsoport_sn'], $jog['elemi_jog_kod']);
                } else {
                    $g['db_db']->del_jog_from_jogcsoport($params['jogcsoport_sn'], $jog['elemi_jog_kod']);
                }
            }

        }

    }
