<?php

namespace A;

class jelentesek_sel_osszevont_telephely extends \GI\Ajax{

    public $rights_required = array(
        'jelentesek_megtekintese'
    );

    public $parameters = array(
        'echo' => 'int',
        'idopont_tol' => 'idopont_o',
        'idopont_ig' => 'idopont',
        'kerdoiv_id' => 'ex-kerdoivek-id',
        'telephely_id' => 'ex-telephelyek-id',
    );

    public function ajax($params){

        global $g;

        $kerdes_idk = $g['db_db']->get_kerdes_idk_of_kerdoiv(
            $params['kerdoiv_id']
        );
        $kerdes_idk = array_column($kerdes_idk, 'id');

        $jelentesek = $g['db_db']->jelentesek_sel_osszevont_telephely(
            $params['telephely_id'],
            $params['idopont_ig'],
            $params['idopont_tol'],
            $this->arrEmptyToNullToSelect($kerdes_idk),
            [
                'kerdes_idk' => $this->arrToSelect($kerdes_idk),
            ]
        );

        $out = [
            'echo' => $params['echo'],
            'data' => $jelentesek
        ];

        return $out;

    }

    private function arrToSelect(array $arr) {
        return empty($arr) ? '(1)' : '(' . implode(',', $arr) . ')';
    }

    private function varEmptyToNullToSelect($var) {
        return empty($var) ? null : $var;
    }

    private function arrEmptyToNullToSelect(array $arr) {
        return empty($arr) ? null : 1;
    }

}
