<?php

    namespace A;

    class jelentesek_sel_nyers_adatok extends \GI\Ajax{

        public $rights_required = array(
            'jelentesek_megtekintese'
        );


        public $parameters = array(
            'echo' => 'int',
            'idopont_tol' => 'idopont_o',
            'idopont_ig' => 'idopont',
            'talalat_tol' => 'int',
            'talalat_darab' => 'int',
            'kerdoiv_idk' => 'kerdoiv_id_arr',
            'partner_idk' => 'partner_id_arr',
            'telephely_idk' => 'telephely_id_arr',
            'eszkoz_idk' => 'eszkoz_id_arr'
        );

        public function ajax($params){

            global $g;

            ini_set('memory_limit', '1G');

            $kerdoiv_idk = json_decode($params['kerdoiv_idk'], true);
            $partner_idk = json_decode($params['partner_idk'], true);
            $telephely_idk = json_decode($params['telephely_idk'], true);
            $eszkoz_idk = json_decode($params['eszkoz_idk'], true);

            // jelentesek lekerdezese
            $attr = [
                $params['idopont_ig'],
                $params['idopont_tol'],
                $this->arrEmptyToNullToSelect($kerdoiv_idk),
                $this->arrEmptyToNullToSelect($partner_idk),
                $this->arrEmptyToNullToSelect($telephely_idk),
                $this->arrEmptyToNullToSelect($eszkoz_idk),
                [
                    'select' => '',
                    'limit' => '',
                    'kerdoiv_idk' => $this->arrToSelect($kerdoiv_idk),
                    'partner_idk' => $this->arrToSelect($partner_idk),
                    'telephely_idk' => $this->arrToSelect($telephely_idk),
                    'eszkoz_idk' => $this->arrToSelect($eszkoz_idk)
                ]
            ];

            $jelentesek = [];
            $attr[sizeof($attr)-1]['select'] = 'count(*) as cnt';
            $attr[sizeof($attr)-1]['limit'] = '';
            $cnt = $g['db_db']->jelentesek_sel_nyers_adatok(...$attr)[0]['cnt'];
            $attr[sizeof($attr)-1]['select'] = 'jf.*, bs.user_email, bs.user_id';
            $attr[sizeof($attr)-1]['limit'] = 'limit '.$params['talalat_tol'].','.$params['talalat_darab'];
            // $attr[sizeof($attr)-1]['limit'] = '';
            $jelentesek['kitoltesek'] = $g['db_db']->jelentesek_sel_nyers_adatok(...$attr);

            $jelentesek['van_kozte_beolvasasos'] = false;
            foreach ($jelentesek['kitoltesek'] as $kitoltes) {
                if (!is_null($kitoltes['fk_beolvasas_sorok'])) {
                    $jelentesek['van_kozte_beolvasasos'] = true;
                    break;
                }
            }

            $beolvasas_sor_idk = [];
            foreach ($jelentesek['kitoltesek'] as $kit) {
                if (!is_null($kit['fk_beolvasas_sorok'])) {
                    $beolvasas_sor_idk[$kit['fk_beolvasas_sorok']] = 1;
                }
            }
            if (!empty($beolvasas_sor_idk)) {
                $beolvasas_sor_idk = array_keys($beolvasas_sor_idk);
                $beolvasas_sor_idk = '(' . implode(", ", $beolvasas_sor_idk) . ')';

                $jelentesek['beolvasas_sorok'] = $g['db_db']->beolvasas_sor_jelentesek_sel(
                    [
                        'beolvasas_sor_idk' => $beolvasas_sor_idk
                    ]
                );
            } else {
                $jelentesek['beolvasas_sorok'] = [];
            }            

            $kitoltesek_idk = array_column($jelentesek['kitoltesek'], 'id');
            $jelentesek['valaszok'] = [];
            if (!empty($kitoltesek_idk)) {
                $kitoltesek_idk = '('.implode(',', $kitoltesek_idk).')';
                $jelentesek['valaszok'] = $g['db_db']->jelentes_valasz_sel_for_idk(['jelentes_fej_idk' => $kitoltesek_idk]);
            }

            $out = [
                'echo' => $params['echo'],
                'cnt' => $cnt,
                'data' => $jelentesek
            ];

            return $out;

        }

        private function arrToSelect(array $arr) {
            return empty($arr) ? '(1)' : '(' . implode(',', $arr) . ')';
        }

        private function varEmptyToNullToSelect($var) {
            return empty($var) ? null : $var;
        }

        private function arrEmptyToNullToSelect(array $arr) {
            return empty($arr) ? null : 1;
        }

    }
