<?php

namespace A;

class jelentesek_sel_ismerv_jelentes extends \GI\Ajax{

    public $rights_required = array(
        'jelentesek_megtekintese'
    );

    public $parameters = array(
        'echo' => 'int',
        'idopont_tol' => 'idopont_o',
        'idopont_ig' => 'idopont',
        'kerdes_id' => 'ex-kerdoivek_kerdesek-id',
        'beolvasas_idk' => 'beolvasas_id_arr',
        'ismerv_id' => 'ex-ismervek-id',
        'ismerv_ertekek' => 'ismerv_ertekek_arr'
    );

    public function ajax($params){

        global $g;

        $ismerv_ertekek = json_decode($params['ismerv_ertekek'], true);
        $beolvasas_idk = json_decode($params['beolvasas_idk'], true);

        $jelentesek = $g['db_db']->jelentesek_sel_ismerv_jelentes(
            $params['kerdes_id'],
            $params['ismerv_id'],
            $params['idopont_ig'],
            $params['idopont_tol'],
            $this->arrEmptyToNullToSelect($ismerv_ertekek),
            [
                'beolvasas_idk' => $this->strArrToSelect($beolvasas_idk),
                'ismerv_ertekek' => $this->strArrToSelect($ismerv_ertekek)
            ]
        );

        $out = [
            'echo' => $params['echo'],
            'data' => $jelentesek
        ];

        return $out;

    }

    private function arrToSelect(array $arr) {
        return empty($arr) ? '(1)' : '(' . implode(',', $arr) . ')';
    }

    private function strArrToSelect(array $arr) {
        return empty($arr) ? '(1)' : '("' . implode('","', $arr) . '")';
    }

    private function varEmptyToNullToSelect($var) {
        return empty($var) ? null : $var;
    }

    private function arrEmptyToNullToSelect(array $arr) {
        return empty($arr) ? null : 1;
    }

}
