<?php

    namespace A;

    class jelentesek_kitoltesek_szama_dashboard extends \GI\Ajax{

        public $rights_required = array(
            'jelentesek_megtekintese'
        );

        public $parameters = array(
            'partner_id' => 'ex-partnerek-id',
            'idopont_tol' => 'idopont',
            'idopont_ig' => 'idopont',
            'telephely_idk' => 'telephely_id_arr'
        );

        public function ajax($params){

            global $g;

            $telephely_idk = json_decode($params['telephely_idk'], true);
            $telephely_idk = '(' . implode(',', $telephely_idk) . ')';

            $out = [];
            $out['kitoltesek_szama'] = $g['db_db']->jelentesek_kitoltesek_szama(
                $params['partner_id'],
                $params['idopont_tol'],
                $params['idopont_ig'],
                ['telephelyek' => $telephely_idk]
            );
            $out['kitoltesek_szama_telephelyenkent'] = $g['db_db']->jelentesek_kitoltesek_szama_telephelyenkent(
                $params['partner_id'],
                $params['idopont_tol'],
                $params['idopont_ig'],
                ['telephelyek' => $telephely_idk]
            );
            $out['kitoltesek_szama_havonta'] = $g['db_db']->jelentesek_kitoltesek_szama_havonta(
                $params['partner_id'],
                $params['idopont_tol'],
                $params['idopont_ig'],
                ['telephelyek' => $telephely_idk]
            );

            return $out;

        }
    }
