<?php

    namespace A;

    class jelentesek_ervenytelenitese extends \GI\Ajax{

        public $rights_required = array(
            'jelentesek_ervenytelenitese'
        );

        public $parameters = array(
            'jelentes_fej_id' => 'ex-jelentesek_fej-id',
            'ervenytelen' => 'boolint',
            'kijeloltSorok' => 'ok'
        );

        public function ajax($params){

            global $g;

            $kijeloltSorok = json_decode($params['kijeloltSorok']);
            if (count($kijeloltSorok) > 0) {
                try {
                $g['db_db']->jelentes_fej_ervenytelenites_in(
                    $params['ervenytelen'],
                    [
                        'sorok' =>  '(' . implode(',', $kijeloltSorok) . ')',
                    ]
                );
            } catch (Exception $e) {
                echo $e;
            }
            } else {

            $g['db_db']->jelentes_fej_ervenytelenites(
                $params['ervenytelen'],
                $params['jelentes_fej_id']
            );

        }

        }
    }