<?php

    namespace A;

    use PhpOffice\PhpSpreadsheet\IOFactory;
    use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
    use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;
    use PhpOffice\PhpSpreadsheet\Cell\DataValidation;

    class import_valasz_engedelyezesek extends \GI\Ajax{

        public $rights_required = array(
            
        );

        public $parameters = array(

        );

        public function ajax($params){

            global $g;

            if (!isset($_FILES['file']['tmp_name'])) {
                return ['HI', 'nincs_fajl'];
            }

            if ($_FILES['file']['error'] !== UPLOAD_ERR_OK) {
                return ['HI', 'hibas_feltoltes'];
            }

            $filename = $_FILES['file']['tmp_name'];

            $questionId = explode('.', $_FILES['file']['name']);
            $questionId = $questionId[count($questionId) - 2];

            $spreadsheet = IOFactory::load($filename);

            $sheet = $spreadsheet->getSheet(0);

            $valaszMegjelenitesek = [];
            $osszesEszkoz = [];

            $i = 1;
            while (!empty($sorszam = $sheet->getCell("A$i")->getValue())) {
                $eszkozAzonosito = $sheet->getCell("B$i")->getValue();

                if (!isset($valaszMegjelenitesek[$sorszam])) {
                    $valaszMegjelenitesek[$sorszam] = [];
                }

                if (empty($eszkozAzonosito)) {
                    ++$i;
                    continue;
                }

                $valaszMegjelenitesek[$sorszam] []= $eszkozAzonosito;

                if (!isset($osszesEszkoz[$eszkozAzonosito])) {
                    $osszesEszkoz[$eszkozAzonosito] = $g['db_db']->get_eszkoz_sn_from_eszkoz_azonosito(
                        $eszkozAzonosito
                    )[0]['id'];
                }

                ++$i;
            }

            $g['db_db']->kerdes_valasz_tiltasok_torlese(
                $questionId
            );

            $sql = "insert into kerdoivek_kerdesek_valasz_tiltasok (`fk_kerdoivek_kerdesek`, `fk_eszkozok`, `valasz_sorszama`)\nvalues ";

            foreach ($valaszMegjelenitesek as $sorszam => $eszkozAzonositok) {
                foreach ($osszesEszkoz as $eszkozAzon => $eszkozId) {
                    if (!in_array($eszkozAzon, $eszkozAzonositok)) {
                        $sql .= "($questionId, $eszkozId, $sorszam),\n";

                        // $g['db_db']->kerdes_valasz_tiltasok_felvitele(
                        //     $questionId,
                        //     $eszkozId,
                        //     $sorszam
                        // );
                    }
                }
            }
            $sql = preg_replace('/(,)$/', ';', $sql);

            return ['OK', $sql];

        }

    }
