<?php

    namespace A;

    class felhasznalok_telephely_del extends \GI\Ajax{

        public $rights_required = array(
            'felhasznalok_telephely_torlese'
        );

        public $parameters = array(
            'felhasznalo_sn' => 'ex-users-id',
            'telephely_sn_arr' => 'telephely_id_arr'
        );

        public function ajax($params){

            global $g;

            // jog ellenorzes
            if(!\UserFunctions::kezelheto_entitas_e($_SESSION['user']['id'], 'felhasznalo', 'felhasznalok_telephely_torlese', $params['felhasznalo_sn'])){
                return ['HI', 'right_error'];
            }

            $telephelyek = json_decode($params['telephely_sn_arr'], true);
            // jog ellenorzes - felhasznalo - partner
            $allowedTelephelyek = \UserFunctions::getTelephelyekOfUser($params['felhasznalo_sn']);

            foreach ($telephelyek as $telephely) {
                if (!in_array($telephely, array_column($allowedTelephelyek, 'id'))) {
                    return ['HI', 'right_error'];
                }

                // partner hozzarendelese
                $g['db_db']->felhasznalo_del_telephely(
                    $telephely,
                    $params['felhasznalo_sn']
                );
            }
        }

    }
