<?php

    namespace A;

    class felhasznalok_partner_jog_sel extends \GI\Ajax{

        public $rights_required = array(
            'felhasznalok_partner_jogainak_megtekintese'
        );

        public $parameters = array(
            'echo' => 'int',
            'felhasznalo_sn' => 'ex-users-id',
            'partner_sn' => 'ex-partnerek-id'
        );

        public function ajax($params){

            global $g;

            // jog ellenorzes
            if(!\UserFunctions::kezelheto_entitas_e($_SESSION['user']['id'], 'felhasznalo', 'felhasznalok_partner_jogainak_megtekintese', $params['felhasznalo_sn'])){
                return ['HI', 'right_error'];
            }

            // jog ellenorzes - felhasznalo - partner
            $allowedPartnerek = \UserFunctions::getPartnersOfUser($params['felhasznalo_sn']);
            if (!in_array($params['partner_sn'], array_column($allowedPartnerek, 'id'))) {
                return ['HI', 'right_error'];
            }

            // jogok lekerdezese
            $res = $g['db_db']->partner_jogok_of_user_sel($params['partner_sn'], $params['felhasznalo_sn'], $g['lang']);

            $out = [
                'echo' => $params['echo'],
                'data' => $res
            ];

            return $out;

        }

    }
