<?php

    namespace A;

    class felhasznalok_partner_jog_add extends \GI\Ajax{

        public $rights_required = array(
            'felhasznalok_partner_jog_kezelese'
        );

        public $parameters = array(
            'felhasznalo_sn' => 'ex-users-id',
            'partner_sn' => 'ex-partnerek-id',
            'jogstruktura' => 'jogstruktura'
        );

        public function ajax($params){

            global $g;

            // jog ellenorzes
            if(!\UserFunctions::kezelheto_entitas_e($_SESSION['user']['id'], 'felhasznalo', 'felhasznalok_global_jog_kezelese', $params['felhasznalo_sn'])){
                return ['HI', 'right_error'];
            }

            // jog ellenorzes - felhasznalo - partner
            $allowedPartnerek = \UserFunctions::getPartnersOfUser($params['felhasznalo_sn']);
            if (!in_array($params['partner_sn'], array_column($allowedPartnerek, 'id'))) {
                return ['HI', 'right_error'];
            }

            // ellenorizni hogy a jogstrukturaban jo elemi jogok vannak-e
            $jogstruktura = json_decode($params['jogstruktura'], true);
            foreach ($jogstruktura as $jog) {
                if (!in_array($jog['elemi_jog_kod'], $g['jogok'])) {
                    return ['HI', 'nem_letezo_elemi_jog', $jog['elemi_jog_kod']];
                }
                // ellenorizni, hogy az adott partnerhez nekem van-e olyan jogom
                if (
                    $g['db_db']->user_has_global_right($_SESSION['user']['id'], $jog['elemi_jog_kod'])[0]['cnt'] < 1 &&
                    $g['db_db']->user_has_right_at_partner($_SESSION['user']['id'], $jog['elemi_jog_kod'], $params['partner_sn'])[0]['cnt'] < 1
                ) {
                    return ['HI', 'nincs_ilyen_jogom_a_partnerhez', $jog['elemi_jog_kod']];
                }
            }

            // hozzaadasok es torlesek elvegzese
            foreach ($jogstruktura as $jog) {
                if ($jog['hozzaadas']) {
                    $g['db_db']->add_jog_to_felhasznalo_partner($params['felhasznalo_sn'], $params['partner_sn'], $jog['elemi_jog_kod'], $_SESSION['user']['id']);
                } else {
                    $g['db_db']->del_jog_from_felhasznalo_partner($params['felhasznalo_sn'], $params['partner_sn'], $jog['elemi_jog_kod']);
                }
            }

        }

    }
