<?php

    namespace A;

    class felhasznalok_mod extends \GI\Ajax{

        public $rights_required = array(
            'felhasznalok_modositasa'
        );

        public $parameters = array(
            'felhasznalo_sn' => 'ex-users-id',
            'parameter_nev' => 'parameter_nev',
            'parameter_ertek' => 'ok'
        );

        public function ajax($params){

            global $g;

            // jog ellenorzes
            if(!\UserFunctions::kezelheto_entitas_e($_SESSION['user']['id'], 'felhasznalo', 'felhasznalok_modositasa', $params['felhasznalo_sn'])){
                return ['HI', 'right_error'];
            }

            // modositas
            $kapcsoloTabla = [
                'nev' => ['felhasznalo_nev', 'nev'],
                'email' => ['uj_user_email', 'email'],
                'telefon' => ['telefon_o', 'telefon'],
                'megjegyzes' => ['felhasznalo_megjegyzes', 'megjegyzes']
            ];

            if (!array_key_exists($params['parameter_nev'], $kapcsoloTabla)) {
                return ['HI', 'rossz_parameter_nev'];
            }

            if (!\GI\Functions::validate($params['parameter_ertek'], $kapcsoloTabla[$params['parameter_nev']][0])) {
                return ['HI', 'rossz_parameter_ertek'];
            }

            $g['db_db']->felhasznalok_mod(
                $params['parameter_ertek'],
                $params['felhasznalo_sn'],
                ['col' => $kapcsoloTabla[$params['parameter_nev']][1]]
            );

        }

    }
