<?php

    namespace A;

    class eszkozok_mod extends \GI\Ajax{

        public $rights_required = array(
            'eszkozok_modositasa'
        );

        public $parameters = array(
            'eszkoz_sn' => 'ex-eszkozok-id',
            'parameter_nev' => 'parameter_nev',
            'parameter_ertek' => 'ok'
        );

        public function ajax($params){

            global $g;

            // jog ellenorzes
            if(!\UserFunctions::kezelheto_entitas_e(
                $_SESSION['user']['id'],
                'eszkoz',
                'eszkozok_modositasa',
                $params['eszkoz_sn']
            )){
                return ['HI', 'right_error'];
            }

            // parameter ellenorzese
            $kapcsoloTabla = [
                'nev' => ['eszkoz_nev', 'nev'],
                'eszkoz_azonosito' => ['eszkoz_azonosito', 'eszkoz_azonosito'],
                'telephely_sn' => ['ex-telephelyek-id', 'fk_telephelyek'],
                'sorozatszam' => ['eszkoz_sorozatszam', 'sorozatszam'],
                'mac_cim' => ['eszkoz_mac_cim', 'mac_cim'],
                'felbontas' => ['eszkoz_felbontas', 'felbontas'],
                'dpi' => ['eszkoz_dpi', 'dpi'],
                'api_verzio' => ['eszkoz_api_verzio', 'api_verzio'],
                'online' => ['boolint', 'online']
            ];

            if (!array_key_exists($params['parameter_nev'], $kapcsoloTabla)) {
                return ['HI', 'rossz_parameter_nev'];
            }

            if (!\GI\Functions::validate($params['parameter_ertek'], $kapcsoloTabla[$params['parameter_nev']][0])) {
                return ['HI', 'rossz_parameter_ertek'];
            }

            // telephely ellenorzes ha pont azt akarja modositani
            if ($params['parameter_nev'] === 'telephely_sn') {
                $partner = \UserFunctions::getPartnerOfTelephely($params['parameter_ertek']);
                $partner_sn = $partner[0]['id'];
                if(!\UserFunctions::kezelheto_entitas_e(
                    $_SESSION['user']['id'],
                    'partner',
                    'eszkozok_modositasa',
                    $partner_sn
                )){
                    return ['HI', 'right_error'];
                }
            }

            $g['db_db']->eszkozok_mod(
                $params['parameter_ertek'],
                $params['eszkoz_sn'],
                ['col' => $kapcsoloTabla[$params['parameter_nev']][1]]
            );

        }

    }
