<?php

    namespace A;

    class eszkoz_nyitvatartas_new extends \GI\Ajax{

        public $rights_required = array(
            'eszkoz_vezerlese'
        );

        public $parameters = array(
            'eszkoz_id' => 'ex-eszkozok-id',
            'het_napjai' => 'het_napjai',
            'oraperc' => 'oraperc',
            'action' => 'ok',
            'content' => 'ok'
        );

        public function ajax($params){

            global $g;

            // jog ellenorzes
            if(!\UserFunctions::kezelheto_entitas_e($_SESSION['user']['id'], 'eszkoz', 'eszkoz_vezerlese', $params['eszkoz_id'])){
                return ['HI', 'right_error'];
            }

            $eszkoz_azonosito = $g['db_db']->get_eszkoz_azonosito_from_from_id($params['eszkoz_id'])[0]['eszkoz_azonosito'];

            try {

                foreach (str_split($_POST['het_napjai']) as $het_napja) {
                    $g['db_db']->add_eszkoz_vezerles_automata(
                        $eszkoz_azonosito,
                        $het_napja,
                        $params['oraperc'],
                        $params['action'],
                        $params['content']
                    );
                }

            } catch (\Exception $ex) {
                return ['HI', 'mar_letezik'];
            }

        }

    }
