<?php

    namespace A;

    class eszkoz_nyitvatartas_mod extends \GI\Ajax{

        public $rights_required = array(
            'eszkoz_vezerlese'
        );

        public $parameters = array(
            'eszkoz_sn' => 'ex-eszkozok-id',
            'vezerles_sn' => 'ex-eszkoz_vezerlesek_automata-id',
            'parameter_nev' => 'parameter_nev',
            'parameter_ertek' => 'ok'
        );

        public function ajax($params){

            global $g;

            // jog ellenorzes
            if(!\UserFunctions::kezelheto_entitas_e(
                $_SESSION['user']['id'],
                'eszkoz',
                'eszkoz_vezerlese',
                $params['eszkoz_sn']
            )){
                return ['HI', 'right_error'];
            }

            // parameter ellenorzese
            $kapcsoloTabla = [
                'oraperc' => ['oraperc', 'oraperc'],
                'het_napja' => ['het_napja', 'het_napja']
            ];

            if (!array_key_exists($params['parameter_nev'], $kapcsoloTabla)) {
                return ['HI', 'rossz_parameter_nev'];
            }

            if (!\GI\Functions::validate($params['parameter_ertek'], $kapcsoloTabla[$params['parameter_nev']][0])) {
                return ['HI', 'rossz_parameter_ertek'];
            }

            try {

                $g['db_db']->mod_eszkoz_vezerles_automata(
                    $params['parameter_ertek'],
                    $params['vezerles_sn'],
                    ['col' => $kapcsoloTabla[$params['parameter_nev']][1]]
                );

            } catch (\Exception $ex) {
                return ['HI', 'mar_letezik'];
            }

        }

    }
