<?php

    namespace GI;

    class TemplateEngine{

        public $variables = array();

        public function add($label,$value){
            $this->variables[$label] = $value;
        }

        public function get($label){
            return $this->variables[$label];
        }

        public function render($text, $minimize=true, $addslashes=false){

            //comments
            $pattern = '#/\*.+?\*/#s';
            while(preg_match($pattern,$text)===1){
                $text = preg_replace($pattern,'',$text);
            }

			$vars = &$this->variables;

			//else
            $text = preg_replace_callback('/\[\[else\]\]/i',function($match){
                return '<?php else:?>';
            },$text);

			//endforeach
            $text = preg_replace_callback('/\[\[endforeach\]\]/i',function($match) use ($vars){
                return '<?php endforeach;?>';
            },$text);

			//endif
            $text = preg_replace_callback('/\[\[endif\]\]/i',function($match){
                return '<?php endif;?>';
            },$text);

			//foreach multilevel
            $text = preg_replace_callback('/\[\[foreach \$__value([0-9]+)\]\]/i',function($match){
                return '<?php foreach($__value'.$match[1].' as $__key'.((int)$match[1]+1).' => $__value'.((int)$match[1]+1).'):?>';
            },$text);

            //foreach
            $text = preg_replace_callback('/\[\[foreach \$([a-z0-9\._]+)\]\]/i',function($match) use ($vars){
                return '<?php foreach($g[\'te\']->get(\''.$match[1].'\') as $__key1 => $__value1):?>';
            },$text);

            //array indexing __value
            $text = preg_replace_callback('/\[\[\$__value([0-9]+)\->([a-z0-9_]+)\]\]/i',function($match){
                if(ctype_digit($match[2])){
                    return '<?=$__value'.$match[1].'['.$match[2].']?>';
                }
                return '<?=$__value'.$match[1].'["'.$match[2].'"]?>';
            },$text);

            //array indexing
            $text = preg_replace_callback('/\[\[\$([a-z0-9\._]+)\->([a-z0-9_]+)\]\]/i',function($match){
                if(ctype_digit($match[2])){
                    return '<?=$g[\'te\']->get(\''.$match[1].'\')['.$match[2].']?>';
                }
                return '<?=$g[\'te\']->get(\''.$match[1].'\')["'.$match[2].'"]?>';
            },$text);

            //foreach value
            $text = preg_replace_callback('/\[\[\$__value([0-9]+)\]\]/i',function($match){
                return '<?=$__value'.$match[1].'?>';
            },$text);

            //foreach key
            $text = preg_replace_callback('/\[\[\$__key([0-9]+)\]\]/i',function($match){
                return '<?=$__key'.$match[1].'?>';
            },$text);

            //variables
            $text = preg_replace_callback('/\[\[\$([a-z0-9\._]+)\]\]/i',function($match) use ($vars, $addslashes){
                if(isset($vars[$match[1]])){
                    if(strpos($match[1],'.')===false){
                        return '<?=$g[\'te\']->get(\''.$match[1].'\')?>';
                    }
                    else{
                        if (substr($match[1], 0, 2) === 't.' && $addslashes) {
							return addcslashes($vars[$match[1]], '\'"');
						} else {
							return $vars[$match[1]];
						}
                    }
                }
                return $match[1];
            },$text);

			//if / elseif
            $text = preg_replace_callback('/\[\[(if|elseif)\s+([^\]]+)\]\]/i',function($match) use ($vars){
				$match[2] = preg_replace_callback('/\$([a-z0-9\._]+)/i',function($match2) use ($vars){
					if(preg_match('/__(value|key)\d/i',$match2[1])){
						return '$'.$match2[1];
					}
					elseif(isset($vars[$match2[1]])){
						if(strpos($match2[1],'.')===false){
							return '$g[\'te\']->get(\''.$match2[1].'\')';
						}
						else{
							return $vars[$match2[1]];
						}
					}
					return $match2[1];
				},$match[2]);
				$match[2] = preg_replace_callback('/(\->get\(\'[a-z0-9\._]+\'\))(\->[a-z0-9\._]+)/i',function($match2) use ($vars){
					return $match2[1].'[\''.substr($match2[2],2).'\']';
				},$match[2]);
				$match[2] = preg_replace_callback('/(\$__(value|key)\d)(\->[a-z0-9\._]+)/i',function($match2) use ($vars){
					return $match2[1].'[\''.substr($match2[3],2).'\']';
				},$match[2]);
				return '<?php '.$match[1].'('.$match[2].'):?>';
            },$text);

			//minimalizalas
			if($minimize){
				$text = preg_replace("/\t/",'',$text);
				$text = preg_replace("/\n/",'',$text);
				$text = preg_replace("/\r/",'',$text);
				$text = preg_replace("/\s+/",' ',$text);
			}

            return $text;

        }

    }
