<?php

	namespace GI;

	class MenuElement{
		
		private $text;
		private $link;
		private $popup;
		private $image;
		private $is_menugroup;
		
		function __construct($text,$link='',$image='',$popup='',$is_menugroup=false){
			$this->text = $text;
			$this->link = $link;
			if(empty($this->image)){
				$this->image = $image;
			}
			else{
				global $time;
				$this->image = \GI\Functions::get_full_url().substr($image,0,strrpos($image,'.')).'_'.$time.strrchr($image,'.');
			}
			$this->popup = $popup;
			$this->is_menugroup = $is_menugroup;
		}
		
		function getText(){
			return $this->text;
		}
		
		function getLink(){
			return $this->link;
		}
		
		function getImage(){
			return $this->image;
		}
		
		function getPopup(){
			return $this->popup;
		}
		
		function getIsMenuGroup(){
			return $this->is_menugroup;
		}
		
	}