<?php

    namespace GI;

    class Functions{

		public static function recursive_scandir($dir,$one_array=true){
			$result = array();
			$cdir = array_diff(scandir($dir),array('.','..'));
			foreach ($cdir as $key => $value){
				if(is_dir($dir.$value)){
					$child = self::recursive_scandir($dir.$value.'/',$one_array);
					if($one_array){
						$result[] = $dir.$value;
						$result = array_merge($result,$child);
					}
					else{
						$result[$dir.$value] = $child;
					}
				}
				else{
					$result []= $dir.$value;
				}
			}
			return $result;
		}

		public static function clear_cache(){
			$installed_f = GI_PATH_CACHE.'installed.txt';
			if(file_exists($installed_f)){
				unlink($installed_f);
			}
		}

		public static function get_random_string($length, $encryption_level = 5){
			$str = '';
			for($i=0;$i<$encryption_level;$i++)
			{
				$str = base64_encode(md5(microtime(true)*rand(1000000,9999999)).$str);
			}
			return substr($str, 0, $length);
		}

		public static function create_label_from_hun_text($text){
			return preg_replace('/[^a-z]/','_',str_replace(array('á','é','í','ó','ö','ő','ú','ü','ű'),array('a','e','i','o','o','o','u','u','u'),strtolower($text)));
		}

		public static function log($str){
			$file = GI_PATH_CACHE.'debug_'.session_id().'.txt';
			file_put_contents($file,serialize($str)."\n",FILE_APPEND);
		}

		public static function array_to_utf8(&$item, $key){
			$item = mb_convert_encoding($item,'UTF-8');
		}

		public static function num_encrypt($num){
			if(!GI_ENCRYPT) return $num;
			$prec = ini_get('precision');
			ini_set('precision',14);
			$n = log($num+sqrt(pow($num,2)+1));
			$n = (string)$n;
			$n = str_replace(array('.',','),'|',$n);
			$n2 = explode('|',$n);
			$l = strlen($n2[0]);
			$n = $l.str_replace('|','',$n);
			$n = strrev($n);
			ini_set('precision',$prec);
			return $n;
		}

		public static function num_decrypt($num){
			if(!GI_ENCRYPT) return $num;
			$prec = ini_get('precision');
			ini_set('precision',14);
			$num = strrev($num);
			$l = (int)substr($num,0,1);
			$n = substr($num,1);
			$num = substr($n,0,$l).'.'.substr($n,$l);
			$n = (pow(exp(1),$num)-pow(exp(1),-$num))/2;
			ini_set('precision',$prec);
			return round($n);
		}

		public static function url_decode($var){
			$change = array(
				'%C3%A1' => 'á',
				'%C3%81' => 'Á',
				'%C3%A9' => 'é',
				'%C3%89' => 'É',
				'%C3%AD' => 'í',
				'%C3%8D' => 'Í',
				'%C3%B3' => 'ó',
				'%C3%93' => 'Ó',
				'%C3%B6' => 'ö',
				'%C3%96' => 'Ö',
				'%C5%91' => 'ő',
				'%C5%90' => 'Ő',
				'%C3%BA' => 'ú',
				'%C3%9A' => 'Ú',
				'%C3%BC' => 'ü',
				'%C3%9C' => 'Ü',
				'%C5%B1' => 'ű',
				'%C5%Bö' => 'Ű'
			);
			return str_replace(array_keys($change),array_values($change),$var);

		}

		public static function includables_fix(&$value){
			$value = \GI\Functions::get_full_url().GI_PATH_INCLUDABLES.$value;
		}

		public static function get_full_url(){
			return str_replace(array('//',':/'),array('/','://'),GI_DOMAIN.GI_DIR.'/');
		}

        public static function emp(&$var,$default=''){
            if(empty($var)){
                return $default;
            }
            return $var;
        }

		public static function nvl(&$var,$default=''){
            if(!isset($var)){
                return $default;
            }
            return $var;
        }

        public static function validate($var,$datatype){
        	global $g;

            if (preg_match('/^n?ex\-/', $datatype)) {
                $validator = explode('-', $datatype);
        		list($prefix, $table, $col) = $validator;
        		if (isset($validator[3]) && $validator[3] === 'cbe' && $var == '') {
                    return true;
                }
                $res = $g['db_db']->isset_check($var, [
        			'table' => $table,
        			'col' => $col
        		]);

        		if ($prefix == 'ex') {
        			return $res[0]['cnt'] === '1';
        		}
        		return $res[0]['cnt'] === '0';
        	}

            return \DataTypes::$datatype($var);
        }

        public static function go($url, $lang = null){
			global $g;
			if(GI_DEBUG){
				echo'<pre>';var_dump(debug_backtrace());exit;
			}

			$lang = is_null($lang) ? $g['lang'] : $lang;
            header('Location: '.\GI\Functions::get_full_url().$lang.'/'.trim($url,'/').'/');
            exit;
        }

		public static function get_rights_with_one($array){
			$array_keys = array();
			foreach($array as $k=>$v){
				if($v===1){
					$array_keys[]=$k;
				}
			}
			return $array_keys;
		}

		public static function get_simple_text($text){
			$text = strtolower($text);
			$text = str_replace(
                ['á', 'Á', 'é', 'É', 'í', 'Í', 'ó', 'Ó', 'ö', 'Ö', 'ő', 'Ő', 'ú', 'Ú', 'ü', 'Ü', 'ű', 'Ű', ' '],
                ['a', 'a', 'e', 'e', 'i', 'i', 'o', 'o', 'o', 'o', 'o', 'o', 'u', 'u', 'u', 'u', 'u', 'u', '_'],
                $text
            );
			$text = preg_replace('/[^0-9a-z_\.]/', '_', $text);
			return $text;
		}

		public static function add_rendszerparameter_to_te($rendszerparameter) {
			global $g;
			$g['te']->add('rp_' . $rendszerparameter,
				json_encode($g['db_db']->get_rendszerparameter_ertekei($rendszerparameter))
			);
		}

		public static function ha_ures_legyen_null($var) {
			return empty($var) ? null : $var;
		}

		public static function generateRandomString($length = 10) {
		    $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
		    $charactersLength = strlen($characters);
		    $randomString = '';
		    for ($i = 0; $i < $length; $i++) {
		        $randomString .= $characters[rand(0, $charactersLength - 1)];
		    }
		    return $randomString;
		}

        public static function json_validator($dataOject, $semaFileName) {
            $jsonSchemaObject = json_decode(file_get_contents(GI_PATH_JSON_SEMA_FAJLOK . $semaFileName));
            $validator = new \JsonSchema\Validator;
            $validator->validate($dataOject, $jsonSchemaObject);
            return $validator->isValid();
        }

        public static function call_ajax($ajaxName, $parameters) {
            global $g;
            require_once GI_PATH_SITE_AJAX.$ajaxName.'.php';
            $tmp = '\A\\'.$ajaxName;
            $ajax = new $tmp();
            //rights needed
            if(!empty(array_diff($ajax->rights_required, $g['jogok']))){
                $response = array('err','missing_rights');
            }
            else{
                $response = $ajax->validate_parameters($parameters);
                if($response===true){
                    $tmp = $ajax->ajax($parameters);
                    if(is_array($tmp)){
                        $response = $tmp;
                    }
                    else{
                        $response = array('OK',$tmp);
                    }
                }
            }
            return $response;
        }

    }
